

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserIdForActivation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetUserIdForActivation()
--  |
--  |
--  |
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetUserIdForActivation')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUserIdForActivation <<<'
	drop procedure AppGetUserIdForActivation
END
IF EXISTS (select * from GxQscripts where name='AppGetUserIdForActivation')
	delete from GxQscripts where name = 'AppGetUserIdForActivation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserIdForActivation')
	delete from GXDBVersions where aliasname = 'AppGetUserIdForActivation'
GO
print '... Creating Procedure: AppGetUserIdForActivation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetUserIdForActivation
  @userName nvarchar(256),
  @localeId INTEGER,
  @clientId INTEGER
AS
  DECLARE @userId INTEGER
  DECLARE @planId INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @userId = 0
SET @planId = 0
SET @errorCode = 0
SET @errorString = N''
BEGIN TRY
	-- If username present, just convert to userId and return - SP11
	IF @userName <> N''
	BEGIN
		SET @userId = (SELECT ISNULL(id,0) from UMUSers where login = @userName)
		IF @userId <> 0
		BEGIN
			SET @errorCode = 18 --ACT_USER_MISSING
			SET @errorString = 'No user information available with the provided login'
		END
		GOTO GENERATE_OUTPUT
	END
	DECLARE @authCode NVARCHAR(64)
	DECLARE @authCompanyId INT
	-- Valid auth code then get the plan Id from the company
	-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForAuthCode.spb  ----------
IF @clientId <> 0
BEGIN
SELECT @authCode=attrval FROM APP_ClientProp WITH (NOLOCK) WHERE attrname='Authorization Code'
		AND componentNameId=@clientId AND modified=0
END
IF (@authCode IS NOT NULL)
BEGIN
SELECT @authCompanyID=componentNameId FROM APP_CompanyProp WITH (NOLOCK) WHERE attrname='Authorization Code'
AND attrVal=@authCode AND cs_attrName=checksum('Authorization Code')
	-- At the time of install the auth code might have been valid, we can still use that company id
	IF @authCompanyID IS NULL
	BEGIN
		SELECT @authCompanyID=CAST(attrval as INT) FROM
APP_ClientProp WHERE attrname='Installation Company ID' and modified = 0
	END
	SELECT @planId = AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
		INNER JOIN APP_CompanyProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=ACP.componentNameId AND ACP1.attrName='Always activate with default plan' AND ACP1.modified=0 AND ACP1.attrVal='1'
WHERE ACP.componentNameId=@authCompanyID AND ACP.attrName='Default Laptop Plan' AND ACP.modified=0 AND ACP.cs_attrName=checksum('Default Laptop Plan')
	IF ((@planId IS NULL) OR (@planId = 0))
	BEGIN
		-- Get Tenant Admin Id
		DECLARE @tenantAdminId_spb INT
		DECLARE @errorCode_spb INT
		DECLARE @errorMsg_spb NVARCHAR(1024)
		EXEC dbo.AppGetTenantAdminForCompany @authCompanyID, 0, @tenantAdminId_spb OUTPUT, @errorCode_spb OUTPUT, @errorMsg_spb OUTPUT
		IF (@errorCode_spb=0) AND (@tenantAdminId_spb > 0)
		BEGIN
			-- Get all plan for company
			IF OBJECT_ID('tempdb.dbo.#sec_tempGetPlans') IS NOT NULL
				DROP TABLE #sec_tempGetPlans
			CREATE TABLE #sec_tempGetPlans
			(
				planId INT
			)
EXEC sec_getNonIdaObjectsForThisUser @tenantAdminId_spb, 158,159,'#sec_tempGetPlans'
			DECLARE @laptopPlanId INT, @countLaptopPlan INT = 0
			SELECT @laptopPlanId=AP.id, @countLaptopPlan=COUNT(*) OVER ()  FROM #sec_tempGetPlans GP
			INNER JOIN APP_Plan AP WITH(NOLOCK)
ON AP.id=GP.planId AND AP.subType=33554439 AND (AP.flag & 0x00004 = 0) AND (AP.flag & 0x40000000 = 0)
			GROUP BY AP.id
			IF ((@countLaptopPlan = 1) AND (@laptopPlanId > 0))
			BEGIN
				DECLARE @rcnt_spb INT = 0
				DECLARE @nowTime_spb INT = dbo.getUnixTime(GETUTCDATE())
				--	-- Below is the summary of logic
				--	-- If there is only one laptop plan then use that plan to activate the laptops when the laptop is registered with tenant authcode.
				--	--	--Set the key for CVD to be able to auto add the first logged in user as owner or when the user logs in from edge monitor, the user can be added as owner of the laptop.
				--	--	--	-- If GxGlobalParam is set (for auto setup of default plan for client with authcode and it is pure Plan Mode)
				--	--		--	--	Do we set this one plan as default? - Yes
				--	--		--	--	Do we set the "Always activate with default plan" as ON? - Yes
				IF EXISTS (SELECT 1 FROM GxGlobalParam  WITH(NOLOCK) WHERE name='IsOnlyPlanModeEnforced' AND value='1')
				BEGIN
					-- Set Plan as default Plan
					-- Set Always activate with default plan for company
					UPDATE APP_CompanyProp SET attrval =  CAST(@laptopPlanId AS NVARCHAR(16))
WHERE attrname = 'Default Laptop Plan'
						AND componentNameId = @authCompanyID AND modified=0
AND cs_attrName=CHECKSUM('Default Laptop Plan')
					SET @rcnt_spb = @@ROWCOUNT
					IF (@rcnt_spb = 0)
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@authCompanyID, 'Default Laptop Plan', 7,  @laptopPlanId, @nowTime_spb, 0)
					END
					SET @rcnt_spb = 0
					UPDATE APP_CompanyProp SET attrval =  '1'
WHERE attrname = 'Always activate with default plan'
						AND componentNameId = @authCompanyID AND modified=0
AND cs_attrName=CHECKSUM('Always activate with default plan')
					SET @rcnt_spb = @@ROWCOUNT
					IF (@rcnt_spb = 0)
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@authCompanyID, 'Always activate with default plan', 7,  '1', @nowTime_spb, 0)
					END
				END
				-- All done
				-- SET Laptop Plan Id
				SET @planId = @laptopPlanId
			END
		END
	END
	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL DROP TABLE #getPlans
END
--- CODE ABOVE HERE IS FROM AppGetPlanForAuthCode.spb  ----------
	-------------------------------------------------------------------------------------------------------------------------------------------
	IF @planId = 0
	BEGIN
		-- GXglobalparam to check if its Secure Agent install,elevate the userId =1 and return
		DECLARE @secureAgentInstall INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'Secure Agent Install' AND modified = 0 ), 0)
IF @secureAgentInstall = 0 AND EXISTS (SELECT id FROM APP_PLAN where id > 0 AND subType = 33554439)
		BEGIN
			SET @userId = 1
			GOTO GENERATE_OUTPUT
		END
		ELSE
		BEGIN
			SET @errorCode = 21 --ACT_USER_REQUIRED_FOR_SECURE_INSTALLS
			SET @errorString = 'Secure Agent Install is turned on for the Commcell. Use a valid user for installs.'
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @userId,@planId,@errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserIdForActivation')
	delete from GxQscripts where name = 'AppGetUserIdForActivation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserIdForActivation')
	delete from GXDBVersions where aliasname = 'AppGetUserIdForActivation'
GO

insert into GXDBVersions values(2, 'AppGetUserIdForActivation',  '00000000000000000000', 'AppGetUserIdForActivation', '00000000000000000000')
GO

