

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserHasAccessToComponents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserHasAccessToComponents.sp,v $ $Id: AppGetUserHasAccessToComponents.sp,v 1.3.2.7 2018/03/22 01:31:12 jiechen Exp $";
--	+===================================================================+
--	| AppGetUserHasAccessToFeatures - Get licenses for user					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUserHasAccessToComponents <<<'

IF EXISTS (select * from sysobjects where name='AppGetUserHasAccessToComponents')
	drop procedure AppGetUserHasAccessToComponents
IF EXISTS (select * from GxQscripts where name='AppGetUserHasAccessToComponents')
	delete from GxQscripts where name = 'AppGetUserHasAccessToComponents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserHasAccessToComponents')
	delete from GXDBVersions where aliasname = 'AppGetUserHasAccessToComponents'
GO
print '... Creating Procedure: AppGetUserHasAccessToComponents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserHasAccessToComponents
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId int = 0, 
  @components nvarchar(max) = '',
  @o_xml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE @ComponentsTable               TABLE (component  nvarchar(255), value  nvarchar(1024))
	DECLARE @pos INT
	DECLARE @len INT
DECLARE @origCCId int = 2
	DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
	INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @userId , @origCCId, 2018, @origCCId
	DECLARE @commCellCap bigint = 0
	SELECT @commCellCap = ISNULL(nodeCap, 0) FROM @t_userCaps
	DECLARE @o_userHasCapability int
	SET @pos = 0
	SET @len = 0
	IF( charindex(',',@components, len(@components)-1) <> len(@components))
		SET @components = @components + ','
	WHILE CHARINDEX(',', @components, @pos+1)>0
	BEGIN
		set @len = CHARINDEX(',', @components, @pos+1) - @pos
		DECLARE @componentName nvarchar(255) = ''
		SET @componentName =  SUBSTRING(@components, @pos, @len)
		SET @o_userHasCapability = 0
		IF(@componentName = 'Reports.ManageReports')
		BEGIN
IF (@commCellCap & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0)
				SET @o_userHasCapability = 1;
			IF @o_userHasCapability = 0
EXECUTE sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '129,130,131'
		END
		ELSE IF(@componentName = 'Reports.ManageDataSources')
		BEGIN
IF (@commCellCap & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0)
				SET @o_userHasCapability = 1;
			IF @o_userHasCapability = 0
EXECUTE sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '121,122,123'
		END
		ELSE IF(@componentName = 'Billing.Admin')
		BEGIN
EXECUTE sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '172'
		END
		ELSE IF(@componentName = 'Billing.Manage')
		BEGIN
EXECUTE sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '172,173'
		END
		ELSE IF(@componentName = 'Billing.View')
		BEGIN
EXECUTE sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '172,173,182'
		END
		INSERT INTO @ComponentsTable values (@componentName,@o_userHasCapability)
		set @pos = CHARINDEX(',', @components, @pos+@len) +1
  END
	SET @o_xml =  ( SELECT component '@name', value '@value' FROM @ComponentsTable
        FOR XML PATH ('component'), ROOT('Api_GetHasAccessToComponentsResponse'))
	IF @o_xml IS NULL
            SET @o_xml = '<Api_GetHasAccessToComponentsResponse/>'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserHasAccessToComponents')
	delete from GxQscripts where name = 'AppGetUserHasAccessToComponents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserHasAccessToComponents')
	delete from GXDBVersions where aliasname = 'AppGetUserHasAccessToComponents'
GO

insert into GXDBVersions values(2, 'AppGetUserHasAccessToComponents',  '00010003000200070000', 'AppGetUserHasAccessToComponents', '00010003000200070000')
GO

