

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserGroups.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUserGroups <<<'

IF EXISTS (select * from sysobjects where name='AppGetUserGroups')
	drop procedure AppGetUserGroups
IF EXISTS (select * from GxQscripts where name='AppGetUserGroups')
	delete from GxQscripts where name = 'AppGetUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserGroups')
	delete from GXDBVersions where aliasname = 'AppGetUserGroups'
GO
print '... Creating Procedure: AppGetUserGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserGroups
  @xmlText XML
AS
---App_UserGroupListReq---
DECLARE @propertyLevel INT
IF 1 = (@xmlText.exist('(//App_UserGroupListReq/filterOptions/@propertyLevel)[1]'))
BEGIN
	SET @propertyLevel = @xmlText.value('(//App_UserGroupListReq/filterOptions/@propertyLevel)[1]','INT')
END
DECLARE @userId INT	= 0
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                            FROM    @xmlText.nodes('//App_UserGroupListReq/processinginstructioninfo/user') R ( ref )),0)
DECLARE @isRestrictedViewEnabled int = 0
SET @isRestrictedViewEnabled = ISNULL((SELECT  ref.value('@isrestrictedViewEnabled', 'int') AS Agent
                        FROM    @xmlText.nodes('//./filterOptions') R ( ref )),0)
DECLARE @forModification int = 1
SET @forModification = ISNULL((SELECT  ref.value('@forModification', 'int') AS Agent
                        FROM    @xmlText.nodes('App_UserGroupListReq') R ( ref )),1)
-----------------------Perform user capability check---------------------------------------
DECLARE @canManageAllUsers int = 0
	EXEC sec_canManageAllUsers @userId, @canManageAllUsers OUTPUT
----------------------------------------------------------------------------------------
DECLARE @IsHideEnabled int = 0
IF @canManageAllUsers = 0 AND @forModification = 0
	EXEC sec_isHideEnabled @userId, @isRestrictedViewEnabled, @IsHideEnabled OUTPUT
DECLARE @xmlQuery XML
IF @canManageAllUsers <> 0	or
	(@forModification = 0 AND @IsHideEnabled = 0)
BEGIN
	SET @xmlQuery =
	(SELECT
	(SELECT		UMGroups.id AS '@userGroupId',
				UMGroups.name AS '@userGroupName'
	FROM UMGroups
	WHERE (@isRestrictedViewEnabled <> 0 OR UMGroups.name <> 'CV_Restricted_Visibility')
			AND UMGroups.name <> 'Common Outlook Add-Ins'
	FOR XML PATH('availableSecurityGroups'), TYPE)
	FOR XML PATH('App_UserGroupList'), TYPE)
END
ELSE
BEGIN
	DECLARE @LocalGroups TABLE (groupId INT)
	INSERT INTO @LocalGroups
		EXEC sec_getLocalUserGroupsOfUser @userId
	SET @xmlQuery =
	(SELECT
	(SELECT UMGroups.id AS '@userGroupId', UMGroups.name AS '@userGroupName'
			FROM UMGroups INNER JOIN @LocalGroups ON UMGroups.id = [@LocalGroups].groupId
			WHERE UMGroups.name <> 'CV_Restricted_Visibility'
					AND UMGroups.name <> 'Common Outlook Add-Ins'
			ORDER BY UMGroups.id
	FOR XML PATH('availableSecurityGroups'), TYPE)
	FOR XML PATH('App_UserGroupList'), TYPE)
END
SELECT @xmlQuery AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserGroups')
	delete from GxQscripts where name = 'AppGetUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserGroups')
	delete from GXDBVersions where aliasname = 'AppGetUserGroups'
GO

insert into GXDBVersions values(2, 'AppGetUserGroups',  '00000000000000000000', 'AppGetUserGroups', '00000000000000000000')
GO

