

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserFileSystemUsage.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserFileSystemUsage.sp,v $ $Id: AppGetUserFileSystemUsage.sp,v 1.15.2.7 2019/12/02 22:25:22 nramalingam Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Get the user quota limit and space consumption
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetUserFileSystemUsage')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUserFileSystemUsage <<<'
	drop procedure AppGetUserFileSystemUsage
END
IF EXISTS (select * from GxQscripts where name='AppGetUserFileSystemUsage')
	delete from GxQscripts where name = 'AppGetUserFileSystemUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserFileSystemUsage')
	delete from GXDBVersions where aliasname = 'AppGetUserFileSystemUsage'
GO
print '... Creating Procedure: AppGetUserFileSystemUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserFileSystemUsage
  @xmlText XML
AS
SET NOCOUNT ON;
--
BEGIN TRY
	--
	-- get user id for rest of the stored procedure
	-- give precedence to user-id over user-guid to address condition where multiple users have empty guids
	DECLARE @userId int =
		(SELECT TOP(1) id
		FROM UMUsers U WITH (NOLOCK)
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 -- only enabled, non-deleted, non-hidden users
		AND U.id =
			(SELECT N.value(N'@userId', N'nvarchar(max)')
			FROM @xmlText.nodes (N'App_FSUserUsage') AS T(N)));
	--
	IF @userId IS NULL
		SET @userId =
		(SELECT TOP(1) id
		FROM UMUsers U WITH (NOLOCK)
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 -- only enabled, non-deleted, non-hidden users
		AND U.userGuid =
			(SELECT N.value(N'@userGuid', N'nvarchar(max)')
			FROM @xmlText.nodes (N'App_FSUserUsage') AS T(N)));
	--
	IF @userId IS NULL
		RAISERROR(N'Error fetching the user information.', 16, 1);
	IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL
	DROP TABLE #usageData;
	--
	CREATE TABLE #usageData
	(
		id int,
		name nvarchar(max),
		login nvarchar(max),
		email nvarchar(max),
		userGuid nvarchar(max),
		quotaLimit bigint,
		spaceConsumed bigint
	);
	INSERT INTO #usageData
	SELECT U.id, U.name, U.login, U.email, U.userGuid, CAST(UP.attrVal AS BIGINT) AS quotaLimit, CAST(UP2.attrVal AS BIGINT) AS spaceConsumed
FROM UMUsers U WITH (NOLOCK) JOIN UMUsersProp UP WITH (NOLOCK) ON U.Id = UP.componentNameId AND UP.attrName = 'FSQuotaLimit'
JOIN UMUsersProp UP2 WITH (NOLOCK) ON U.Id = UP2.componentNameId AND UP2.attrName = 'FSQuotaUsage'
	WHERE U.id = @userId
	-- get subclient id whose space-consumed value be read from input instead of from database
    DECLARE @replaceAppId int =
        (SELECT TOP(1) id
        FROM APP_Application A WITH (NOLOCK)
        WHERE A.id =
            (SELECT N.value(N'@replaceAppId', N'int')
            FROM @xmlText.nodes (N'App_FSUserUsage') AS T(N)));
    --
    -- space-consumed by subclient in bytes, to replace the one in database
    DECLARE @replaceSpaceConsumed bigint =
        (SELECT N.value(N'@replaceSpaceConsumed', N'bigint')
        FROM @xmlText.nodes (N'App_FSUserUsage') AS T(N));
	IF @replaceAppId > 0
	BEGIN
		DECLARE @oldSubclientUsage BIGINT = 0
		SELECT @oldSubclientUsage = CAST(SP.attrVal as bigint)
		FROM APP_Application A WITH (NOLOCK)
		LEFT JOIN APP_SubClientProp SP WITH (NOLOCK) ON A.id = SP.componentNameId AND SP.attrName = N'Application Size' AND SP.modified = 0
WHERE A.subclientStatus & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0 -- only non-deleted, non-hidden subclients
		AND A.id = @replaceAppId
		-- If replaceAppId is passed, we need to use the @replaceSpaceConsumed for that subclient. @oldSubclientUsage is already incorporated in #usageData table, so subtract that.
		UPDATE #usageData SET spaceConsumed = spaceConsumed - @oldSubclientUsage + @replaceSpaceConsumed
	END
	-- return the xml response
	SET @xmlText =
		(SELECT
			U.id AS N'@userId',
			U.name AS N'@name',
			U.login AS N'@login',
			U.email AS N'@email',
			U.userGuid AS N'@userGuid',
			ISNULL(quotaLimit, 0) AS N'@quotaLimit',
			ISNULL(spaceConsumed, 0) AS N'@spaceConsumed'
		FROM #usageData U
		FOR XML PATH(N'App_FSUserUsage'), TYPE);
	--
	IF OBJECT_ID(N'tempdb..#usageDataXML', N'U') IS NOT NULL
		INSERT INTO #usageDataXML (usage) VALUES (@xmlText);
	ELSE
		SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS N'@errorCode', ERROR_MESSAGE() AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
	IF OBJECT_ID(N'tempdb..#usageDataXML', N'U') IS NOT NULL
		INSERT INTO #usageDataXML (usage) VALUES (@xmlText);
	ELSE
		SELECT @xmlText;
END CATCH
	IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL
	DROP TABLE #usageData;
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserFileSystemUsage')
	delete from GxQscripts where name = 'AppGetUserFileSystemUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserFileSystemUsage')
	delete from GXDBVersions where aliasname = 'AppGetUserFileSystemUsage'
GO

insert into GXDBVersions values(2, 'AppGetUserFileSystemUsage',  '00010015000200070000', 'AppGetUserFileSystemUsage', '00010015000200070000')
GO

