

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserExchangeSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserExchangeSubclient.sp,v $ $Id: AppGetUserExchangeSubclient.sp,v 1.1.2.6 2018/03/27 08:57:40 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUserExchangeSubclient <<<'

IF EXISTS (select * from sysobjects where name='AppGetUserExchangeSubclient')
	drop procedure AppGetUserExchangeSubclient
IF EXISTS (select * from GxQscripts where name='AppGetUserExchangeSubclient')
	delete from GxQscripts where name = 'AppGetUserExchangeSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserExchangeSubclient')
	delete from GXDBVersions where aliasname = 'AppGetUserExchangeSubclient'
GO
print '... Creating Procedure: AppGetUserExchangeSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserExchangeSubclient
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer
AS
SET NOCOUNT ON
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_xmlText XML
DECLARE @errorCode      AS integer                  = 0                             -- BE OPTIMISTIC
DECLARE @errorString    AS varchar(2048)            = ''
DECLARE @mailboxGuid nvarchar(255) = (SELECT userGuid from umusers where id=@userId)
DECLARE @excludeStatusMask int = (cast(0x00004  as int) | cast(0x00020 as int) |  cast(0x00002 as int))
DECLARE @formatedMailboxGuid as nvarchar(255)
SET  @formatedMailboxGuid = '{' +  REPLACE(@mailboxGuid,'-','X') + '}'
SET @formatedMailboxGuid = UPPER(@formatedMailboxGuid)
--For 9.0 clients
DECLARE @formatedUserGuid9 as nvarchar(255)
set @formatedUserGuid9 =  Replace(substring(@mailboxGuid,7,2)+substring(@mailboxGuid,5,2)+substring(@mailboxGuid,3,2)+substring(@mailboxGuid,1,2)
+ substring(@mailboxGuid,12,2) + substring(@mailboxGuid,10,2)
+ substring(@mailboxGuid,17,2) + substring(@mailboxGuid,15,2)
+ substring(@mailboxGuid,19,18),'-','')
IF object_id('tempdb.dbo.#userMailBoxInfo') IS NOT null DROP TABLE #userMailBoxInfo
CREATE TABLE #userMailBoxInfo
(
   id      integer identity(1,1),
    appId				int,
    appName				nvarchar(255),
    cId				int,
    clientName				nvarchar(255),
    bsetId				int,
    backupSetName			nvarchar(128),
    subId				int,
    subClientName			nvarchar(128)
)
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 BEGIN TRY
	IF object_id('tempdb.dbo.#clientListTmp') IS NOT null DROP TABLE #clientListTmp
create table  #clientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2012, 0, '#clientListTmp'
	INSERT INTO #userMailBoxInfo
    SELECT distinct a.appTypeId, ida.name,
	a.clientId, c.name, a.backupSet, bs.name, a.id,a.subclientName
    FROM APP_Application a
    INNER JOIN APP_Client c ON c.id = a.clientId
	INNER JOIN APP_BackupSetName bs ON
			 bs.id=a.backupSet
	INNER JOIN APP_iDAType ida on
			 ida.type=a.appTypeId
	INNER JOIN APP_SubClientProp sp ON a.id = sp.componentNameId and sp.attrType=111
	INNER JOIN APP_ComponentProp e ON e.propertyTypeId=1103 and  e.componentType = 7 and e.componentId = sp.id and e.modified = 0 AND (e.stringVal = @formatedMailboxGuid or e.stringVal =@formatedUserGuid9)
INNER JOIN #clientListTmp SEC on ((capabilities & CONVERT(bigint, (POWER(2.0,  24  -1))) <> 0 )  OR (capabilities & CONVERT(bigint, (POWER(2.0, 13  -1))) <> 0 ))
	AND(
	(sec.clientId=a.clientId and sec.appTypeId=0 and sec.instanceId=0 and sec.backupsetId=0)
	OR
	(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=0 and sec.backupsetId=0)
	OR
	(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=0)
	OR
	(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=A.backupSet)
	 OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
	(
	sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
	))
    WHERE (subclientStatus & @excludeStatusMask =0)
    --GET PST backupset(Merge the queries)
	 DECLARE @getPSTMailboxForAUser int =0
    IF EXISTS(SELECT * FROM gxglobalparam WHERE name = 'showPSTMailBoxByLoggedInUser' AND value=1  and modified=0)
		SET @getPSTMailboxForAUser=1
    IF(@getPSTMailboxForAUser=0)
	BEGIN
		INSERT INTO #userMailBoxInfo
		SELECT distinct a.appTypeId,ida.name,
		a.clientId, c.name, a.backupSet, bs.name, a.id,a.subclientName
		FROM APP_Client c
		INNER JOIN  APP_Application a ON c.id = a.clientId
		INNER JOIN APP_BackupSetName bs ON
			 bs.id=a.backupSet
		INNER JOIN APP_iDAType ida on
			 ida.type=a.appTypeId
		INNER JOIN APP_SubClientProp sp ON sp.cs_attrName = CHECKSUM(N'ReferenceCopy PST Archiving') and a.id = sp.componentNameId and sp.modified =0  and sp.attrName=N'ReferenceCopy PST Archiving'--CV_REFERENCECOPY_PST_ARCHIVING
INNER JOIN #clientListTmp SEC on ((capabilities & CONVERT(bigint, (POWER(2.0,  24   -1))) <> 0 )  OR (capabilities & CONVERT(bigint, (POWER(2.0, 13  -1))) <> 0 ))
		AND(
		(sec.clientId=a.clientId and sec.appTypeId=0 and sec.instanceId=0 and sec.backupsetId=0)
		OR
		(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=0 and sec.backupsetId=0)
		OR
		(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=0)
		OR
		(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=A.backupSet)
		OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
		(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
		))
		WHERE  (subclientStatus & @excludeStatusMask = 0)
		AND a.backupSet not in (SELECT bsetId from #userMailBoxInfo)
	END
	ELSE
		INSERT INTO #userMailBoxInfo
		 SELECT  distinct a.appTypeId, ida.name,
		a.clientId, c.name, a.backupSet, bs.name, a.id,a.subclientName
		 FROM APP_Client c
		INNER JOIN APP_Application a on c.id = a.clientId
		INNER JOIN APP_BackupSetName bs ON
			 bs.id=a.backupSet
		INNER JOIN APP_iDAType ida on
			 ida.type=a.appTypeId
		INNER JOIN APP_SubClientProp sp on sp.cs_attrName = CHECKSUM(N'ReferenceCopy PST Archiving') AND sp.id = sp.componentNameId and sp.attrName=N'ReferenceCopy PST Archiving'--CV_REFERENCECOPY_PST_ARCHIVING
			AND sp.modified =0
		INNER JOIN APP_ComponentProp cp on cp.componentId=sp.componentNameId  and cp.modified=0 AND cp.propertyTypeId= 2300 and cp.stringVal= @formatedMailboxGuid
		--INNER JOIN UMUsers u on u.id = @userId
INNER JOIN #clientListTmp SEC on ((capabilities & CONVERT(bigint, (POWER(2.0,  24   -1))) <> 0 )  OR (capabilities & CONVERT(bigint, (POWER(2.0, 13  -1))) <> 0 ))
	AND(
	(sec.clientId=a.clientId and sec.appTypeId=0 and sec.instanceId=0 and sec.backupsetId=0)
	OR
	(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=0 and sec.backupsetId=0)
	OR
	(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=0)
	OR
	(sec.clientId=a.clientId and sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=A.backupSet)
	 OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
	(
	sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
	))
		WHERE (subclientStatus & @excludeStatusMask = 0)
		AND a.backupSet not in (select bsetId from #userMailBoxInfo)
	SET @o_xmlText =(
	SELECT
	(SELECT  cId AS '@clientId',clientName AS '@clientName',
		   appId AS '@applicationId', appName AS '@appName',
		   bsetId AS '@backupsetId', backupSetName AS '@backupsetName',
		   subId AS '@subclientId', subclientName AS '@subclientName'
			FOR XML PATH('subClientEntity'),TYPE)
	FROM #userMailBoxInfo finalmb
				FOR XML PATH('subClientProperties'), ROOT('App_GetSubClientPropertiesResponse'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode   = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT
                                    (SELECT
                                        @errorCode AS '@errorCode',
                                         @errorString AS '@errorString'
                                    FOR XML PATH('errors'), TYPE)
                                FOR XML PATH(''), ROOT('App_GetSubClientPropertiesResponse'))
END CATCH
IF object_id('tempdb.dbo.#clientListTmp') IS NOT null DROP TABLE #clientListTmp
IF object_id('tempdb.dbo.#userMailBoxInfo') IS NOT null DROP TABLE #userMailBoxInfo
SELECT ISNULL(@o_xmlText, '<App_GetSubClientPropertiesResponse/>') o_xmlText
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserExchangeSubclient')
	delete from GxQscripts where name = 'AppGetUserExchangeSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserExchangeSubclient')
	delete from GXDBVersions where aliasname = 'AppGetUserExchangeSubclient'
GO

insert into GXDBVersions values(2, 'AppGetUserExchangeSubclient',  '00010001000200060000', 'AppGetUserExchangeSubclient', '00010001000200060000')
GO

