

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserEdgeDriveQuota.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2016  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserEdgeDriveQuota.sp,v $ $Id: AppGetUserEdgeDriveQuota.sp,v 1.1.2.4 2017/04/01 17:39:15 nramalingam Exp $";
-- =========================================================
-- Author: Niresh Ramalingam
-- Description: Get the user edge drive quota
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUserEdgeDriveQuota <<<'

IF EXISTS (select * from sysobjects where name='AppGetUserEdgeDriveQuota')
	drop procedure AppGetUserEdgeDriveQuota
IF EXISTS (select * from GxQscripts where name='AppGetUserEdgeDriveQuota')
	delete from GxQscripts where name = 'AppGetUserEdgeDriveQuota'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserEdgeDriveQuota')
	delete from GXDBVersions where aliasname = 'AppGetUserEdgeDriveQuota'
GO
print '... Creating Procedure: AppGetUserEdgeDriveQuota'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserEdgeDriveQuota
  @xmlText XML
AS
SET NOCOUNT ON;
	-- code ported from AppGetUserFileSystemUsage
	-- get user id for rest of the stored procedure
	DECLARE @userId int =
		(SELECT TOP(1) id
		FROM UMUsers U WITH (NOLOCK)
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 -- only enabled, non-deleted, non-hidden users
		AND U.id =
			(SELECT N.value(N'@userId', N'nvarchar(max)')
			FROM @xmlText.nodes (N'Api_GetUserEdgeDriveQuotaLimitReq') AS T(N)));
	-- get quota limit of user
	DECLARE @quotaLimit bigint = NULL; -- NULL (or 0) means no quota limit (infinite quota)
	--
	-- does user inherits quota configuration from his/her group?
	-- default to 'inherits-group-quota' if user property is not set
	IF EXISTS
		(SELECT * FROM UMUsersProp UP WITH (NOLOCK)
		WHERE UP.componentNameId = @userId
AND UP.attrName = 'UMDS User Inherits Edge Drive Quota' AND UP.attrVal = N'0')
	BEGIN
		-- get user quota limit
		SET @quotaLimit =
			(SELECT TOP(1) (CAST(UP1.attrVal as bigint) * 1024 * 1024 * 1024)
			FROM UMUsersProp UP1 WITH (NOLOCK)
WHERE UP1.attrName = 'Edge Drive Quota Size'
			AND UP1.componentNameId IN
				(SELECT UP2.componentNameId
				FROM UMUsersProp UP2 WITH (NOLOCK)
WHERE UP2.attrName = 'Enforce Edge Drive Quota'
				AND UP2.attrVal = N'1'
				AND UP2.componentNameId = @userId));
	END
	ELSE
	BEGIN
		-- get group quota limit
		-- for debugging purpose, let groups without quota limit be added to the temporary table
		IF OBJECT_ID(N'tempdb..#groupWiseQuota', N'U') IS NOT NULL
			DROP TABLE #groupWiseQuota;
		--
		CREATE TABLE #groupWiseQuota
		(
			groupId int NOT NULL,
			enforceQuota bit NOT NULL,
			quotaLimitGB int NOT NULL
		);
		--
		INSERT INTO #groupWiseQuota (groupId, enforceQuota, quotaLimitGB)
			SELECT G.id, ISNULL(GP1.attrVal, 0), ISNULL(GP2.attrVal, 0)
			FROM UMGroups G WITH (NOLOCK)
LEFT JOIN UMGroupsProp GP1 WITH (NOLOCK) ON G.id = GP1.componentNameId AND GP1.attrName = 'Enforce Edge Drive Quota'
LEFT JOIN UMGroupsProp GP2 WITH (NOLOCK) ON G.id = GP2.componentNameId AND GP2.attrName = 'Edge Drive Quota Size'
WHERE (G.groupFlags & 0x0001) <> 0 -- select enabled groups
AND (G.groupFlags & 0x0002) = 0 -- ignore deleted groups
			AND G.id IN
				(SELECT UG.groupId
				 FROM UMUserGroup UG WITH (NOLOCK)
				 WHERE UG.userId = @userId
				 UNION
				 SELECT UMDSGroupMaps.umGroupId
				 FROM UMDSGroupMaps WITH (NOLOCK)
				 WHERE UMDSGroupMaps.umdsGroupId IN (SELECT UMUserGroup.groupId
													 FROM UMUserGroup WITH (NOLOCK)
													 WHERE UMUserGroup.userId = @userId)
				);
		--
		SET @quotaLimit =
			(SELECT CAST(MAX(Q.quotaLimitGB) as bigint) * 1024 * 1024 * 1024
			FROM #groupWiseQuota Q
			WHERE Q.enforceQuota <> 0 -- ignore user groups without quota enforced
			AND Q.quotaLimitGB <> 0); -- ignore user groups without quota limit
		--
		DROP TABLE #groupWiseQuota;
	END
	--
	-- return the xml response
	SET @xmlText = (SELECT @quotaLimit AS N'@quotaLimit' FOR XML PATH(N'Api_GetUserEdgeDriveQuotaLimitRes'), TYPE);
	SELECT @xmlText;
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserEdgeDriveQuota')
	delete from GxQscripts where name = 'AppGetUserEdgeDriveQuota'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserEdgeDriveQuota')
	delete from GXDBVersions where aliasname = 'AppGetUserEdgeDriveQuota'
GO

insert into GXDBVersions values(2, 'AppGetUserEdgeDriveQuota',  '00010001000200040000', 'AppGetUserEdgeDriveQuota', '00010001000200040000')
GO

