

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserCentricClientInputs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetUserCentricClientAssociation()
--  |
--  | Description:  SP for Validating the activation and reassociating to the physical client
--  |
--  |       Input:  Physical client(laptop) ID, pseudo client id, user id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To activate a laptop client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUserCentricClientInputs <<<'

IF EXISTS (select * from sysobjects where name='AppGetUserCentricClientInputs')
	drop procedure AppGetUserCentricClientInputs
IF EXISTS (select * from GxQscripts where name='AppGetUserCentricClientInputs')
	delete from GxQscripts where name = 'AppGetUserCentricClientInputs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserCentricClientInputs')
	delete from GXDBVersions where aliasname = 'AppGetUserCentricClientInputs'
GO
print '... Creating Procedure: AppGetUserCentricClientInputs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserCentricClientInputs
  @physicalClientId INT
AS
  DECLARE @osId INT
  DECLARE @appType INT
  DECLARE @laptopType INT
  DECLARE @error INT
  DECLARE @errorStr nvarchar(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientId INT
SET @error = 0
SET @errorStr = N''
-- Physical has package installed
-- Retrieve the FS apptype of Physical client
SELECT @clientId = C.id  ,
@osId = C.simOperatingSystemId,
@appType = Ida.appTypeId
FROM APP_CLIENT C JOIN APP_IDAName Ida ON C.id = Ida.clientId
JOIN simInstalledPackages SP ON Sp.ClientId = Ida.clientId  -- Package installed. File system on laptop
where C.id = @physicalClientId
AND Ida.appTypeId in (SELECT appTypeId FROM APP_AppTypeGroupAssoc where appGroupId = 35)
AND SP.simPackageID in (1,1002) -- FS Ida
IF @clientId = NULL OR @clientId = 0
BEGIN
	SET @error = 1
	SET @errorStr = N'Invalid Input. Verify if the physical client has package installed.'
	GOTO GENERATE_OUT
END
SET @laptopType = (select (case type
						When 'Windows' then 2
						else (case subtype
							  when 'Darwin' then 4
							  else 3 end)
							  end
						)
						from simOperatingSystem where id = @osId)
GENERATE_OUT:
	SELECT @osId,@appType,@laptopType,@error,@errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserCentricClientInputs')
	delete from GxQscripts where name = 'AppGetUserCentricClientInputs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserCentricClientInputs')
	delete from GXDBVersions where aliasname = 'AppGetUserCentricClientInputs'
GO

insert into GXDBVersions values(2, 'AppGetUserCentricClientInputs',  '00000000000000000000', 'AppGetUserCentricClientInputs', '00000000000000000000')
GO

