

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserCentricClientAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetUserCentricClientAssociation()
--  |
--  | Description:  SP for retrieving the client association for a user (User centric or Device Centric)
--  |
--  |       Input:  XML : with userId, ostype (WINDOWS / MAC/ UNIX ) and the requested type
--  |      Output:  XML : with list of clients ; failue error code and error string
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To activate a laptop client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetUserCentricClientAssociation')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUserCentricClientAssociation <<<'
	drop procedure AppGetUserCentricClientAssociation
END
IF EXISTS (select * from GxQscripts where name='AppGetUserCentricClientAssociation')
	delete from GxQscripts where name = 'AppGetUserCentricClientAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserCentricClientAssociation')
	delete from GXDBVersions where aliasname = 'AppGetUserCentricClientAssociation'
GO
print '... Creating Procedure: AppGetUserCentricClientAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserCentricClientAssociation
  @xmldata XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @errorCode INT=0
	DECLARE @errorString nvarchar(MAX)=N''
	DECLARE @executor INT=0
	DECLARE @userId INT=0
	DECLARE @userCentricClients table ( pseudoClientId INT)
	DECLARE @clientList XML
	DECLARE @type INT=0
    DECLARE @flag INT = 0
    SET @flag = (SELECT ISNULL(ref.value('@getAssociationFlags', 'INTEGER'),1) FROM @xmldata.nodes('App_GetAssociatedUserCentricClientsReq') R ( ref ))
	SET @type =(SELECT ISNULL(ref.value('@type', 'INTEGER'),1) FROM @xmldata.nodes('App_GetAssociatedUserCentricClientsReq') R ( ref ))
	SET @userId =(SELECT ISNULL(ref.value('user[1]/@userId', 'INTEGER'),0) FROM @xmldata.nodes('App_GetAssociatedUserCentricClientsReq') R ( ref ))
	SET @executor = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmldata.nodes('App_GetAssociatedUserCentricClientsReq/processinginstructioninfo/user') R ( ref )),0)
	IF @executor <> @userId and  @executor <> 0
	BEGIN
		-- TO DO: Decide if the user executing this request has visibility on the user he is asking data for
		-- Can manage user
		DECLARE @ret INT = 1
		exec Sec_canManageUser @executor,@userID,1,@ret output
		If @ret <> 1
		BEGIN
			SET @errorCode = 1
            SET @errorString = N'Caller does not have rights to access user info'
		END
	END
	DECLARE @planId INTEGER
	DECLARE @userCentric INTEGER
	-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForUser.spb  ----------
-- in order to use variables to be declared are : INPUT : @userId INT, OUTPUT @plandId INT, userCentric INT
-- also "SPBodies\AppPlanConstants.spb" should be included before using this snippet
-- Check If user preference for activation of laptop as user centric client is disabled
-- As per discussion with Bhavyan - We will refer only those user groups which are assigned to a plan to determine user activation type
-- Sequence - User->Global Level->Company Level(for Sp11 at advance settings)->User Group Level
-- Item higher in priority order is checked for for User Centric preference only.
-- If someone has "Device Centric" set at higher level in priority but still has user centric down the line, then we will use user centric
DECLARE @userOrgId INT = dbo.AppGetOrganizationForUser(@userId)
DECLARE @priTable AS TABLE (fIsUserCentric INT, PriorityLevel INT)
INSERT INTO @priTable
    SELECT UUP.attrVal, 1 from UMUsers UU WITH(NOLOCK) INNER JOIN UMUsersProp UUP WITH(NOLOCK) ON UU.id=UUP.componentNameId
WHERE UU.id = @userId AND (UUP.attrName = 'Prefer Machine Centric Client' AND UUP.attrType = 7)
	UNION ALL
SELECT value, 2 from GXGlobalParam WITH(NOLOCK) where name='Prefer Machine Centric Client' AND value=N'0'
	UNION ALL
SELECT CAST(attrval AS INT), 3 FROM App_CompanyProp WITH(NOLOCK) WHERE attrname='Prefer Machine Centric Client' AND componentNameId=@userOrgId AND attrval=N'0' AND  cs_attrName = checksum('Prefer Machine Centric Client')
	UNION ALL
    SELECT UGP.attrVal, 4  from UMUserGroup UUG WITH(NOLOCK)
		INNER JOIN UMGroupsProp UGP WITH(NOLOCK) ON UGP.componentNameId=UUG.groupId
INNER JOIN App_PlanProp APP WITH(NOLOCK) ON APP.attrVal=CAST(UUG.groupId AS NVARCHAR(64)) AND APP.attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')
WHERE UUG.userId = @userId AND (UGP.attrName = 'Prefer Machine Centric Client' AND UGP.attrType = 7 and UGP.attrVal='0')
DECLARE @fIsPreferenceMachineCentric INT = ISNULL((select TOP 1 fIsUserCentric  from @priTable order by PriorityLevel),1)
IF (@fIsPreferenceMachineCentric IS NOT NULL AND @fIsPreferenceMachineCentric = 1) OR (@fIsPreferenceMachineCentric IS NULL)
BEGIN
    SET @userCentric = 0
END ELSE BEGIN
    SET @userCentric = 1
END
-- check for direct plan association
SELECT @planId = CAST(attrVal AS INT) FROM UMUsersProp UUP WITH(NOLOCK)
	INNER JOIN App_Plan AP
ON UUP.attrVal=CAST(AP.id AS NVARCHAR(64)) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE UUP.componentNameId = @userId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
-- if there was no direct association try to get plan associated with the group to which user belongs
IF @planId IS NULL OR @planId = 0
BEGIN
	-- For device centric user, all type of group are OK as default preference is - Device Centric
    SET @planId = (SELECT  TOP 1 AP.id
                    FROM App_Plan AP WITH(NOLOCK)
						INNER JOIN UMUserGroup UUG WITH(NOLOCK)
							ON UUG.userId=@userId
						INNER JOIN UMGroupsProp UGP WITH(NOLOCK)
ON UGP.componentNameId=UUG.groupId AND UGP.attrName = 'Associated Plan' AND UGP.modified=0 AND CAST(AP.id AS NVARCHAR(64))=UGP.attrVal
						INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.componentNameId=AP.id AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.modified=0
WHERE ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0) AND APP.attrVal=CAST(UGP.componentNameId AS NVARCHAR(64)))
END
-- if user does not belong to any group and there was no direct plan association try to find organization to which user belongs
IF @planId IS NULL  OR @planId = 0 BEGIN
	-- To ensure we refer to the latest setting as per index in table (in case of multiple enteries)
    SELECT @planId =AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.componentNameId=@userOrgId AND ACP.attrName='Default Laptop Plan' AND ACP.cs_attrName=checksum('Default Laptop Plan') AND ACP.modified=0
    IF (@planId IS NOT NULL)  AND (@planId <> 0)
    BEGIN
        DECLARE @planUserGroupId INT = 0
SELECT @planUserGroupId = attrval from App_PlanProp WITH(NOLOCK) WHERE componentNameId=@planId AND attrName = 'Assigned user group' AND modified=0
        Merge UMUsersProp As UUP
        USING (SELECT @userId) as SRC(userId)
ON SRC.userId = UUP.componentNameId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
            WHEN MATCHED THEN
                UPDATE SET attrVal = @planId
            WHEN NOT MATCHED THEN
INSERT(componentNameId, attrName, attrVal, attrType, created, modified ) VALUES(@userId, 'Associated Plan', @planId, 7, dbo.GetUnixTime(GetDate()), 0);
		IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE userId=@userId AND groupId=@planUserGroupId)
		BEGIN
			INSERT INTO UMUserGroup
				VALUES (@userId, @planUserGroupId, 0)
		END
    END
END
--- CODE ABOVE HERE IS FROM AppGetPlanForUser.spb  ----------
	-------------------------------------------------------------------------------------------------------------------------------------------
	-- return the clients depending on the flag sent by the requestor
	-- Get all user centric clients, if the user belongs to a group that has shared laptop enabled.
	IF @usercentric= 1 AND @flag = 2
	BEGIN
	    -- SELECT ALL User Centric Clients that user is owner of
	    INSERT INTO @userCentricClients
	    SELECT owners.ClientID FROM sec_getClientOwners(1)
	    owners where owners.userId = @userId and
	    owners.clientId in (
							       SELECT componentnameId FROM app_clientprop
WHERE ( attrname = 'User Centric Client' and attrval = '1')
						    )
	    DELETE @userCentricClients
	    WHERE NOT EXISTS ( SELECT componentnameId FROM app_clientprop
								    WHERE (
										    attrname = 'Ida Type'
										    and (
													    (attrval = @type)
													    OR ((@type = 1) AND attrval in (2,3,4))
											    )
									      )
									      and componentNameId = pseudoClientId
						    )
	END
	ELSE IF @flag IN (0,1) --ALL, DEVICE_CENTRIC
	BEGIN
		-- SELECT ALL laptop clients that user is owner of
		INSERT INTO @userCentricClients
		SELECT owners.ClientID FROM sec_getClientOwners(1)
		owners JOIN APP_CLIENT C ON owners.clientId = C.id
		where owners.userId = @userId
		AND c.status & 4096 = 4096
        AND @type = (SELECT case S.type
							when 'windows' then 2
							when 'unix' then
								case (S.SubType)
								when 'darwin' then 4
								else 3
								end
                            else 1
						   end
					 from simOperatingSystem S where S.id = C.simOperatingSystemId)
		-- Get all physical clients.
		IF @flag = 1
		BEGIN
			DELETE @userCentricClients
			WHERE pseudoClientId IN (
									SELECT componentnameId FROM app_clientprop
WHERE ( attrname = 'User Centric Client' and attrval = '1')
						)
		END
	END
	--List the clients and subclients Associated to these users
	SET @clientList = (SELECT
						client.name as '@clientName',
						client.id as'@clientId',
						client.displayName as '@displayName'
						FROM APP_CLIENT client
						JOIN @userCentricClients temp ON temp.pseudoClientId = client.id
						FOR XML PATH('associatedClients'),TYPE
						)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = N'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SET @xmldata = (
						SELECT @clientList,
							  ( SELECT      @errorCode as '@errorCode',
											@errorString as '@errorMessage'
											FOR XML PATH ('error'),TYPE
							  )
							  FOR XML PATH(''),ROOT('App_GetAssociatedUserCentricClientsResponse')
						)
		SELECT @xmldata
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserCentricClientAssociation')
	delete from GxQscripts where name = 'AppGetUserCentricClientAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserCentricClientAssociation')
	delete from GXDBVersions where aliasname = 'AppGetUserCentricClientAssociation'
GO

insert into GXDBVersions values(2, 'AppGetUserCentricClientAssociation',  '00000000000000000000', 'AppGetUserCentricClientAssociation', '00000000000000000000')
GO

