

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUniqueEntityNameWrapper.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUniqueEntityNameWrapper.sp,v $ $Id: AppGetUniqueEntityNameWrapper.sp,v 1.1.2.2 2018/03/27 09:18:42 jiechen Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Create date: 09/26/2016
-- Description:	returns unique name of the entity based on name provided as a parameter. Appends counter to the
--				that name. Cpp wrapper to return entity name in cursor
--
-- Parameters : i_entityTypeId		- type of the entity. One of the values specified in enum EntityType in
--									  vaultcx/Source/Common/XmlMessage/CvEntities.x
--              i_entityName		- name of the entitity which serves as base for name generation
--              i_userId			- user id
--              o_uniqueEntityName	- output value. unique entity name
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUniqueEntityNameWrapper <<<'

IF EXISTS (select * from sysobjects where name='AppGetUniqueEntityNameWrapper')
	drop procedure AppGetUniqueEntityNameWrapper
IF EXISTS (select * from GxQscripts where name='AppGetUniqueEntityNameWrapper')
	delete from GxQscripts where name = 'AppGetUniqueEntityNameWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUniqueEntityNameWrapper')
	delete from GXDBVersions where aliasname = 'AppGetUniqueEntityNameWrapper'
GO
print '... Creating Procedure: AppGetUniqueEntityNameWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUniqueEntityNameWrapper
  @i_entityTypeId INT,
  @i_entityName NVARCHAR(1024),
  @i_userId INT
AS
  DECLARE @uniqueEntityName NVARCHAR(1024)
	exec AppGetUniqueEntityName @i_entityTypeId, @i_entityName, @i_userId, @uniqueEntityName OUTPUT
	select @uniqueEntityName
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUniqueEntityNameWrapper')
	delete from GxQscripts where name = 'AppGetUniqueEntityNameWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUniqueEntityNameWrapper')
	delete from GXDBVersions where aliasname = 'AppGetUniqueEntityNameWrapper'
GO

insert into GXDBVersions values(2, 'AppGetUniqueEntityNameWrapper',  '00010001000200020000', 'AppGetUniqueEntityNameWrapper', '00010001000200020000')
GO

