

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUniqueEntityName.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUniqueEntityName.sp,v $ $Id: AppGetUniqueEntityName.sp,v 1.1.2.10 2020/05/30 00:45:05 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 03/23/2016
-- Description:	returns unique name of the entity based on name provided as a parameter. Appends counter to the
--				that name.
--
-- Parameters : i_entityTypeId		- type of the entity. One of the values specified in enum EntityType in
--									  vaultcx/Source/Common/XmlMessage/CvEntities.x
--              i_entityName		- name of the entitity which serves as base for name generation
--              i_userId			- user id
--              o_uniqueEntityName	- output value. unique entity name
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetUniqueEntityName')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUniqueEntityName <<<'
	drop procedure AppGetUniqueEntityName
END
IF EXISTS (select * from GxQscripts where name='AppGetUniqueEntityName')
	delete from GxQscripts where name = 'AppGetUniqueEntityName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUniqueEntityName')
	delete from GXDBVersions where aliasname = 'AppGetUniqueEntityName'
GO
print '... Creating Procedure: AppGetUniqueEntityName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUniqueEntityName
  @i_entityTypeId INT,
  @i_entityName NVARCHAR(1024),
  @i_userId INT,
  @o_uniqueEntityName NVARCHAR(1024) OUTPUT
AS
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON
	SET @o_uniqueEntityName =
    CASE @i_entityTypeId
WHEN 3               THEN (SELECT TOP 1 name FROM APP_Client WITH(NOLOCK) WHERE name = @i_entityName OR name LIKE @i_entityName + ' (%)' ORDER BY id DESC)
WHEN 9              THEN (SELECT TOP 1 AliasName FROM MMLibrary WITH(NOLOCK) WHERE AliasName = AliasName OR AliasName LIKE @i_entityName + ' (%)' ORDER BY LibraryId DESC)
WHEN 15            THEN (SELECT TOP 1 name FROM UMGroups WHERE name = @i_entityName OR name LIKE @i_entityName + ' (%)' ORDER BY id DESC)
WHEN 17       THEN (SELECT TOP 1 name FROM archGroup WITH(NOLOCK) WHERE name = @i_entityName OR name LIKE @i_entityName + ' (%)' ORDER BY id DESC)
WHEN 28         THEN (SELECT TOP 1 name FROM APP_ClientGroup WITH(NOLOCK) WHERE name = @i_entityName OR name LIKE @i_entityName + ' (%)' ORDER BY id DESC)
WHEN 35      THEN (SELECT TOP 1 taskName FROM TM_Task WITH(NOLOCK) WHERE taskName = @i_entityName OR taskName LIKE @i_entityName + ' (%)' ORDER BY taskId DESC)
WHEN 65     THEN (SELECT TOP 1 BSN.name FROM APP_BackupSetName BSN WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON BSN.id = APP.backupSet AND APP.appTypeId = 1030 WHERE BSN.name = @i_entityName OR BSN.name LIKE @i_entityName + ' (%)' ORDER BY BSN.id DESC)
WHEN 68              THEN (SELECT TOP 1 subtaskName FROM TM_SubTask WITH(NOLOCK) WHERE subtaskName = @i_entityName OR subtaskName LIKE @i_entityName + ' (%)' ORDER BY subtaskId DESC)
WHEN 69                 THEN (SELECT TOP 1 taskName FROM TM_Task WITH(NOLOCK) WHERE taskName = @i_entityName OR taskName LIKE @i_entityName + ' (%)' ORDER BY taskId DESC)
WHEN 120                 THEN (SELECT TOP 1 name FROM UMRoles WITH(NOLOCK) WHERE name = @i_entityName OR name LIKE @i_entityName + ' (%)' ORDER BY id DESC)
        WHEN 154                             THEN (SELECT TOP 1 policyName FROM APP_ConfigurationPolicy WHERE policyName = @i_entityName OR policyName LIKE @i_entityName + ' (%)' ORDER BY policyId DESC)
WHEN 158                 THEN (SELECT TOP 1 name FROM App_Plan WITH(NOLOCK) WHERE ownerId = @i_userId AND (name = @i_entityName OR name LIKE @i_entityName + ' (%)') ORDER BY id DESC)
		WHEN 156							 THEN (SELECT TOP 1 topologyName FROM APP_FirewallTopology WITH(NOLOCK) WHERE (topologyName = @i_entityName OR topologyName LIKE @i_entityName + ' (%)') ORDER BY topologyId DESC) ---FW_TOPOLOGY_ENTITY
WHEN 38			 THEN (SELECT TOP 1 description FROM APP_OpWindowRule WITH(NOLOCK) WHERE (description = @i_entityName OR description LIKE @i_entityName + ' (%)') ORDER BY Id DESC)
WHEN 61 THEN  (SELECT TOP 1 domainName FROM UMDSProviders WITH(NOLOCK) WHERE servicetype=5 and (domainName = @i_entityName OR domainName LIKE @i_entityName + ' (%)') ORDER BY Id DESC)
		ELSE ''
	END
	DECLARE @counter INT = 0
	IF @o_uniqueEntityName IS NOT NULL BEGIN
		IF LOWER(@o_uniqueEntityName) = LOWER(@i_entityName) BEGIN
			SET @counter = 2
		END ELSE BEGIN
			DECLARE @const_ScheduledForDeletionSuffix VARCHAR(24) = ': scheduled for deletion'
			DECLARE @cutoff INT = CHARINDEX(@const_ScheduledForDeletionSuffix, @o_uniqueEntityName, 0)
			IF ISNULL(@cutoff, 0) != 0 BEGIN
				SET @o_uniqueEntityName = RTRIM(SUBSTRING(@o_uniqueEntityName, 0, @cutoff))
			END
            SET @o_uniqueEntityName = SUBSTRING((SELECT LTRIM(RTRIM(SUBSTRING(@o_uniqueEntityName, LEN(@i_entityName) + 1, 100)))), 2, LEN(@o_uniqueEntityName))
            DECLARE @suffix AS VARCHAR(32) = SUBSTRING(@o_uniqueEntityName, 1, LEN(@o_uniqueEntityName) - 1)
            SET @counter = IIF(ISNUMERIC(@suffix) != 0, CAST(@suffix AS INT) + 1, 2)
		END
	END
	SET @o_uniqueEntityName = @i_entityName
	IF @counter != 0 BEGIN
		SET @o_uniqueEntityName = @i_entityName + ' ('+ CAST(@counter AS NVARCHAR(32)) + ')'
		WHILE CAST(ISNULL((SELECT CASE @i_entityTypeId
WHEN 3               THEN (SELECT id FROM APP_Client WITH(NOLOCK) WHERE name = @o_uniqueEntityName)
WHEN 9              THEN (SELECT LibraryId FROM MMLibrary WITH(NOLOCK) WHERE AliasName = @o_uniqueEntityName)
WHEN 15            THEN (SELECT id FROM UMGroups WITH(NOLOCK) WHERE name = @o_uniqueEntityName)
WHEN 17       THEN (SELECT id FROM archGroup WITH(NOLOCK) WHERE name = @o_uniqueEntityName)
WHEN 28         THEN (SELECT id FROM APP_ClientGroup WITH(NOLOCK) WHERE name = @o_uniqueEntityName)
WHEN 35      THEN (SELECT taskId FROM TM_Task WITH(NOLOCK) WHERE taskName = @o_uniqueEntityName)
WHEN 65     THEN (SELECT BSN.id FROM APP_BackupSetName BSN WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON BSN.id = APP.backupSet AND APP.appTypeId = 1030 WHERE BSN.name = @o_uniqueEntityName)
WHEN 68              THEN (SELECT subtaskId FROM TM_SubTask WITH(NOLOCK) WHERE subtaskName = @o_uniqueEntityName)
WHEN 69                 THEN (SELECT taskId FROM TM_Task WITH(NOLOCK) WHERE taskName = @o_uniqueEntityName)
WHEN 120                 THEN (SELECT name FROM UMRoles WITH(NOLOCK) WHERE name = @o_uniqueEntityName)
                                    WHEN 154                             THEN (SELECT policyId FROM APP_ConfigurationPolicy WHERE policyName = @o_uniqueEntityName)
WHEN 158                 THEN (SELECT id FROM App_Plan WITH(NOLOCK) WHERE name = @o_uniqueEntityName)
									WHEN 156							 THEN (SELECT topologyId FROM APP_FirewallTopology WITH(NOLOCK) WHERE topologyName = @o_uniqueEntityName) ---FW_TOPOLOGY_ENTITY
WHEN 38			 THEN (SELECT TOP 1 Id FROM APP_OpWindowRule WITH(NOLOCK) WHERE description = @o_uniqueEntityName)
WHEN 61			 THEN (SELECT TOP 1 Id FROM UMDSProviders WITH(NOLOCK) WHERE servicetype=5 and domainName = @o_uniqueEntityName)
							ELSE 0 END), 0) AS INT) > 0 BEGIN
			SET @counter += 1
			SET @o_uniqueEntityName = @i_entityName + ' ('+ CAST(@counter AS NVARCHAR(32)) + ')'
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUniqueEntityName')
	delete from GxQscripts where name = 'AppGetUniqueEntityName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUniqueEntityName')
	delete from GXDBVersions where aliasname = 'AppGetUniqueEntityName'
GO

insert into GXDBVersions values(2, 'AppGetUniqueEntityName',  '00010001000200100000', 'AppGetUniqueEntityName', '00010001000200100000')
GO

