

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTwoFactorAuthenticationDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppGetTwoFactorAuthenticationDetails			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetTwoFactorAuthenticationDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetTwoFactorAuthenticationDetails <<<'
	drop procedure AppGetTwoFactorAuthenticationDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetTwoFactorAuthenticationDetails')
	delete from GxQscripts where name = 'AppGetTwoFactorAuthenticationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTwoFactorAuthenticationDetails')
	delete from GXDBVersions where aliasname = 'AppGetTwoFactorAuthenticationDetails'
GO
print '... Creating Procedure: AppGetTwoFactorAuthenticationDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetTwoFactorAuthenticationDetails
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inProviderId INT,
  @inLocaleId INT = 0
-----------------------------------------------------------
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @tfaMode NVARCHAR(8)
	DECLARE @userGroupsIncludedForTFA TABLE (id INT, name NVARCHAR(MAX))
	DECLARE @canSeeProvider INT = 0
	-- security check
	IF(@inUserId > 0)
	BEGIN
		EXEC sec_canSeeOrManageNameServer  @inUserId, @inProviderId, 1, 0, 0, @canSeeProvider OUTPUT
		IF @canSeeProvider <> 1
		BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
	END
	ELSE
	BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ERROR_EXIT
	END
	IF @inProviderId = 0	-- If request is for commcell
	BEGIN
SET @tfaMode = ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'EnableTwoFactorAuthentication'), '0')
	END
	ELSE		-- If request is for a company
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM UMDSProviders WHERE id = @inProviderId)
		BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		-- Get company user groups that have TFA enabled
SET @tfaMode = ISNULL((SELECT attrVal FROM App_CompanyProp WHERE componentNameId = @inProviderId AND attrName = 'EnableTwoFactorAuthentication'
AND modified = 0 AND cs_attrName = CHECKSUM('EnableTwoFactorAuthentication')),
'0')
	END
	IF @tfaMode = '2'
	BEGIN
	IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
		DROP TABLE #TFASupportedADServiceTypesTempTable
	CREATE TABLE #TFASupportedADServiceTypesTempTable (serviceType INT)
	-- TFA support: AD, openldap, oracle ldap, apple ldap, jump cloud and Generic LDAP
	INSERT INTO #TFASupportedADServiceTypesTempTable
VALUES (2), (6), (8),
(9), (10), (14)
		-- Get local/AD user groups that have TFA enabled
		SET @outXml	= (
					SELECT umg.id '@userGroupId', p.domainname+'\'+umg.name '@userGroupName'
						   FROM UMGroups umg
						   INNER JOIN UMDSProviders p
								ON (p.id = @inProviderId OR (p.serviceType IN (SELECT serviceType FROM #TFASupportedADServiceTypesTempTable) AND p.ownerCompany = @inProviderId))
								   AND umg.umdsProviderId = p.id
						   INNER JOIN UMGroupsProp umgp
ON umgp.attrName = N'DisableTwoFactorAuthentication'
								   AND umgp.attrVal = '0'
								   AND umgp.modified = 0
AND umgp.cs_attrName = CHECKSUM(N'DisableTwoFactorAuthentication')
								   AND umg.id = umgp.componentNameId
						   FOR XML PATH ('userGroups')
				  )
	END
	SET @outXml = ( SELECT @tfaMode '@mode', @outXml FOR XML PATH ('twoFactorAuthenticationInfo') )
ERROR_EXIT:
	SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @inLocaleId)
	SET @outXml = (SELECT
				    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE),
					@outXml
					FOR XML PATH('App_GetTwoFactorAuthenticationDetailsResponse'), TYPE
				  )
	--SELECT @errorCode AS errorCode, @errorString AS errorString, @outXml AS outXml
	SELECT @outXml
	IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
		DROP TABLE #TFASupportedADServiceTypesTempTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTwoFactorAuthenticationDetails')
	delete from GxQscripts where name = 'AppGetTwoFactorAuthenticationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTwoFactorAuthenticationDetails')
	delete from GXDBVersions where aliasname = 'AppGetTwoFactorAuthenticationDetails'
GO

insert into GXDBVersions values(2, 'AppGetTwoFactorAuthenticationDetails',  '00000000000000000000', 'AppGetTwoFactorAuthenticationDetails', '00000000000000000000')
GO

