

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTreeViewForSCPAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetTreeViewForSCPAssociation
--  |
--  | Description:  SP for sending tree view for subclient policy association to GUI
--  |
--  |       Input:  GetTreeViewForSCPReq request XML
--  |      Output:  GetTreeViewForSCPResp response XML
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetTreeViewForSCPAssociation')
BEGIN
	print '>>> Drop Stored Procedure: AppGetTreeViewForSCPAssociation <<<'
	drop procedure AppGetTreeViewForSCPAssociation
END
IF EXISTS (select * from GxQscripts where name='AppGetTreeViewForSCPAssociation')
	delete from GxQscripts where name = 'AppGetTreeViewForSCPAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTreeViewForSCPAssociation')
	delete from GXDBVersions where aliasname = 'AppGetTreeViewForSCPAssociation'
GO
print '... Creating Procedure: AppGetTreeViewForSCPAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetTreeViewForSCPAssociation
  @i_xml XML
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--enum APP::DistributedClusterType
IF OBJECT_ID('tempdb.dbo.#SCPTreeViewClientGroupsTbl') IS NOT NULL
	DROP TABLE #SCPTreeViewClientGroupsTbl
CREATE TABLE #SCPTreeViewClientGroupsTbl
(
	clientGroupId		INT
)
IF OBJECT_ID('tempdb.dbo.#SCPTreeViewClientsTbl') IS NOT NULL
	DROP TABLE #SCPTreeViewClientsTbl
CREATE TABLE #SCPTreeViewClientsTbl
(
	clientId		INT
)
IF OBJECT_ID('tempdb.dbo.#SCPTreeViewBackupSetsTbl') IS NOT NULL
	DROP TABLE #SCPTreeViewBackupSetsTbl
CREATE TABLE #SCPTreeViewBackupSetsTbl
(
	clientId		INT,
	applicationId	INT,
	instanceId		INT,
	backupsetId		INT
)
IF OBJECT_ID('tempdb.dbo.#UserClientGroups') IS NOT NULL
	DROP TABLE #UserClientGroups
CREATE TABLE #UserClientGroups
(
	clientGroupId	INT
)
IF OBJECT_ID('tempdb.dbo.#UserClientsOrBackupsets') IS NOT NULL
	DROP TABLE #UserClientsOrBackupsets
CREATE TABLE #UserClientsOrBackupsets
(
	clientId		INT,
	apptypeId		INT,
	instanceId		INT,
	backupsetId		INT,
	subclientId		INT
)
DECLARE @scpId INT = ISNULL((SELECT ref.value('@subclientPolicyId', 'INT')
								FROM @i_xml.nodes('App_GetTreeViewForSCPReq/subclientPolicyEntity') R (ref)), 0)
DECLARE @scpIdaType INT = ISNULL((SELECT ref.value('@idaType', 'INT')
									FROM @i_xml.nodes('App_GetTreeViewForSCPReq') R (ref)), 0)
IF(@scpIdaType = 0)
BEGIN
SET @scpIdaType  = ISNULL((Select CAST(attrval as int) from APP_BackupSetProp where attrName='Associated subclient Policy Ida Type' and componentNameId = @scpId),0)
END
DECLARE @userId INT = ISNULL((SELECT ref.value('@userId', 'INT')
								FROM @i_xml.nodes('App_GetTreeViewForSCPReq/processinginstructioninfo/user') R (ref)), 0)
DECLARE @appTypeGroupId INT = ISNULL((SELECT appTypeGroupId
										FROM APP_AppTypeGroup
											WHERE groupName = CASE	WHEN @scpIdaType = 2 THEN 'APPGRP_WindowsFileSystemIDA'
																	WHEN @scpIdaType = 3 THEN 'APPGRP_UnixFileSystem'
																	ELSE '' END), 0)
DECLARE @entityType INT
DECLARE @clientGroupId INT
DECLARE @clientId INT
SELECT @entityType = ISNULL(ref.value('@_type_', 'INT'), 0),
		@clientGroupId = ISNULL(ref.value('@clientGroupId', 'INT'), 0),
		@clientId = ISNULL(ref.value('@clientId', 'INT'), 0)
FROM @i_xml.nodes('App_GetTreeViewForSCPReq/rootEntity') R (ref)
IF @entityType = 1
BEGIN
	INSERT INTO #SCPTreeViewClientGroupsTbl
	SELECT id
	FROM APP_ClientGroup
		WHERE id NOT IN (SELECT entityId FROM APP_SubclientPolicyAssoc scpAssoc
												INNER JOIN APP_BackupSetProp bsProp
													ON scpAssoc.scpId = bsProp.componentNameId
AND scpAssoc.entityType = 28
														AND bsProp.componentNameId <> @scpId AND bsProp.attrName = N'Associated subclient Policy Ida Type' AND bsProp.attrVal = @scpIdaType AND bsProp.modified = 0)
			AND id NOT IN (SELECT componentNameId FROM APP_ClientGroupProp
WHERE attrName = 'Client Group Unique Id'
AND attrVal IN (8, 5, 9)
								AND modified =0)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28, 2, '#UserClientGroups'
	DELETE tree
	FROM #SCPTreeViewClientGroupsTbl tree LEFT OUTER JOIN #UserClientGroups cgs
		ON tree.clientGroupId = cgs.clientGroupId
		WHERE cgs.clientGroupId IS NULL
	IF(@scpIdaType =5 OR @scpIdaType=6)   --App_GetTreeViewForSCPReq,  SCPIdaType_IBMI=5,  SCPIdaType_OPENVMS=6
	BEGIN
		INSERT INTO #SCPTreeViewClientsTbl
		SELECT C.id
FROM APP_Client C where (@scpIdaType=6 and simOperatingSystemId =49) OR (@scpIdaType=5 and simOperatingSystemId =118   )
		AND (C.status & 0x10000000) =  0
		AND dbo.IsDistributedPseudoClient(C.id)=0
	END
	ELSE
	BEGIN
		INSERT INTO #SCPTreeViewClientsTbl
		SELECT C.id
		FROM APP_Client C
		INNER JOIN APP_IDAName Ida
			ON C.id = Ida.clientId
	AND (C.status & 0x10000000) =  0		--Exclude edge drive clients
		INNER JOIN APP_AppTypeGroupAssoc AppGrp
			ON Ida.appTypeId = AppGrp.appTypeId
			AND AppGrp.appGroupId = @appTypeGroupId
			AND dbo.IsDistributedPseudoClient(C.id)=0
	END
EXEC sec_getIdaObjectsForUser @userId, 3, 2, 1, '#UserClientsOrBackupsets'
	DELETE tree
	FROM #SCPTreeViewClientsTbl tree LEFT OUTER JOIN #UserClientsOrBackupsets clients
		ON tree.clientId = clients.clientId
		WHERE clients.clientId IS NULL
END
ELSE IF @entityType = 28
BEGIN
	IF(@scpIdaType =5 OR @scpIdaType=6)
		BEGIN
					INSERT INTO #SCPTreeViewClientsTbl
					SELECT C.id
					FROM APP_Client C
					INNER JOIN APP_ClientGroupAssoc CGAssoc
						ON C.id = CGAssoc.clientId AND CGAssoc.clientGroupId = @clientGroupId
					WHERE
(@scpIdaType=6and simOperatingSystemId =49) OR (@scpIdaType=5 and simOperatingSystemId =118   )
AND (C.status & 0x10000000  ) =  0
		END
		ELSE
		BEGIN
			INSERT INTO #SCPTreeViewClientsTbl
			SELECT C.id
			FROM APP_Client C
			INNER JOIN APP_ClientGroupAssoc CGAssoc
				ON C.id = CGAssoc.clientId AND CGAssoc.clientGroupId = @clientGroupId
			INNER JOIN APP_IDAName Ida
				ON C.id = Ida.clientId
AND (C.status & 0x10000000) =  0		--Exclude edge drive clients
			INNER JOIN APP_AppTypeGroupAssoc AppGrp
				ON Ida.appTypeId = AppGrp.appTypeId
				AND AppGrp.appGroupId = @appTypeGroupId
	END
EXEC sec_getIdaObjectsForUser @userId, 3, 2, 1, '#UserClientsOrBackupsets'
			DELETE tree
			FROM #SCPTreeViewClientsTbl tree LEFT OUTER JOIN #UserClientsOrBackupsets clients
				ON tree.clientId = clients.clientId
				WHERE clients.clientId IS NULL
END
ELSE IF @entityType = 3
BEGIN
	IF OBJECT_ID('tempdb.dbo.#BackupSetsTbl') IS NOT NULL
		DROP TABLE #BackupSetsTbl
	CREATE TABLE #BackupSetsTbl
	(
		clientId			INT,
		apptypeId			INT,
		instanceId			INT,
		backupSet			INT,
		backupSetName		NVARCHAR(256),
		subclientId			INT,
		subclientStatus		INT,
		systemStateFlag		INT,
		scpId				INT,
		isArchivingEnabled	INT
	)
	IF(@scpIdaType =5 OR @scpIdaType=6)
	BEGIN
			INSERT INTO #BackupSetsTbl
			SELECT	App.clientId,
					App.appTypeId,
					App.instance,
					App.backupSet,
					BackupSet.name,
					App.id,
					App.subclientStatus,
					systemStateFlag = ISNULL(SCProp.attrVal, 0),
					scpId 	= 	ISNULL(BSProp.attrVal, 0),
					isArchivingEnabled 	= 	ISNULL(BSProp1.attrVal, 0)
			FROM APP_Application App
			INNER JOIN APP_BackupsetName BackupSet
				ON App.clientId = @clientId AND (App.subclientStatus & 4) <> 4 AND App.backupSet = BackupSet.id AND (BackupSet.status & 128) <> 128
INNER JOIN APP_Client C ON C.id=App.clientId and (@scpIdaType=6and simOperatingSystemId =49) OR (@scpIdaType=5 and simOperatingSystemId =118   )
AND (C.status & 0x10000000) =  0
			LEFT OUTER JOIN APP_SubClientProp SCProp
				ON App.id = SCProp.componentNameId
				AND SCProp.attrName = N'System State Subclient' AND SCProp.modified = 0
			LEFT OUTER JOIN APP_BackupSetProp BSProp
				ON App.backupSet = BSProp.componentNameId
				AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0
			LEFT OUTER JOIN APP_BackupSetProp BSProp1
				ON App.backupSet = BSProp1.componentNameId
				AND BSProp1.attrName = N'Is Archiving Enabled' AND BSProp1.modified = 0
	END
	ELSE
	BEGIN
		INSERT INTO #BackupSetsTbl
		SELECT	App.clientId,
				App.appTypeId,
				App.instance,
				App.backupSet,
				BackupSet.name,
				App.id,
				App.subclientStatus,
				systemStateFlag = ISNULL(SCProp.attrVal, 0),
				scpId 	= 	ISNULL(BSProp.attrVal, 0),
				isArchivingEnabled 	= 	ISNULL(BSProp1.attrVal, 0)
		FROM APP_Application App
		INNER JOIN APP_BackupsetName BackupSet
			ON App.clientId = @clientId AND (App.subclientStatus & 4) <> 4 AND App.backupSet = BackupSet.id AND (BackupSet.status & 128) <> 128
		INNER JOIN APP_AppTypeGroupAssoc AppGrp
			ON App.appTypeId = AppGrp.appTypeId
			AND AppGrp.appGroupId = @appTypeGroupId
		LEFT OUTER JOIN APP_SubClientProp SCProp
			ON App.id = SCProp.componentNameId
			AND SCProp.attrName = N'System State Subclient' AND SCProp.modified = 0
		LEFT OUTER JOIN APP_BackupSetProp BSProp
			ON App.backupSet = BSProp.componentNameId
			AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0
		LEFT OUTER JOIN APP_BackupSetProp BSProp1
				ON App.backupSet = BSProp1.componentNameId
				AND BSProp1.attrName = N'Is Archiving Enabled' AND BSProp1.modified = 0
	END
	-- Remove Indexing backupsets
	DELETE #BackupSetsTbl WHERE backupSetName = N'Indexing BackupSet'
	-- Remove backupsets with user defined subclients
	-- Remove backupset where new archiving flag is defined
	DELETE #BackupSetsTbl WHERE backupSet IN (SELECT backupSet FROM #BackupSetsTbl WHERE (scpId = 0 AND subclientStatus = 0 AND systemStateFlag <> 1) OR isArchivingEnabled = 1)
	IF @scpId <> 0
	BEGIN
		DELETE #BackupSetsTbl where ((scpid <> 0) AND (scpid <> @scpId))
	END
	ELSE
	BEGIN
		-- Remove backupsets already associated to a subclient policy
		DELETE #BackupSetsTbl WHERE scpId <> 0
	END
	INSERT INTO #SCPTreeViewBackupSetsTbl
		SELECT DISTINCT clientId, apptypeId, instanceId, backupSet FROM #BackupSetsTbl
EXEC sec_getIdaObjectsForUser @userId, 6, 2, 0, '#UserClientsOrBackupsets'
	DELETE tree
		FROM #SCPTreeViewBackupSetsTbl tree LEFT OUTER JOIN #UserClientsOrBackupsets bkpSets
			ON tree.clientId = bkpSets.clientId AND tree.applicationId = bkpSets.apptypeId AND tree.instanceId = bkpSets.instanceId AND tree.backupsetId = bkpSets.backupsetId
			WHERE bkpSets.backupsetId IS NULL
END
DECLARE @outXML XML
SET @outXML = ISNULL((
						SELECT
(SELECT 28 as '@_type_',
									clientGroupId as '@clientGroupId',
									name as '@clientGroupName'
							FROM #SCPTreeViewClientGroupsTbl tree
							INNER JOIN APP_ClientGroup CG
								ON tree.clientGroupId = CG.id
							FOR XML PATH('clientGroups'), TYPE),
(SELECT 3 as '@_type_',
									clientId as '@clientId',
									name as '@clientName',
									displayName as '@displayName'
							FROM #SCPTreeViewClientsTbl tree
							INNER JOIN APP_Client client
								ON tree.clientId = client.id
							FOR XML PATH('clients'), TYPE),
(SELECT 6 as '@_type_',
									clientId as '@clientId',
									applicationId as '@applicationId',
									instanceId as '@instanceId',
									backupsetId as '@backupsetId',
									name as '@backupsetName'
							FROM #SCPTreeViewBackupSetsTbl tree
							INNER JOIN APP_BackupSetName bckpSet
								ON tree.backupsetId = bckpSet.id
							FOR XML PATH('backupSets'), TYPE)
						FOR XML PATH('App_GetTreeViewForSCPResp')
					), 'App_GetTreeViewForSCPResp')
SELECT @outXML
IF OBJECT_ID('tempdb.dbo.#SCPTreeViewClientGroupsTbl') IS NOT NULL
	DROP TABLE #SCPTreeViewClientGroupsTbl
IF OBJECT_ID('tempdb.dbo.#SCPTreeViewClientsTbl') IS NOT NULL
	DROP TABLE #SCPTreeViewClientsTbl
IF OBJECT_ID('tempdb.dbo.#SCPTreeViewBackupSetsTbl') IS NOT NULL
	DROP TABLE #SCPTreeViewBackupSetsTbl
IF OBJECT_ID('tempdb.dbo.#UserClientGroups') IS NOT NULL
	DROP TABLE #UserClientGroups
IF OBJECT_ID('tempdb.dbo.#UserClientsOrBackupsets') IS NOT NULL
	DROP TABLE #UserClientsOrBackupsets
IF OBJECT_ID('tempdb.dbo.#BackupSetsTbl') IS NOT NULL
	DROP TABLE #BackupSetsTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTreeViewForSCPAssociation')
	delete from GxQscripts where name = 'AppGetTreeViewForSCPAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTreeViewForSCPAssociation')
	delete from GXDBVersions where aliasname = 'AppGetTreeViewForSCPAssociation'
GO

insert into GXDBVersions values(2, 'AppGetTreeViewForSCPAssociation',  '00000000000000000000', 'AppGetTreeViewForSCPAssociation', '00000000000000000000')
GO

