

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTranslations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetTranslations.sp,v $ $Id: AppGetTranslations.sp,v 1.6.2.3 2019/07/25 21:17:05 spokale Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetTranslations')
BEGIN
	print '>>> Drop Stored Procedure: AppGetTranslations <<<'
	drop procedure AppGetTranslations
END
IF EXISTS (select * from GxQscripts where name='AppGetTranslations')
	delete from GxQscripts where name = 'AppGetTranslations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTranslations')
	delete from GXDBVersions where aliasname = 'AppGetTranslations'
GO
print '... Creating Procedure: AppGetTranslations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetTranslations
  @i_entityType INT,
  @i_entityId INT,
  @i_locale NVARCHAR(100),
  @i_localeKeys NVARCHAR(MAX) = '' -- Comma separated list of keys, optional
-- Sample Exec Statement for landing page
-- EXEC AppGetTranslations 131, -1, @i_localeId, '''RPT_TITLE'', ''RPT_DESCRIPTION'''
AS
  DECLARE @o_entityid int;
  DECLARE @o_localeKey NVARCHAR(MAX);
  DECLARE @o_localeValue NVARCHAR(MAX);
-- Locale delimiter is _
DECLARE @delimiter		NVARCHAR		=	'_'
DECLARE @delimiterIndex	INT				=	0
DECLARE @pivotColumns	NVARCHAR(MAX)	=	''
DECLARE @selectColumns	NVARCHAR(MAX)	=	''
DECLARE @languageList	NVARCHAR(MAX)	=	''
DECLARE @whereCondition	NVARCHAR(MAX)	=	''
DECLARE @pivotQuery		NVARCHAR(MAX)	=	''
DECLARE @columns 		INT				=	0
DECLARE @l_locale 		NVARCHAR(MAX)	=	''
--In some test cases '-' is being used for fr-CA and es-MX
--Since the database stores the locales as fr_CA and ex_MX the '-' is being replaced by '_'
SET @l_locale = REPLACE(LTRIM(RTRIM(@i_locale)),'-','_')
SET @delimiterIndex = LEN(@l_locale)
WHILE @delimiterIndex != 0
BEGIN
	SELECT @delimiterIndex = CHARINDEX(@delimiter, REVERSE(@l_locale))
	-- Copy the current locale into pivot column
	SET @pivotColumns += '[' + @l_locale +'], '
	-- Copy the current locale into select column for ISNULL check
	SET @selectColumns += 'ISNULL([' + @l_locale +'], '
	SET @languageList += ''''+ @l_locale + ''', '
	-- Iterate the Locale to find the next best match
	SET @l_locale = LEFT(@l_locale, LEN(@l_locale) - @delimiterIndex)
	SET @columns += 1;
END
SET @pivotColumns += '[default]'
SET @selectColumns += 'ISNULL([default], NULL)'
SET @languageList += '''default'''
-- Add ending ) to the select column
WHILE @columns != 0
BEGIN
	SET @selectColumns += ')'
	SET @columns -= 1;
END
SET @selectColumns += ' as localeValue'
SET @whereCondition += 'WHERE entityType = ' + CAST(@i_entityType AS NVARCHAR)
IF @i_entityId > 0
BEGIN
	SET @whereCondition += ' AND entityId = ' + CAST(@i_entityId AS NVARCHAR)
END
IF @i_localeKeys IS NOT NULL AND @i_localeKeys <> ''
BEGIN
	SET @whereCondition += ' AND localeKey  COLLATE SQL_Latin1_General_CP1_CS_AS IN ( ' + @i_localeKeys + ')'
END
IF @i_locale is NOT NULL and @i_locale <> ''
BEGIN
	SET @whereCondition += ' AND locale in ('+ @languageList +')'
END
-- Create the dynamic pivot query
SET @pivotQuery = '';
SET @pivotQuery += 'SELECT entityId,'
SET @pivotQuery += '	   localeKey,'
SET @pivotQuery += @selectColumns + ' '
SET @pivotQuery += 'FROM '
SET @pivotQuery += '('
SET @pivotQuery += 'SELECT * FROM '
SET @pivotQuery += '('
SET @pivotQuery += '	SELECT entityId, localeKey, locale, localeValue, ROW_NUMBER() OVER (Partition by entityid,locale,localekey order by flags) as Rownum'
SET @pivotQuery += '	FROM APP_Translations '
SET @pivotQuery += @whereCondition
SET @pivotQuery += ') AS A where A.Rownum = 1) AS translations '
SET @pivotQuery += 'PIVOT'
SET @pivotQuery += '('
SET @pivotQuery += '	MAX(localeValue)'
SET @pivotQuery += '	FOR locale IN ('
SET @pivotQuery += @pivotColumns + ') '
SET @pivotQuery += ') as pvt'
-- SELECT @pivotQuery
-- Execute the Dynamic Pivot Query
EXEC sp_executesql @pivotQuery
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTranslations')
	delete from GxQscripts where name = 'AppGetTranslations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTranslations')
	delete from GXDBVersions where aliasname = 'AppGetTranslations'
GO

insert into GXDBVersions values(2, 'AppGetTranslations',  '00010006000200030000', 'AppGetTranslations', '00010006000200030000')
GO

