

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetThirdPartyEncryptedKeysXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetThirdPartyEncryptedKeysXML.sp,v $ $Id: AppGetThirdPartyEncryptedKeysXML.sp,v 1.1.2.2 2018/09/11 02:20:23 evolohov Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetThirdPartyEncryptedKeysXML <<<'

IF EXISTS (select * from sysobjects where name='AppGetThirdPartyEncryptedKeysXML')
	drop procedure AppGetThirdPartyEncryptedKeysXML
IF EXISTS (select * from GxQscripts where name='AppGetThirdPartyEncryptedKeysXML')
	delete from GxQscripts where name = 'AppGetThirdPartyEncryptedKeysXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetThirdPartyEncryptedKeysXML')
	delete from GXDBVersions where aliasname = 'AppGetThirdPartyEncryptedKeysXML'
GO
print '... Creating Procedure: AppGetThirdPartyEncryptedKeysXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetThirdPartyEncryptedKeysXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @i_appKey NVARCHAR(MAX) = (SELECT ref.value('@appId', 'VARCHAR(MAX)') FROM @i_xmlText.nodes ('App_GetClientThirdPartyEncryptedKeyReq') R(ref))
-- -- SP BODY BEGIN : AppGetThirdPartyEncryptedKeys.spb ----------------------------------------------------------------------------------------------------------------------------
DECLARE @appToken   			NVARCHAR(MAX)
DECLARE @appSecret			   	NVARCHAR(MAX)
DECLARE @encryptToken 			NVARCHAR(MAX)
DECLARE @encryptSecret 			NVARCHAR(MAX)
DECLARE @isEnabled				INTEGER
DECLARE @errorCode				INTEGER
DECLARE @description            NVARCHAR(MAX)
DECLARE @props                  XML
DECLARE @flags                  INT
SET @appToken = NULL
SET @appSecret = NULL
SET @encryptToken = ''
SET @encryptSecret = ''
SET @description   = ''
SET @props = NULL
SET @flags = 0
SET @errorCode = 1 -- assuming we don't find the entry for given appKey
--Get the AppToken and appSecret from DB if it exists, send error if otherwise.
SELECT	@appToken = appToken, @appSecret = appSecret, @isEnabled = isEnabled
FROM	App_ThirdPartyApp WITH(nolock)
WHERE	appKey = @i_AppKey AND appType = 1
IF (@appToken IS NOT NULL) AND (@appSecret IS NOT NULL)
BEGIN
	EXEC dbo.pswEncryptionManaged @appToken	, @encryptToken OUTPUT
	EXEC dbo.pswEncryptionManaged @appSecret, @encryptSecret OUTPUT
	SET @errorCode = 0
END
-- -- SP BODY END : AppGetThirdPartyEncryptedKeys.spb ------------------------------------------------------------------------------------------------------------------------------
SET @o_xmlText =
		(   SELECT
            (SELECT @errorCode      AS '@errorCode'     FOR XML PATH('error'), TYPE),
            (SELECT @i_appKey       AS '@appKey',
                    @encryptToken   AS '@appToken',
                    @encryptSecret  AS '@appSecret',
                    @isEnabled      AS '@isEnabled',
                    @flags          AS '@flags',
                    @description    AS '@appDescription',
                    (
                        SELECT @props.query('props') FOR XML PATH('props'), TYPE
                    )
                    FOR XML PATH('clientThirdPartyApps'), TYPE)
            FOR XML PATH('App_GetClientThirdPartyAppPropResp'), TYPE
         )
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetThirdPartyEncryptedKeysXML')
	delete from GxQscripts where name = 'AppGetThirdPartyEncryptedKeysXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetThirdPartyEncryptedKeysXML')
	delete from GXDBVersions where aliasname = 'AppGetThirdPartyEncryptedKeysXML'
GO

insert into GXDBVersions values(2, 'AppGetThirdPartyEncryptedKeysXML',  '00010001000200020000', 'AppGetThirdPartyEncryptedKeysXML', '00010001000200020000')
GO

