

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetThirdPartyEncryptedKeys.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetThirdPartyEncryptedKeys.sp,v $ $Id: AppGetThirdPartyEncryptedKeys.sp,v 1.4.54.1 2018/08/27 15:33:05 evolohov Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetThirdPartyEncryptedKeys <<<'

IF EXISTS (select * from sysobjects where name='AppGetThirdPartyEncryptedKeys')
	drop procedure AppGetThirdPartyEncryptedKeys
IF EXISTS (select * from GxQscripts where name='AppGetThirdPartyEncryptedKeys')
	delete from GxQscripts where name = 'AppGetThirdPartyEncryptedKeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetThirdPartyEncryptedKeys')
	delete from GXDBVersions where aliasname = 'AppGetThirdPartyEncryptedKeys'
GO
print '... Creating Procedure: AppGetThirdPartyEncryptedKeys'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetThirdPartyEncryptedKeys
  @i_AppKey NVARCHAR(MAX)
AS
SET NOCOUNT ON
-- -- SP BODY BEGIN : AppGetThirdPartyEncryptedKeys.spb ----------------------------------------------------------------------------------------------------------------------------
DECLARE @appToken   			NVARCHAR(MAX)
DECLARE @appSecret			   	NVARCHAR(MAX)
DECLARE @encryptToken 			NVARCHAR(MAX)
DECLARE @encryptSecret 			NVARCHAR(MAX)
DECLARE @isEnabled				INTEGER
DECLARE @errorCode				INTEGER
SET @appToken = NULL
SET @appSecret = NULL
SET @encryptToken = ''
SET @encryptSecret = ''
SET @errorCode = 1 -- assuming we don't find the entry for given appKey
--Get the AppToken and appSecret from DB if it exists, send error if otherwise.
SELECT	@appToken = appToken, @appSecret = appSecret, @isEnabled = isEnabled
FROM	App_ThirdPartyApp WITH(nolock)
WHERE	appKey = @i_AppKey AND appType = 1
IF (@appToken IS NOT NULL) AND (@appSecret IS NOT NULL)
BEGIN
	EXEC dbo.pswEncryptionManaged @appToken	, @encryptToken OUTPUT
	EXEC dbo.pswEncryptionManaged @appSecret, @encryptSecret OUTPUT
	SET @errorCode = 0
END
-- -- SP BODY END : AppGetThirdPartyEncryptedKeys.spb ------------------------------------------------------------------------------------------------------------------------------
select @errorCode AS errorCode , @encryptToken as token , @encryptSecret AS secret , @isEnabled AS isEnabled
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetThirdPartyEncryptedKeys')
	delete from GxQscripts where name = 'AppGetThirdPartyEncryptedKeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetThirdPartyEncryptedKeys')
	delete from GXDBVersions where aliasname = 'AppGetThirdPartyEncryptedKeys'
GO

insert into GXDBVersions values(2, 'AppGetThirdPartyEncryptedKeys',  '00010004005400010000', 'AppGetThirdPartyEncryptedKeys', '00010004005400010000')
GO

