

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetThirdPartyAppInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetThirdPartyAppInfo.sp,v $ $Id: AppGetThirdPartyAppInfo.sp,v 1.9.2.21 2020/08/05 00:57:55 manosivams Exp $";
-- =============================================
-- Author:		Rohit Iyer
-- Create date: 05/01/2014
-- Description:	Get 3rd party APP details
-- =============================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetThirdPartyAppInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetThirdPartyAppInfo <<<'
	drop procedure AppGetThirdPartyAppInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetThirdPartyAppInfo')
	delete from GxQscripts where name = 'AppGetThirdPartyAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetThirdPartyAppInfo')
	delete from GXDBVersions where aliasname = 'AppGetThirdPartyAppInfo'
GO
print '... Creating Procedure: AppGetThirdPartyAppInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetThirdPartyAppInfo
  @in_Xml XML
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @nRows 			INT
DECLARE @creatorId      INT
DECLARE @localeId  		INT
DECLARE @propLevel		INT
DECLARE @isAdminUser 	INT
DECLARE @errorCode 		INT
DECLARE @errorMessage 	VARCHAR(MAX)
DECLARE @xmlText 		XML
DECLARE @applicationList XML
DECLARE @uniqueAppName NVARCHAR(50)
DECLARE @r_errors XML
DECLARE @appType INT = 0
DECLARE @AppKeysTable TABLE
(
appKey nvarchar(max)
)
DECLARE @isTenantAdmin INT = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorMessage = ''
SET @xmlText = @in_xml
--Get Params from XML request
SET @creatorId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @xmlText.nodes('App_GetClientThirdPartyAppPropReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @xmlText.nodes('App_GetClientThirdPartyAppPropReq/processinginstructioninfo/locale') R ( ref )),0)
SET @propLevel = ISNULL((SELECT ref.value('@propLevel', 'int') AS col1
						 FROM    @xmlText.nodes('App_GetClientThirdPartyAppPropReq') R ( ref )), 0)
SET @uniqueAppName = ISNULL((SELECT ref.value('@uniqueAppName', 'nvarchar(50)') AS col1
						 FROM    @xmlText.nodes('App_GetClientThirdPartyAppPropReq') R ( ref )), '')
SET @appType = ISNULL((SELECT ref.value('@appType', 'int')
						 FROM    @xmlText.nodes('App_GetClientThirdPartyAppPropReq') R ( ref )), 0)
--First and foremost, check for the requesting user detail
IF (NOT EXISTS(SELECT 1 FROM UMUsers WHERE id = @creatorId))
BEGIN
	SET @errorCode	= 1
SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WHERE messageId = (475 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId )
    SET @errorMessage = REPLACE(@errorMessage, '^1%s', @creatorId)
    GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @creatorId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	--Check if the user is either Tentant Admin or Tenant Operator
IF EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where ((UG.groupFlags & 0x10000 <> 0) or (UG.groupFlags & 0x40000 <> 0)) and UU.userId=@creatorId)
	BEGIN
		SET @isTenantAdmin=1
	END
	ELSE
	BEGIN
		SET @errorCode	= 1
SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId )
		GOTO SEND_RESPONSE
	END
END
IF  @uniqueAppName <> ''
BEGIN
	SET @nRows = (SELECT COUNT(*) FROM App_ThirdPartyApp WHERE appName = @uniqueAppName )
	IF(@nRows != 1 )
	BEGIN
		SET @errorCode	= 1
		SET @errorMessage = 'Not a valid multicommcell application'
		GOTO SEND_RESPONSE
	END
END
--Insert appKeys from request into temp table only if @propLevel = 1
--For propLevel = 1, we will return all applications for the requesting user, hence no insertion into temp Table
IF(@propLevel <> 1)
BEGIN
	INSERT INTO @AppKeysTable(appKey)
	SELECT  ISNULL(ref.value('@val', 'nvarchar(256)'),'') AS appKey
			FROM    @xmlText.nodes('App_GetClientThirdPartyAppPropReq/appKeys') R ( ref )
	UNION (SELECT APPKEY FROM App_ThirdPartyApp WHERE appName = @uniqueAppName and ((@appType = 0) or (@appType = appType)) )
--delete all rows from AppKeyTable where the appKey value = 0 as such application do not exist
	DELETE AKT
		FROM  @AppKeysTable AKT LEFT JOIN App_ThirdPartyApp ATPA ON AKT.appKey = ATPA.appKey
		WHERE ATPA.appKey IS NULL
	SET @nRows = (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @AppKeysTable)
	IF(@nRows =0)
	BEGIN
		SET @errorCode	= 1
		SET @errorMessage = 'No valid Appkeys to fetch data. Exiting'
		GOTO SEND_RESPONSE
	END
END
--security for every apptype
declare @securityassociations table(appid int, associations xml)
declare @currentid int
declare @outxml xml
DECLARE appids cursor for
select id from App_ThirdPartyApp tp join
@AppKeysTable ak on ak.appKey = tp.appKey
open appids
fetch next from appids
into @currentid
while @@FETCH_STATUS = 0
begin
	exec dbo.[MCC_ConfigureMulticcappUserAssoc]  'GET',@outxml OUT ,@currentid,@errorCode OUT , @errorMessage OUT
	IF(@errorCode != 0)
		GOTO SEND_RESPONSE
	insert into @securityassociations(appid,associations)values(@currentid ,(select @outxml for xml path('')))
	fetch next from appids
into @currentid
end
close appids
deallocate appids
--If propLeve = 1 , the request if meant to fetch all applications for the requesting userId, hence no AppKeys would be sent in this case
IF @propLevel = 1
BEGIN
	IF(@isTenantAdmin = 1)
	BEGIN
	DECLARE @ownerCompany INT
	Select @ownerCompany=U.id from UMDSProviders U inner join UMUsers Users on U.id=Users.umDSproviderId where Users.id = @creatorId
IF  EXISTS (Select 1 from UMDSProviders U where U.serviceType <> 5 and U.id=@ownerCompany)
	BEGIN
		Select @ownerCompany=U.ownerCompany from UMDSProviders U where U.id=@ownerCompany
	END
	SET  @applicationList =(SELECT ATPA.appKey 		AS '@appKey',
								UMDS.id				AS '@umdsWrapperId',
								ATPA.appName 		AS '@appName',
								appType				AS	'@appType',
								@ownerCompany		AS '@createAsCompanyId',
								(SELECT UP.hostName from UMDSProviders UP where UP.id=@ownerCompany) AS '@createAsCompanyName',
								ATPA.appDescription AS '@appDescription',
								ATPA.flags			AS '@flags',
								(CASE WHEN (ATPA.isEnabled = 1) THEN 'true' ELSE 'false' END) AS '@isEnabled'
FROM App_ThirdPartyApp ATPA INNER JOIN UMDSProviderProp UMDSProp on CAST(UMDSProp.attrVal as int) = ATPA.id INNER JOIN UMDSProviders UMDS on UMDS.id=UMDSProp.componentNameId   and UMDS.ownerCompany=@ownerCompany and UMDS.serviceType = 11 and UMDSProp.attrName = 'SAML IDP' and ((@appType = 0) or (@appType = appType))
							FOR XML PATH('clientThirdPartyApps') )
	END
	ELSE
	BEGIN
	SET  @applicationList = (SELECT ATPA.appKey 		AS '@appKey',
(SELECT UP.id from UMDSProviders UP inner join UMDSProviderProp UPP on UP.id=UPP.componentNameId where UPP.attrVal=ATPA.id and UPP.attrName='SAML IDP') AS '@umdsWrapperId',
								ATPA.appName 		AS '@appName',
								appType				AS	'@appType',
								ATPA.appDescription AS '@appDescription',
								ATPA.flags			AS '@flags',
								(CASE when appType = 3 THEN
														(select	T.C.value('@value', 'nvarchar(max)') from ATPA.props.nodes('/props/nameValues[@name="RedirectUrl"]') as T(C)
															    ) ELSE NULL END )  as '@webConsoleUrl',
(select ownerCompany from UMDSProviders UP inner join UMDSProviderProp UPP on UP.id=UPP.componentNameId where UPP.attrVal=ATPA.id and UPP.attrName='SAML IDP') AS '@createAsCompanyId',
(SELECT UP.hostName from UMDSProviders UP inner join UMDSProviders UM on UM.ownerCompany=UP.id inner join UMDSProviderProp UPP on UM.id=UPP.componentNameId where UPP.attrVal=ATPA.id and UPP.attrName='SAML IDP') AS '@createAsCompanyName',
								(case when appType = 3 then (select
																T.C.value('@value', 'nvarchar(max)') from ATPA.props.nodes('/props/nameValues[@name="App Display Name"]') as T(C))
											else null end) as '@appDisplayName',
							    (CASE WHEN (ATPA.isEnabled = 1) THEN 'true' ELSE 'false' END) AS '@isEnabled',
							    (select longVal from app_componentProp  where componentType=1034 and propertyTypeId=3 and componentId=ATPA.id )AS '@isCloudApp',
								(CASE WHEN (ATPA.appType = 5)	THEN ( select (select ref.value('@name','nvarchar(255)') as '@name' ,
																			 ref.value('@value','nvarchar(MAX)') as '@value'
																			 FROM  ATPA.props.nodes('/props/nameValues') R ( ref )
																			 where ref.value('@name','nvarchar(255)') <> 'webConsoleUrls'
																			 for xml path('nameValues') ,type),
																			 (select 'webConsoleUrls' as '@name',
																					(select T.C.value('@val', 'nvarchar(max)')  as '@val'
																					 from ATPA.props.nodes('/props/nameValues[@name="webConsoleUrls"]/values') as T(C)
																					 for xml path('values') ,type)
																			  for xml path('nameValues'),type)
																	 for xml path('props') ,type)
															   ELSE NULL END)
						FROM App_ThirdPartyApp ATPA where ((@appType = 0) or (@appType = appType))
							FOR XML PATH('clientThirdPartyApps') )
	END
END
ELSE
BEGIN
	SET  @applicationList = (SELECT ATPA.appKey 		AS '@appKey',
(SELECT UP.id from UMDSProviders UP inner join UMDSProviderProp UPP on UP.id=UPP.componentNameId where UPP.attrVal=ATPA.id and UPP.attrName='SAML IDP') AS '@umdsWrapperId',
									ATPA.appName 		AS '@appName',
									appType				AS	'@appType',
									ATPA.flags			AS '@flags',
									(CASE when appType = 3 THEN
														(select	T.C.value('@value', 'nvarchar(max)') from ATPA.props.nodes('/props/nameValues[@name="RedirectUrl"]') as T(C)
															    ) ELSE NULL END )  as '@webConsoleUrl',
(select ownerCompany from UMDSProviders UP inner join UMDSProviderProp UPP on UP.id=UPP.componentNameId where UPP.attrVal=ATPA.id and UPP.attrName='SAML IDP') AS '@createAsCompanyId',
(SELECT UP.hostName from UMDSProviders UP inner join UMDSProviders UM on UM.ownerCompany=UP.id inner join UMDSProviderProp UPP on UM.id=UPP.componentNameId where UPP.attrVal=ATPA.id and UPP.attrName='SAML IDP') AS '@createAsCompanyName',
									(CASE WHEN (ATPA.isEnabled = 1) THEN 'true' ELSE 'false' END) 		AS '@isEnabled',
									(CASE WHEN @propLevel >10 THEN ATPA.ownerId ELSE NULL END) 			AS '@ownerId',
									(CASE WHEN @propLevel >10 THEN ATPA.appDescription ELSE NULL END) 	AS '@appDescription',
									(CASE WHEN @propLevel >20 THEN ATPA.appToken 	ELSE NULL END) 		AS '@appToken',
									(CASE WHEN @propLevel >20 THEN ATPA.appSecret 	ELSE NULL END) 		AS '@appSecret',
									(select longVal from app_componentProp  where componentType=1034 and propertyTypeId=3 and componentId=ATPA.id )AS '@isCloudApp',
									(case when appType = 3 then (select
																T.C.value('@value', 'nvarchar(max)') from ATPA.props.nodes('/props/nameValues[@name="App Display Name"]') as T(C))
											else null end) as '@appDisplayName',
									(case when @propLevel >10 THEN ( select (select ref.value('@name','nvarchar(255)') as '@name' ,
																			 ref.value('@value','nvarchar(MAX)') as '@value'
																			 FROM  ATPA.props.nodes('/props/nameValues') R ( ref )
																			 where ref.value('@name','nvarchar(255)') <> 'webConsoleUrls'
																			 for xml path('nameValues') ,type),
																			 (select 'webConsoleUrls' as '@name',
																					(select T.C.value('@val', 'nvarchar(max)')  as '@val'
																					 from ATPA.props.nodes('/props/nameValues[@name="webConsoleUrls"]/values') as T(C)
																					 for xml path('values') ,type)
																			  for xml path('nameValues'),type)
																	 for xml path('props') ,type)
															   ELSE NULL END),
(CASE WHEN (ATPA.appType = 2) THEN (Select CAST(attrval as xml) from App_ThirdPartyAppProp where componentNameId = ATPA.id and attrname='Attribute Mapping')
								ELSE NULL END),
									(Case when  @propLevel >10 then( select (select TokenUser as '@userfromToken',
																					MappedUserId as 'localuser/@userId'
																		from App_ThirdPartyUserMappings where issuerid = ATPA.id
																for xml path('userslist'),type)
																for xml path('UserMappings'),type)
																else null end),
									SEC.associations.query('Associations/assocTree'),
									(select domain.id as "domain/@id" , domain.domainName as "domain/@domainName",
										cast('<emailDomains val="'+Replace(stringVal,';','"/><emailDomains val="')+'"/>' as XML)
											from APP_ComponentProp ACP inner join UMDSProviders domain on domain.id=ACP.componentId
											where ACP.componentType=112 and ACP.longVal= ATPA.id for xml path('associations') ,type)
							FROM App_ThirdPartyApp ATPA INNER JOIN @AppKeysTable AKT ON ATPA.appKey = AKT.appKey
							JOIN @securityassociations SEC ON ATPA.id= SEC.appid
							FOR XML PATH('clientThirdPartyApps') )
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode 	 AS '@errorCode',
						@errorMessage AS '@errorString'
					FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@applicationList ,'')
                 FOR xml path(''),ROOT('App_GetClientThirdPartyAppPropResp')
               )
SET NOCOUNT OFF
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetThirdPartyAppInfo')
	delete from GxQscripts where name = 'AppGetThirdPartyAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetThirdPartyAppInfo')
	delete from GXDBVersions where aliasname = 'AppGetThirdPartyAppInfo'
GO

insert into GXDBVersions values(2, 'AppGetThirdPartyAppInfo',  '00010009000200210000', 'AppGetThirdPartyAppInfo', '00010009000200210000')
GO

