

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTenantAdminFromAuthCode.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetTenantAdminFromAuthCode.sp,v $ $Id: AppGetTenantAdminFromAuthCode.sp,v 1.1.2.1 2019/05/31 21:17:09 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetTenantAdminFromAuthCode')
BEGIN
	print '>>> Drop Stored Procedure: AppGetTenantAdminFromAuthCode <<<'
	drop procedure AppGetTenantAdminFromAuthCode
END
IF EXISTS (select * from GxQscripts where name='AppGetTenantAdminFromAuthCode')
	delete from GxQscripts where name = 'AppGetTenantAdminFromAuthCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTenantAdminFromAuthCode')
	delete from GXDBVersions where aliasname = 'AppGetTenantAdminFromAuthCode'
GO
print '... Creating Procedure: AppGetTenantAdminFromAuthCode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetTenantAdminFromAuthCode
  @authCode VARCHAR(32),
  @localeId INT,
  @o_tenantAdminUserId INT OUTPUT,
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
  DECLARE @tenantAdmin INT
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @tenantAdmin = 0
	SET @errorCode = 0
	SET @errorString = 0
	DECLARE @authCompanyID INTEGER
SELECT @authCompanyID=componentNameId FROM APP_CompanyProp WHERE attrname='Authorization Code' and attrVal=@authCode AND modified=0
	IF @authCompanyID IS NOT NULL AND (@authCompanyID >=0)
    BEGIN
		DECLARE @excludeUserFlags INT = dbo.sec_getExcludeFlagsForUser()
		IF (@authCompanyID > 0)
		BEGIN
			SET @tenantAdmin = (SELECT TOP 1 UU.id FROM UMUsers UU
						INNER JOIN UMUserGroup UUG
						ON UUG.userId=UU.id
						INNER JOIN UMGroups UG
ON UG.id=UUG.groupId AND UG.groupFlags&0x10000<> 0 and UG.umdsProviderId=@authCompanyID
						WHERE (UU.flags& @excludeUserFlags) = 0)
		END
		ELSE
		BEGIN
SET @tenantAdmin = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
		END
    END
	ELSE
	BEGIN
SET @errorCode = (3974 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3974 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	SET @o_errorCode			= @errorCode
	SET @o_errorString			= @errorString
	SET @o_tenantAdminUserId	= @tenantAdmin
SELECT @tenantAdmin, @errorCode, @errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTenantAdminFromAuthCode')
	delete from GxQscripts where name = 'AppGetTenantAdminFromAuthCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTenantAdminFromAuthCode')
	delete from GXDBVersions where aliasname = 'AppGetTenantAdminFromAuthCode'
GO

insert into GXDBVersions values(2, 'AppGetTenantAdminFromAuthCode',  '00010001000200010000', 'AppGetTenantAdminFromAuthCode', '00010001000200010000')
GO

