

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTenantAdminForCompany.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetTenantAdminForCompany()
--  | Description:  Allows for GET of Tenant Admin provided ProviderID
--  +==============================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetTenantAdminForCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppGetTenantAdminForCompany <<<'
	drop procedure AppGetTenantAdminForCompany
END
IF EXISTS (select * from GxQscripts where name='AppGetTenantAdminForCompany')
	delete from GxQscripts where name = 'AppGetTenantAdminForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTenantAdminForCompany')
	delete from GXDBVersions where aliasname = 'AppGetTenantAdminForCompany'
GO
print '... Creating Procedure: AppGetTenantAdminForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetTenantAdminForCompany
  @providerId INT,
  @isCalledFromCpp INT,
  @o_tenantAdminId INT OUTPUT,
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @tenantAdminId INT
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
	SET @tenantAdminId = 0
	DECLARE @companyId  INT  = dbo.AppGetCompanyForProvider(@providerId)
    IF ISNULL(@companyId, 0) != 0
	BEGIN
        -- get company's admin group
DECLARE @tenantAdminGroupId INT = (SELECT UG.id FROM UMGroups UG where UG.groupFlags & 0x10000 <> 0 AND UG.umdsProviderId = @companyId)
        IF ISNULL(@tenantAdminGroupId, 0) != 0
		BEGIN
            -- get tenant admin id
            SET @tenantAdminId = ISNULL((SELECT TOP 1 userId FROM UMUserGroup WHERE groupId = @tenantAdminGroupId),0)
        END
    END
	ELSE
	BEGIN
		-- You can get Master user Id
		--uu.setWhere("(flags & %d) <> 0", USERS_ADMIN)
SET @tenantAdminId = ISNULL((SELECT TOP 1 id FROM UMUsers WHERE (flags & 0x040) <>0),0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET @o_tenantAdminId = @tenantAdminId
SET @o_errorCode	 = @errorCode
SET @o_errorString	 = @errorString
IF (@isCalledFromCpp = 1)
	SELECT @o_tenantAdminId , @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTenantAdminForCompany')
	delete from GxQscripts where name = 'AppGetTenantAdminForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTenantAdminForCompany')
	delete from GXDBVersions where aliasname = 'AppGetTenantAdminForCompany'
GO

insert into GXDBVersions values(2, 'AppGetTenantAdminForCompany',  '00000000000000000000', 'AppGetTenantAdminForCompany', '00000000000000000000')
GO

