

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTargetMongoCacheForEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetTargetMongoCacheForEntities.sp,v $ $Id: AppGetTargetMongoCacheForEntities.sp,v 1.1.4.13.8.2 2021/06/01 21:55:04 riyer Exp $";
--	+==============================================================================================================================+
--	| AppGetTargetMongoCacheForEntities - Returns a list of mongodb caches in which the given list of entities belong to			|
--	+==============================================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetTargetMongoCacheForEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppGetTargetMongoCacheForEntities <<<'
	drop procedure AppGetTargetMongoCacheForEntities
END
IF EXISTS (select * from GxQscripts where name='AppGetTargetMongoCacheForEntities')
	delete from GxQscripts where name = 'AppGetTargetMongoCacheForEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTargetMongoCacheForEntities')
	delete from GXDBVersions where aliasname = 'AppGetTargetMongoCacheForEntities'
GO
print '... Creating Procedure: AppGetTargetMongoCacheForEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetTargetMongoCacheForEntities
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlReq XML,
  @o_xmlResp NVARCHAR(MAX) OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @r_xmlString XML;
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @function		VARCHAR(80) = 'AppGetTargetMongoCacheForEntities'
	DECLARE @APP_VIRTSERV_KUBERNETES nvarchar(16) = '1501'
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	--Temp table to hold all entities sent in request
	IF object_id('tempdb.dbo.#EntityCacheTargets') IS NOT NULL
		DROP TABLE #EntityCacheTargets
	CREATE TABLE #EntityCacheTargets (
		entityType		INT NOT NULL,
		entityId		INT NOT NULL,
		isServer		INT DEFAULT 0,
		isFileServer	INT DEFAULT 0,
		isVMGroup		INT DEFAULT 0,
		isVM			INT DEFAULT 0,
		isLaptop		INT DEFAULT 0,
		isArchiveServer INT DEFAULT 0,
		isUser			INT DEFAULT 0,
		isUserGroup		INT DEFAULT 0,
		isRole			INT DEFAULT 0,
		isEpicClient	INT DEFAULT 0,
		isK8App			INT DEFAULT 0,
		isK8AppGroup	INT DEFAULT 0,
		isHypervisor	INT DEFAULT 0,
		isK8Cluster		INT DEFAULT 0,
		isPlan          INT DEFAULT 0,
		isServerGroup	INT DEFAULT 0,
		isCompany		INT DEFAULT 0
	)
	CREATE UNIQUE CLUSTERED INDEX EntityCacheTargets_type_id_IDX ON #EntityCacheTargets (entityType, entityId)
	--Insert all valid entities (CvEntities.x) into table variable
	insert into #EntityCacheTargets(entityType, entityId)
	SELECT 	ref.value('@entityType', 'int') AS entityType,
			ref.value('@entityId', 'int') 	AS entityId
	FROM @i_xmlReq.nodes('Api_GetTargetCacheForEntityReq/entities') R ( ref )
	WHERE ISNULL(ref.value('@_type_', 'int'), 0) > 0	--VALID ENTITIES ONLY
	---------------------------------------CLIENT_ENTITY----------------------------------------------
IF EXISTS(select top 1 1 from #EntityCacheTargets where entityType = 3 and entityId > 0)
	BEGIN
		--Need a list of table of all File System iDAs. will be used to filter out FS clients/subclients later
		IF object_id('tempdb.dbo.#fsIDAListTbl') IS NOT null DROP TABLE #fsIDAListTbl
		CREATE TABLE #fsIDAListTbl    (
			[r_appId] INT
		)
		INSERT INTO #fsIDAListTbl
		SELECT appTypeId from APP_AppTypeGroupAssoc where appGroupId = 35 and typeOfGroup = 0  --File server apptype
		--[SERVERS]
		update ECT
		set ECT.isServer = 1
		from #EntityCacheTargets ECT
inner join App_Client AC on ECT.entityId = AC.id and ECT.entityType = 3 --Client Entities
		--Need a table which stores some select properties for a client [isInfrasturcture, InstallJobId]
        IF object_id('tempdb.dbo.#clientSelectPropTbl') IS NOT null DROP TABLE #clientSelectPropTbl
		CREATE TABLE #clientSelectPropTbl    (
			clientId		 			INT,
			IsInfrastructureMachine		INT,
			installJobId				INT,
			virtualServerDiscovered		INT,
			clientAppType				INT,
			vmInstanceId				INT
		)
		CREATE UNIQUE CLUSTERED INDEX ClientSelectPropTbl_type_id_IDX ON #clientSelectPropTbl (clientId);
		INSERT INTO #clientSelectPropTbl
		SELECT  componentNameId                         AS clientId,
				[IsInfrastructureMachine]               AS IsInfrastructureMachine,
				[Install Job Id]                        AS installJobId,
				[Virtual Server Discovered Clients]		AS virtualServerDiscovered,
				[Client App Type]						AS clientAppType,
				[Virtual Machine Instance ID]			AS vmInstanceId
		FROM (
				select
					componentNameId,
					attrName,
					attrVal
				from    #EntityCacheTargets ECT
inner join App_Client AC WITH(NOLOCK) on ECT.entityId = AC.id and ECT.entityType = 3
				left outer join App_ClientProp ACP WITH(NOLOCK) on AC.id = ACP.componentNameId
				and     ACP.modified = 0 and attrName IN (
							'IsInfrastructureMachine',
							'Install Job Id',
							'Virtual Server Discovered Clients',
							'Client App Type',
							'Virtual Machine Instance ID')
			) AS clients
		PIVOT   (MAX(attrVal) FOR attrName IN (
					[IsInfrastructureMachine],
					[Install Job Id],
					[Virtual Server Discovered Clients],
					[Client App Type],
					[Virtual Machine Instance ID])
			) AS P
		--[FS BASED SERVERS]
		--Want to execute below statements IFF there is atleast 1 FS client in the request
		IF EXISTS(	select 1
					from #EntityCacheTargets ECT
					inner join APP_IDAName IDA WITH(NOLOCK) on IDA.clientId = ECT.entityId
					inner join #fsIDAListTbl FSA on IDA.appTypeId = FSA.r_appId
where ECT.entityType = 3)
		BEGIN
			--Need to get list of File Server clients which either have an consumed FS license for install or backup
			IF object_id('tempdb.dbo.#FSLicensedOrBackupClients') IS NOT NULL DROP TABLE #FSLicensedOrBackupClients
			CREATE TABLE #FSLicensedOrBackupClients
			(
				[cId] INT primary key
			)
			INSERT INTO #FSLicensedOrBackupClients
			SELECT CId
			FROM #EntityCacheTargets ECT
inner join APP_IDAName I WITH(NOLOCK) on ECT.entityId = I.clientId and ECT.entityType = 3
			inner join LicUsage L on L.AppType=I.appTypeId
			INNER JOIN #fsIDAListTbl fs ON fs.r_appId = I.appTypeId
			WHERE  L.optype = 'Install'
			UNION
			SELECT clientId
			FROM #EntityCacheTargets ECT
inner join APP_Application AP WITH(NOLOCK) on ECT.entityId = AP.clientId and ECT.entityType = 3
			inner join #fsIDAListTbl fs ON fs.r_appId = AP.appTypeId
			inner join APP_SubClientProp ASCP  WITH(NOLOCK)
			ON ASCP.componentNameId = AP.id AND ASCP.attrName='Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
			--[FS SERVERS/EPIC CLIENTS]
			update ECT
			set ECT.isFileServer = ( case when (cp.clientAppType <> 11 OR cp.clientAppType IS NULL) THEN 1 ELSE 0 end),
				ECT.isEpicClient = ( case when (cp.clientAppType = 11 ) THEN 1 ELSE 0 end)
from #EntityCacheTargets ECT inner join App_Client AC on ECT.entityId = AC.id and ECT.entityType = 3
			inner join  APP_IDAName IDA on IDA.clientId = AC.id
			inner join  #fsIDAListTbl FS on IDA.appTypeId = FS.r_appId
			left outer join #clientSelectPropTbl CSPT on CSPT.clientId = ECT.entityId
			left outer join simOperatingSystem SIM on AC.simOperatingSystemId = SIM.id
			left outer join #FSLicensedOrBackupClients LBFS on AC.id = LBFS.CId
			LEFT JOIN #clientSelectPropTbl cp ON cp.clientId = ECT.entityId
			and
(AC.specialClientFlags & 0x1 <> 0x1) --Filter out Hidden clients
			and
			(
(AC.specialClientFlags & 0x20 = 0x20)
OR	((AC.specialClientFlags = 0) AND (AC.status & 0x1000 = 0))
OR	(SIM.SubType = 'NAS')
OR	(SIM.id in (49,118))
				OR  (ISNULL(CSPT.installJobId, 0) > 0)
			)
			and
			(ISNULL(CSPT.isInfrastructureMachine, 0) = 0 OR LBFS.CId is not null) --Either it shouldn't be Infrastructure client OR should consume FS license or be backed up by one
			--[ARCHIVE SERVERS]
			UPDATE ECT
			SET ECT.isArchiveServer = 1,
				ECT.isFileServer = 0
			FROM #EntityCacheTargets ECT
INNER JOIN App_Client AC WITH(NOLOCK) ON ECT.entityId = AC.id and ECT.entityType = 3
			INNER JOIN APP_Application APP WITH(NOLOCK) ON ECT.entityId = APP.clientId
			INNER JOIN APP_BackupsetProp ABP WITH(NOLOCK)
				ON ABP.componentNameId = APP.backupset
				AND ABP.attrName = 'Is Archiving Enabled'
				AND ABP.attrVal = '1'
				AND ABP.modified = 0
		END
		--[HYPERVISOR/K8 CLUSTER]
		UPDATE ECT
		SET ECT.isHypervisor = (case when (IP.attrVal <> @APP_VIRTSERV_KUBERNETES) THEN 1 ELSE ECT.isHypervisor END),
			ECT.isK8Cluster = (case when (IP.attrVal = @APP_VIRTSERV_KUBERNETES) THEN 1 ELSE ECT.isK8Cluster END)
FROM #EntityCacheTargets ECT inner join App_Client AC WITH(NOLOCK) ON ECT.entityId = AC.id and ECT.entityType = 3
		inner join APP_Application IDA ON IDA.clientId = AC.id
		inner join APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = IDA.instance and IP.attrName = 'Virtual Server Instance Type'
		where IDA.appTypeId = 106	--Virtualization
		--[LAPTOPS]
		update ECT
		set ECT.isLaptop = 1
from #EntityCacheTargets ECT inner join App_Client AC on ECT.entityId = AC.id and ECT.entityType = 3
		inner join APP_Application AAP WITH(NOLOCK) on AAP.clientId = AC.id
		INNER JOIN APP_BackupSetName BS on BS.id = AAP.backupSet
		INNER JOIN APP_AppTypeGroupAssoc ATGA ON AAP.appTypeId=ATGA.appTypeId AND ATGA.appGroupId=35 AND ATGA.typeOfGroup=0
where (AC.status & 0x1000) = 0x1000
and (AAP.subClientStatus & 0x00008) = 0x00008
and (BS.STATUS & 0x00008) = 0x00008
and (AC.status & 0x10000000) = 0 -- make sure it is not an edge client
		--[VIRTUAL MACHINES/KUBERNETES APPS]
		update ECT
		SET ECT.isVM = (case when (AIP.attrVal is null OR (AIP.attrVal is not null AND AIP.attrVal <> @APP_VIRTSERV_KUBERNETES)) THEN 1 ELSE ECT.isVM END),
			ECT.isK8App = (case when (AIP.attrVal is not null AND AIP.attrVal = @APP_VIRTSERV_KUBERNETES) THEN 1 ELSE ECT.isK8App END)
		FROM #EntityCacheTargets ECT
inner join App_ClientProp ACP on ECT.entityId = ACP.componentNameId AND ECT.entityType = 3 AND ACP.attrName = 'Virtual Server Discovered Clients' AND ACP.attrval = '1'
		inner join APP_ClientProp ACP2 ON ACP2.componentNameId = ECT.entityId AND ACP2.attrName = 'Virtual Machine Instance ID' AND ACP2.modified = 0
		left outer join APP_InstanceProp AIP ON CAST(AIP.componentNameId AS NVARCHAR(32)) = ACP2.attrval AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified = 0
	END
	-----------------------------------------SUBCLIENT_ENTITY--------------------------------------
IF EXISTS(select top 1 1 from #EntityCacheTargets where entityType = 7 and entityId > 0)
	BEGIN
		--[VM GROUPS/KUBERNETES APP GROUPS]
		update ECT
			set ECT.isVMGroup =  (case when (AIP.attrVal <> @APP_VIRTSERV_KUBERNETES) THEN 1 ELSE ECT.isVMGroup END),
				ECT.isK8AppGroup =  (case when (AIP.attrVal = @APP_VIRTSERV_KUBERNETES) THEN 1 ELSE ECT.isK8AppGroup END)
from #EntityCacheTargets ECT inner join APP_Application AAP WITH (NOLOCK) on ECT.entityId = AAP.id and ECT.entityType = 7 and AAP.appTypeId = 106 --Virtualization
		inner join APP_InstanceProp AIP WITH (NOLOCK) ON AIP.componentNameId = AAP.instance AND AIP.attrName='Virtual Server Instance Type' AND AIP.modified=0
	END
	------------------------------------------USER_ENTITY------------------------------------------
IF EXISTS(SELECT 1 from #EntityCacheTargets WHERE entityType = 13 and entityId > 0)
	BEGIN
		UPDATE ECT
		SET	ECT.isUser = (ECT.isUser | 1)
FROM #EntityCacheTargets ECT INNER JOIN UMUsers userTbl ON ECT.entityId = userTbl.id and ECT.entityType = 13
	END
	---------------------------------------USERGROUP_ENTITY-----------------------------------------
IF EXISTS(select 1 from #EntityCacheTargets where entityType = 15 and entityId > 0)
	BEGIN
		UPDATE ECT
		SET	ECT.isUserGroup = (ECT.isUserGroup | 1)
FROM #EntityCacheTargets ECT INNER JOIN UMGroups umg ON ECT.entityId = umg.id and ECT.entityType = 15
	END
	---------------------------------------ROLE_ENTITY-----------------------------------------
IF EXISTS(select 1 from #EntityCacheTargets where entityType = 120 and entityId > 0)
	BEGIN
		UPDATE ECT
		SET	ECT.isRole = (ECT.isRole | 1)
FROM #EntityCacheTargets ECT INNER JOIN UMRoles UMR ON ECT.entityId = UMR.id and ECT.entityType = 120
WHERE (UMR.flags & 4) = 0
	END
	---------------------------------------CLIENT_GROUP_ENTITY-----------------------------------------
IF EXISTS(select 1 from #EntityCacheTargets where entityType = 28 and entityId > 0)
	BEGIN
		UPDATE ECT
		SET	ECT.isServerGroup = (ECT.isServerGroup | 1)
FROM #EntityCacheTargets ECT INNER JOIN APP_ClientGroup clg ON ECT.entityId = clg.id and ECT.entityType = 28
	END
	---------------------------------------PLAN_ENTITY-----------------------------------------
IF EXISTS(select 1 from #EntityCacheTargets where entityType = 158 and entityId > 0)
	BEGIN
		UPDATE ECT
		SET	ECT.isPlan = (ECT.isPlan | 1)
FROM #EntityCacheTargets ECT INNER JOIN App_Plan AP ON ECT.entityId = AP.id and ECT.entityType = 158
	END
	---------------------------------------PROVIDER_ENTITY-----------------------------------------
IF EXISTS(select 1 from #EntityCacheTargets where entityType = 61 and entityId > 0)
	BEGIN
		UPDATE ECT
		SET	ECT.isCompany = (ECT.isCompany | 1)
FROM #EntityCacheTargets ECT INNER JOIN UMDSProviders UMDSProvider ON ECT.entityId = UMDSProvider.id and ECT.entityType = 61
		WHERE UMDSProvider.serviceType = 5 -- company service Type.
	END
	--Create final response XML based on entity/cache map table
	SET @o_xmlResp = CAST((
			SELECT (
				SELECT	ECT.isServer		as '@isServer',
						ECT.isFileServer	as '@isFileServer',
						ECT.isLaptop		as '@isLaptop',
						ECT.isVM			as '@isVM',
						ECT.isVMGroup		as '@isVMGroup',
						ECT.isArchiveServer	as '@isArchiveServer',
						ECT.isUser			as '@isUser',
						ECT.isUserGroup     as '@isUserGroup',
						ECT.isRole			as '@isRole',
						ECT.isEpicClient	as '@isEpicClient',
						ECT.isK8App			as '@isK8App',
						ECT.isK8AppGroup	as '@isK8AppGroup',
						ECT.isHypervisor	as '@isHypervisor',
						ECT.isK8Cluster		as '@isK8Cluster',
						ECT.isServerGroup	as '@isServerGroup',
						ECT.isPlan          as '@isPlan',
						ECT.isCompany		as '@isCompany',
					(
						SELECT	ECT.entityType	as	'@entityType',
								ECT.entityId	as	'@entityId',
								ECT.entityType	as	'@_type_',
(case when ECT.entityType = 3 then ECT.entityId else 0 end) as '@clientId',
(case when ECT.entityType = 7 then ECT.entityId else 0 end) as '@subclientId',
(case when ECT.entityType = 13 then ECT.entityId else 0 end) as '@userId',
(case when ECT.entityType = 15 then ECT.entityId else 0 end) as '@userGroupId',
(case when ECT.entityType = 120 then ECT.entityId else 0 end) as '@roleId',
(case when ECT.entityType = 28 then ECT.entityId else 0 end) as '@serverGroupId',
(case when ECT.entityType = 158 then ECT.entityId else 0 end) as '@planId',
(case when ECT.entityType = 61 then ECT.entityId else 0 end) as '@providerId'
						FOR XML PATH('entity'), TYPE
					)
				FROM #EntityCacheTargets ECT
				FOR XML PATH('targetEntityCaches'), TYPE
			)
			FOR XML PATH('Api_GetTargetCacheForEntityResp')
		) AS NVARCHAR(MAX))
	-- drop temp table
	IF object_id('tempdb.dbo.#fsIDAListTbl') IS NOT NULL
		DROP TABLE #fsIDAListTbl
	IF object_id('tempdb.dbo.#EntityCacheTargetsListTbl') IS NOT NULL
		DROP TABLE #EntityCacheTargetsListTbl
	IF object_id('tempdb.dbo.#clientSelectPropTbl') IS NOT NULL
		DROP TABLE #clientSelectPropTbl
	IF object_id('tempdb.dbo.#FSLicensedOrBackupClients') IS NOT NULL
		DROP TABLE #FSLicensedOrBackupClients
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTargetMongoCacheForEntities')
	delete from GxQscripts where name = 'AppGetTargetMongoCacheForEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTargetMongoCacheForEntities')
	delete from GXDBVersions where aliasname = 'AppGetTargetMongoCacheForEntities'
GO

insert into GXDBVersions values(2, 'AppGetTargetMongoCacheForEntities',  'v1.1.4.13.8.2', 'AppGetTargetMongoCacheForEntities', 'v1.1.4.13.8.2')
GO

