

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetTableFiltersForUser.sp] ---------- 

--sp to get the table filters based on filterType and userId
--if filterid is set, send complete details of the filter
--else sent back the list of all filters where the user has permission
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetTableFiltersForUser <<<'

IF EXISTS (select * from sysobjects where name='AppGetTableFiltersForUser')
	drop procedure AppGetTableFiltersForUser
IF EXISTS (select * from GxQscripts where name='AppGetTableFiltersForUser')
	delete from GxQscripts where name = 'AppGetTableFiltersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTableFiltersForUser')
	delete from GXDBVersions where aliasname = 'AppGetTableFiltersForUser'
GO
print '... Creating Procedure: AppGetTableFiltersForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetTableFiltersForUser
  @userId INT,
  @filterType INT,
  @filterId INT = 0
AS
  DECLARE @o_responseXML XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#filterList') is not null
    DROP TABLE #filterList
CREATE TABLE #filterList (filterId INT NOT NULL)
DECLARE @securityAssociations XML
-- if filterID is set , send only details of that filter
IF (@filterId <> 0)
	BEGIN
		DECLARE @hasViewPermission INT = 0
		--admin user has permission on all filters
SELECT @hasViewPermission = 1 FROM UMUsers where id = @userId and flags & 0x040<>0
		--check if user has  permission on this filter
		if(@hasViewPermission = 0)
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @userId, 173, 31, '#filterList'
			SELECT @hasViewPermission = 1 FROM #filterList WHERE filterId = @filterId
		END
		--clear all entries
		DELETE FROM #filterList
		--if user has permission, get the details
		IF(@hasViewPermission <> 0)
			BEGIN
EXEC sec_getSecurityForEntity @userId, @securityAssociations OUTPUT, 173, @filterId
				INSERT INTO #filterList VALUES (@filterId)
			END
	END
ELSE
	--admin can see all filters
	BEGIN
IF EXISTS(SELECT 1 FROM UMUsers where id = @userId and flags & 0x040<>0)
				INSERT INTO #filterList
				SELECT id FROM APP_JobCtrlFilter
		ELSE
EXEC sec_getNonIdaObjectsForThisUser @userId, 173, 31, '#filterList'
	END
SET @o_responseXML = ISNULL((
	SELECT
	(	SELECT
				flag as '@filterType' ,
				entityAssocXML as '@filterXml',
				opType as '@state',
				@securityAssociations as 'filterSecurity',
				(SELECT id as '@filterId',
				 name as '@filterName'
				 FOR XML PATH('tableFilter'),type),
				(SELECT userId as '@userId'
				 FOR XML PATH('creator'),type)
		FROM App_JobCtrlFilter INNER JOIN #filterList
		ON filterId=id	and @filterType = flag
		FOR XML PATH('filters'),TYPE
	)
	FOR XML PATH('Api_GetTableFiltersResponse')
	),'<Api_GetTableFiltersResponse/>')
DROP TABLE #filterList
SELECT @o_responseXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetTableFiltersForUser')
	delete from GxQscripts where name = 'AppGetTableFiltersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetTableFiltersForUser')
	delete from GXDBVersions where aliasname = 'AppGetTableFiltersForUser'
GO

insert into GXDBVersions values(2, 'AppGetTableFiltersForUser',  '00000000000000000000', 'AppGetTableFiltersForUser', '00000000000000000000')
GO

