

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSyncWebFoldersForAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================================+
--	|  					  AppGetSyncWebFoldersForAppId									|
--	|  Procedure to get a list of Sync content and folder info for a given subclient	|
--	+===================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSyncWebFoldersForAppId <<<'

IF EXISTS (select * from sysobjects where name='AppGetSyncWebFoldersForAppId')
	drop procedure AppGetSyncWebFoldersForAppId
IF EXISTS (select * from GxQscripts where name='AppGetSyncWebFoldersForAppId')
	delete from GxQscripts where name = 'AppGetSyncWebFoldersForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSyncWebFoldersForAppId')
	delete from GXDBVersions where aliasname = 'AppGetSyncWebFoldersForAppId'
GO
print '... Creating Procedure: AppGetSyncWebFoldersForAppId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSyncWebFoldersForAppId
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_appId INT
-----------------------------------------------------------
AS
  DECLARE @o_syncWebFolderId INT
  DECLARE @o_syncContent NVARCHAR(MAX)
SET NOCOUNT ON
BEGIN
	SELECT C.syncWebFolderId, syncPath
		FROM App_SyncCloudConfig C INNER JOIN
			App_SyncCloudFolder F ON F.syncWebFolderId = C.syncWebFolderId AND C.subclientId = @i_appId
		WHERE C.syncType & 1 = 1        -- Sync Source
			AND C.flag & 1 <> 1
			AND F.flag & 1 <> 1
	DECLARE @clientId INT = (SELECT clientId FROM APP_Application WHERE id = @i_appId)
	DECLARE @isSync1Enabled INT = ISNULL((
		SELECT TOP 1 1
		FROM App_SyncCloudFolder WF
		JOIN App_SyncCloudConfig CF ON CF.syncWebFolderId = WF.syncWebFolderId AND CF.clientId = @clientId AND CF.subclientId = @i_appId AND CF.syncType & 1 = 1 -- SyncType_SOURCE
		LEFT JOIN (SELECT SFV.syncWebFolderId FROM App_SyncCloudFolders SFV  -- VIEW FOR SHARE
					WHERE SFV.FLAG <> 0) SH ON SH.syncWebFolderId = WF.syncWebFolderId
WHERE (WF.flag & CAST(0x1 AS INT) = 0)
AND (CF.flag & CAST(0x1 AS INT)) = 0
AND (WF.flag & 0x10 = 0)
		AND SH.syncWebFolderId IS NULL
	),0)
	IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE attrName = 'Sync1 Feature Enabled' AND componentNameId = @clientId AND modified = 0)
	BEGIN
		INSERT INTO APP_ClientProp
			(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		VALUES
			(@clientId
			,'Sync1 Feature Enabled'
			,2 -- PROPERTY_BOOLEAN
			,@isSync1Enabled
			,dbo.GetUnixTime(GETUTCDATE())
			,0
			,0)
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSyncWebFoldersForAppId')
	delete from GxQscripts where name = 'AppGetSyncWebFoldersForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSyncWebFoldersForAppId')
	delete from GXDBVersions where aliasname = 'AppGetSyncWebFoldersForAppId'
GO

insert into GXDBVersions values(2, 'AppGetSyncWebFoldersForAppId',  '00000000000000000000', 'AppGetSyncWebFoldersForAppId', '00000000000000000000')
GO

