

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSyncCopyDetails.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2016  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSyncCopyDetails.sp,v $ $Id: AppGetSyncCopyDetails.sp,v 1.1.2.5 2020/01/05 03:51:18 bheemesh Exp $";
-- =========================================================
-- Author: Sarath Joseph
-- Description: Get the live sync copy details
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSyncCopyDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSyncCopyDetails <<<'
	drop procedure AppGetSyncCopyDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetSyncCopyDetails')
	delete from GxQscripts where name = 'AppGetSyncCopyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSyncCopyDetails')
	delete from GXDBVersions where aliasname = 'AppGetSyncCopyDetails'
GO
print '... Creating Procedure: AppGetSyncCopyDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSyncCopyDetails
  @xmlText XML
AS
SET NOCOUNT ON;
	DECLARE @jobId INT = ISNULL(@xmlText.value('(Api_GetSyncCopyDetailsReq)[1]/@jobId', 'int'),0)
	DECLARE @appId INT = @xmlText.value('(Api_GetSyncCopyDetailsReq/subclient)[1]/@subclientId', 'int')
	DECLARE @copyPrecedence INT = (SELECT N.value(N'@copyPrecedence', N'nvarchar(max)')FROM @xmlText.nodes (N'Api_GetSyncCopyDetailsReq') AS T(N))
	DECLARE @spId int
	if ( @jobid >0 )
	begin
		set @spId = (select top 1 archGrpId from JMJobDataStats where jobId =@jobId)
		if ( isnull(@spId, 0) =0)
		begin
			-- check child job
			declare @childjob int
			select @childjob = ( select top 1 childjobid from jmjobdatalink where parentJobId = @jobid and linkType = 7 )
			set @spId = (select top 1 archGrpId from JMJobDataStats where jobId =@childjob)
		end
	end
	IF ( isnull(@spId,0) =0)
	begin
		select @spId = dataArchGrpID from APP_Application WITH (NOLOCK) where id =@appId
	end
	SET @xmlText = (
	select
        defaultCopy as '@defaultCopyId',
	-- STORAGE POLICY DETAILS
	(
	 select AG.id as '@storagePolicyId',
	 AG.name as '@StoragePolicyName'
	 for xml path ('storagePolicy'),TYPE
	),
	-- COPY DETAILS
	(
	 select AGC.id as '@copyId',
	 AGC.name as '@copyName'
	for xml path ('copy'),TYPE
	)
	from archGroup AG WITH(NOLOCK)
	join archgroupcopy AGC WITH(NOLOCK) ON AGC.archGroupId = AG.id
	where AG.id = @spId
	and AGC.copy =@copyPrecedence
	for xml path ('Api_GetSyncCopyDetailsResp'),TYPE)
	select isnull(@xmlText, '<Api_GetSyncCopyDetailsResp/>')
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSyncCopyDetails')
	delete from GxQscripts where name = 'AppGetSyncCopyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSyncCopyDetails')
	delete from GXDBVersions where aliasname = 'AppGetSyncCopyDetails'
GO

insert into GXDBVersions values(2, 'AppGetSyncCopyDetails',  '00010001000200050000', 'AppGetSyncCopyDetails', '00010001000200050000')
GO

