

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubscriptionForType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSubscriptionForType.sp,v $ $Id: AppGetSubscriptionForType.sp,v 1.1.2.11 2020/08/20 05:57:23 vmishra Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTGetDetectedAlerts
--	- Fetch the list of detected alerts matching input conditions.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubscriptionForType')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubscriptionForType <<<'
	drop procedure AppGetSubscriptionForType
END
IF EXISTS (select * from GxQscripts where name='AppGetSubscriptionForType')
	delete from GxQscripts where name = 'AppGetSubscriptionForType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubscriptionForType')
	delete from GXDBVersions where aliasname = 'AppGetSubscriptionForType'
GO
print '... Creating Procedure: AppGetSubscriptionForType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubscriptionForType
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @m_entityType int, 
  @m_subType int
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @userId int
  DECLARE @entityId int
  DECLARE @updateType int
  DECLARE @localeId int
-- If update type is for push notification or none then we consider push notification subscribers
IF object_id('tempdb.dbo.#userSubscriptionInfo') is not null
		DROP TABLE #userSubscriptionInfo
Create Table #userSubscriptionInfo
(
	userId int,
	entityId int,
	updateType int,
	localeId int,
	entityType INT,
	primary key(userId,entityId, localeId)
)
DECLARE @localeSupportedSubscriptionType TABLE (subscriptionType INT)
INSERT INTO @localeSupportedSubscriptionType values (0), (4)-- 0: JOBS, 4: Events
if (@m_subType=14) -- JOB_DETAIL
begin
	Insert into #userSubscriptionInfo (userId, entityId, updateType, localeId, entityType)
	select distinct s.userId, vs.value('@val', 'int') as EntityId,1 , localeId, n.type
	from App_NotificationSubscription n join UMQSDKSessions s on n.sessionId = s.id
	CROSS APPLY n.filter.nodes('Api_NotificationFilter/filterIds/entityIds') V(vs)
	where n.type = @m_entityType
	and n.filter is not null
end
else
begin
	Insert into #userSubscriptionInfo (userId, entityId, updateType, localeId, entityType)
	-- Type has to match always.
	select distinct s.userId, 0,1, localeId, n.type
	from App_NotificationSubscription n join UMQSDKSessions s on n.sessionId = s.id
	where (type=@m_entityType)
	--For Alert, also need to insert mobile device subscription list for AlertSubscribers
	if(@m_entityType = 1)	--Alert
	begin
		--insert all users who have a session and are not already present in #userSubscriptionInfo
		insert into #userSubscriptionInfo (userId, entityId, updateType, localeId, entityType)
select distinct activeUserId, 0, 1, 0, 1	-- 1: ALERT entityType, send 0 localeId as MDM_InstalledApp has no info on locale
		  from MDM_InstalledApp A left join #userSubscriptionInfo B on A.activeUserId = B.userId AND B.entityId = 0
		  where B.userId is null
	end
end
-- Get the alert type for the subsystem Id and retrieve all users who are subscribed
Declare @alertTypeId int = dbo.NTGetAlertTypeForSubscriptionType(@m_entityType)
if (@alertTypeId>0)
begin
		IF object_id('tempdb.dbo.#userAlertSubscriptionInfo') is not null
			DROP TABLE #userAlertSubscriptionInfo
		Create Table #userAlertSubscriptionInfo
		(
			userId int,
			entityId int,
			primary key(userId,entityId )
		)
		Insert into #userAlertSubscriptionInfo
		select distinct userId, 0 as entityId
		from NTAlertSubScriptions
		inner join NTNotificationRule on NTAlertSubScriptions.ntRuleId=NTNotificationRule.id
		and NTNotificationRule.alertTypeId=@alertTypeId
		and (NTNotificationRule.status&2)=0
		and NTNotificationRule.revision=1
and ((NTNotificationRule.status & 128)>0)
and (flags & 1)>0
	-- Merge with heavy data set can cause performance issues.
	update userSubscriptionInfo
	SET updateType=updateType|2 -- Alert also
	from #userSubscriptionInfo userSubscriptionInfo
	inner join #userAlertSubscriptionInfo AlertSubscribers
	on userSubscriptionInfo.userId = AlertSubscribers.userId and AlertSubscribers.entityId=userSubscriptionInfo.entityId
    INSERT into #userSubscriptionInfo( userId ,entityId ,updateType, entityType )
select distinct AlertSubscribers.userId,AlertSubscribers.entityId, 2, 1
	from #userAlertSubscriptionInfo AlertSubscribers
	left join #userSubscriptionInfo userSubscriptionInfo on
	userSubscriptionInfo.userId = AlertSubscribers.userId and AlertSubscribers.entityId=userSubscriptionInfo.entityId
	where userSubscriptionInfo.userId is null
end
select distinct userId ,entityId ,updateType, localeId from #userSubscriptionInfo U
	WHERE U.entityType IN (SELECT subscriptionType FROM @localeSupportedSubscriptionType)
UNION ALL
SELECT distinct userId, entityId, updateType, 0 FROM #userSubscriptionInfo S
	WHERE S.entityType NOT IN (SELECT subscriptionType FROM @localeSupportedSubscriptionType)
IF object_id('tempdb.dbo.#userSubscriptionInfo') is not null
		DROP TABLE #userSubscriptionInfo
return
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubscriptionForType')
	delete from GxQscripts where name = 'AppGetSubscriptionForType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubscriptionForType')
	delete from GXDBVersions where aliasname = 'AppGetSubscriptionForType'
GO

insert into GXDBVersions values(2, 'AppGetSubscriptionForType',  '00010001000200110000', 'AppGetSubscriptionForType', '00010001000200110000')
GO

