

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientsWithBackupDisabled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubclientsWithBackupDisabled')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubclientsWithBackupDisabled <<<'
	drop procedure AppGetSubclientsWithBackupDisabled
END
IF EXISTS (select * from GxQscripts where name='AppGetSubclientsWithBackupDisabled')
	delete from GxQscripts where name = 'AppGetSubclientsWithBackupDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsWithBackupDisabled')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsWithBackupDisabled'
GO
print '... Creating Procedure: AppGetSubclientsWithBackupDisabled'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubclientsWithBackupDisabled
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML	
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	-- Error handlers.
	DECLARE	@errorCode	INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	-- Reading from xml
	DECLARE	@clientGroupId	INT = 0
	DECLARE	@clientId	INT = 0
	DECLARE	@csInstanceId	INT = 0
	DECLARE	@backupSetId	INT = 0
	-- Attribute name.
	DECLARE	@attrName	NVARCHAR(1024) = N''
	SELECT 	@clientGroupId = ISNULL(ref.value('@clientGroupId', 'INT'), 0),
		@clientId = ISNULL(ref.value('@clientId', 'INT'), 0),
		@csInstanceId = ISNULL(ref.value('@csInstanceId', 'INT'), 0),
		@backupSetId = ISNULL(ref.value('@backupSetId', 'INT'), 0)
		FROM @i_xmlString.nodes('CVGui_GetSubclientsWithBackupDisabledReq') R (ref)
	CREATE TABLE #SubClientIdList (id INT PRIMARY KEY)
	INSERT INTO #SubClientIdList
	-- disable at subclient level
	SELECT appId FROM JMJobAction JMJA
		INNER JOIN APP_Application AP ON JMJA.appId = AP.id
WHERE AP.appTypeId <> 1030
		AND JMJA.clientId = 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
	UNION
	-- disable at client level
	SELECT id FROM APP_Application AP
		INNER JOIN JMJobAction JMJA ON JMJA.clientId = AP.clientId
		WHERE JMJA.clientId <> 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
		AND JMJA.appType = 0
	UNION
	-- disable at agent level
	SELECT id FROM APP_Application AP
		INNER JOIN JMJobAction JMJA ON JMJA.clientId = AP.clientId AND JMJA.appType = AP.appTypeId
		WHERE JMJA.clientId <> 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
		AND JMJA.appType <> 0
	UNION
	-- disable at client computer group level
	SELECT id FROM APP_Application AP
		INNER JOIN APP_ClientGroupAssoc ACGA ON ACGA.clientId = AP.clientId
			INNER JOIN JMJobAction JMJA ON JMJA.clientGroupId  = ACGA.clientGroupId
		WHERE JMJA.clientId = 1
			AND JMJA.clientGroupId <> 0
			AND JMJA.mediaAgentID = 1
			AND opType = 4  -- BACKUP
			AND action = 1 -- DISABLEACTIVITY
			AND instanceID = 1
	UNION
	-- disable at subclient policy level
	SELECT componentNameId FROM APP_SubClientProp
		WHERE attrName = 'Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy')
		AND attrVal IN ( SELECT DISTINCT CAST(appId AS NVARCHAR(32)) FROM JMJobAction JMJA INNER JOIN APP_Application AP ON JMJA.appId = AP.id
WHERE AP.appTypeId = 1030
		AND  JMJA.clientId = 1
		AND  JMJA.clientGroupId = 0
		AND  JMJA.mediaAgentID = 1
		AND  JMJA.opType = 4  -- BACKUP
		AND  JMJA.action = 1 -- DISABLEACTIVITY
		AND  JMJA.instanceID = 1)
	IF OBJECT_ID('tempdb.dbo.#vmSubclientList') IS NOT NULL
        DROP TABLE #vmSubclientList
	CREATE TABLE #vmSubclientList (
            vmBackupSetId INT,
			vmSubclientId INT,
			vsaSubclientId INT
    )
	--Find the VM subclients for the corresponding VSA subclients
	INSERT INTO #vmSubclientList
	select distinct vmb.ChildBackupSetId,vmAppl.id,appl.id from app_vmbackupset vmb
	INNER JOIN App_ClientProp clProp ON clProp.componentNameId=vmb.VMClientId AND clProp.attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND clProp.modified = 0
	INNER JOIN APP_Application appl ON appl.backupSet=vmb.ParentBackupSetId AND Appl.id = CAST(clProp.attrVal AS INT)
	INNER JOIN APP_Application vmAppl ON vmAppl.backupSet=vmb.ChildBackupSetId AND (vmAppl.subclientStatus & 0x00008 = 0x00008)
	where appl.id in (SELECT DISTINCT SCIL.id AS "SubClientId" FROM #SubClientIdList SCIL)
	--Remove from the list if actively getting backedup from another subclient of same backupset
	delete from #vmSubclientList where vmBackupSetId in
	( select distinct vmb.ChildBackupSetId from app_vmbackupset vmb
	INNER JOIN App_ClientProp clProp ON clProp.componentNameId=vmb.VMClientId AND clProp.attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND clProp.modified = 0
	INNER JOIN APP_Application Appl ON appl.backupSet=vmb.ParentBackupSetId AND Appl.id = CAST(clProp.attrVal AS INT)
	where Appl.id not in (SELECT DISTINCT SCIL.id AS "SubClientId" FROM #SubClientIdList SCIL) )
	CREATE TABLE #FinalSubClientIdList (id INT)
	CREATE CLUSTERED INDEX #FinalSubClientIdList_id_Idx1 ON #FinalSubClientIdList (id)
	--Insert into the list if the subclient is in the input
	INSERT INTO #FinalSubClientIdList
		SELECT DISTINCT SCIL.id FROM #SubClientIdList SCIL
		INNER JOIN APP_Application APP ON APP.id = SCIL.id
		LEFT JOIN APP_ClientGroupAssoc ACGA ON APP.clientId = ACGA.clientId
		WHERE (@clientId = 0 OR APP.clientId = @clientId)
		AND (@backupSetId = 0 OR APP.backupSet = @backupSetId)
		AND (@csInstanceId = 0 OR APP.instance = @csInstanceId)
		AND (@clientGroupId = 0 OR ACGA.clientGroupId = @clientGroupId)
	--Insert into the list if the corresponding VSA subclient is in the input
	INSERT INTO #FinalSubClientIdList
		SELECT DISTINCT vmSubclientId FROM #vmSubclientList where vsaSubclientId in(SELECT DISTINCT SCIL.id AS "SubClientId" FROM #FinalSubClientIdList SCIL)
	--Insert into the list if the VM is in the input
	INSERT INTO #FinalSubClientIdList
		SELECT DISTINCT vmSubclientId FROM #vmSubclientList vmSCL
		INNER JOIN APP_Application APP ON APP.id = vmSCL.vmSubclientId
		LEFT JOIN APP_ClientGroupAssoc ACGA ON APP.clientId = ACGA.clientId
		WHERE (@clientId = 0 OR APP.clientId = @clientId)
		AND (@backupSetId = 0 OR APP.backupSet = @backupSetId)
		AND (@csInstanceId = 0 OR APP.instance = @csInstanceId)
		AND (@clientGroupId = 0 OR ACGA.clientGroupId = @clientGroupId)
	IF OBJECT_ID('tempdb.dbo.#AppGetSubclientsWithBackupDisabledExtTable') IS NOT NULL
	BEGIN
		-- clean up data
		DELETE FROM #AppGetSubclientsWithBackupDisabledExtTable
		-- dump into external inputted table
		IF EXISTS(SELECT 1 FROM #SubClientIdList)
		BEGIN
			INSERT INTO #AppGetSubclientsWithBackupDisabledExtTable
				SELECT DISTINCT SCIL.id AS "SubClientId" FROM #FinalSubClientIdList SCIL
		END
	END
	ELSE
	BEGIN
		SET @o_xmlString=(SELECT (SELECT DISTINCT SCIL.id AS "@subClientId" FROM #FinalSubClientIdList SCIL
			FOR XML PATH('Subclient'), ROOT('APP_GetSubclientsWithBackupDisabledResp'), TYPE))
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<APP_GetSubclientsWithBackupDisabledResp/>'
		SELECT @o_xmlString
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientsWithBackupDisabled')
	delete from GxQscripts where name = 'AppGetSubclientsWithBackupDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsWithBackupDisabled')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsWithBackupDisabled'
GO

insert into GXDBVersions values(2, 'AppGetSubclientsWithBackupDisabled',  '00000000000000000000', 'AppGetSubclientsWithBackupDisabled', '00000000000000000000')
GO

