

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientsForConfigurationPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubclientsForConfigurationPolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubclientsForConfigurationPolicy <<<'
	drop procedure AppGetSubclientsForConfigurationPolicy
END
IF EXISTS (select * from GxQscripts where name='AppGetSubclientsForConfigurationPolicy')
	delete from GxQscripts where name = 'AppGetSubclientsForConfigurationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsForConfigurationPolicy')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsForConfigurationPolicy'
GO
print '... Creating Procedure: AppGetSubclientsForConfigurationPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubclientsForConfigurationPolicy
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	-- Output xml string.
	DECLARE	@o_xmlString	XML
	-- Error handlers.
	DECLARE	@errorCode	INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	-- Reading from xml.
	DECLARE	@policyType		INT = 0
	DECLARE	@policyDetailType	INT = 0
	DECLARE	@policyId	INT = 0
	-- Attribute name.
	DECLARE	@attrName	NVARCHAR(1024) = N''
	SELECT 	@policyId = ISNULL(ref.value('@policyId', 'INT'), 0),
			@policyType = ISNULL(ref.value('@policyType', 'INT'), 0),
			@policyDetailType = ISNULL(ref.value('@policyDetailType', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetSubclientsForConfigurationPolicyReq') R (ref)
	-- Check if the policy type and policy detail type are missing.
	IF @policyType = 0 or @policyDetailType = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide policy type and policy detail type.'
		GOTO ERROR_EXIT
	END
	-- Set the correct attribute name.
	IF @policyType = 2 and @policyDetailType = 3 -- Retention File Policy
		SET @attrName = 'Fs Retention Policy ID'
	ELSE IF @policyType = 2 and @policyDetailType = 5 -- Content Indexing File Policy
		SET @attrName = 'Content Indexing Policy ID'
	-- Check if attribute name could be fetched from given information.
	IF @attrName = '' or @attrName IS NULL
	BEGIN
		SET @errorCode = 2
		SET @errorCode = 'Unknown policy and policy detail type.'
		GOTO ERROR_EXIT
	END
	DECLARE @subclientWithSubclientPolicy TABLE (subclientId INT, subclientPolicyId INT)
	IF @policyType <> 0 and @policyDetailType <> 0
	BEGIN
		IF @policyId <> 0
		BEGIN
			IF @attrName = 'Content Indexing Policy ID'
			BEGIN
				Declare @SubclientIds table (Id int)
				INSERT INTO @SubclientIds
				SELECT componentNameId FROM APP_SubClientProp
				WHERE attrName = 'Enable Content Indexing'
				and attrVal = '1'
				and modified = 0
				DELETE @SubclientIds
				FROM @SubclientIds SC
				INNER JOIN APP_SubClientProp SCProp (NOLOCK)
				ON SC.Id = SCProp.componentNameId
				WHERE SCProp.modified = 0
				AND SCProp.attrVal = '1'
				AND SCProp.attrName in (N'DDB Backup', N'Turbo Mode Enable Stubbing', N'Use block level backup', N'Enable Snap Backups', N'Reference Copy Flag')
	 			-- Handle if subclient policy is associated.
				INSERT INTO @subclientWithSubclientPolicy
				SELECT SC.Id, SCProp.attrVal
				FROM @SubclientIds SC
				INNER JOIN APP_SubClientProp SCProp (NOLOCK)
				ON SC.Id = SCProp.componentNameId
				WHERE SCProp.attrName = 'Associated subclient Policy'
				AND SCProp.attrVal > '0'
				AND SCProp.modified = 0
				DELETE @SubclientIds
				FROM @SubclientIds SC
				INNER JOIN @subclientWithSubclientPolicy SCP
				ON SC.Id = SCP.subclientId
				DELETE @subclientWithSubclientPolicy
				FROM @subclientWithSubclientPolicy SCP
				INNER JOIN APP_SubClientProp SCProp (NOLOCK)
				ON SCP.subclientPolicyId = SCProp.componentNameId
				WHERE SCProp.modified = 0
				AND SCProp.attrVal = '1'
				AND SCProp.attrName in (N'DDB Backup', N'Turbo Mode Enable Stubbing', N'Use block level backup', N'Enable Snap Backups', N'Reference Copy Flag')
				INSERT INTO @SubclientIds
				SELECT SCP.subclientId
				FROM @subclientWithSubclientPolicy SCP
				SET @o_xmlString =
				(SELECT APP.clientId as '@clientId',
					APP.appTypeId as '@applicationId',
					APP.instance as '@instanceId',
					APP.backupSet as '@backupsetId',
					APP.id as '@subclientId',
					APP.subclientName as '@subclientName',
					APP.GUID as '@subclientGUID'
					FROM APP_Application APP (NOLOCK)
					LEFT JOIN @SubclientIds subclientIdList
					ON App.id = subclientIdList.Id
					LEFT JOIN APP_SubclientProp SubclientProp (NOLOCK)
					ON subclientIdList.Id = SubclientProp.componentNameId
					WHERE SubclientProp.modified = 0
					AND SubclientProp.attrName = @attrName
					AND SubclientProp.attrVal = CAST(@policyId AS NVARCHAR(15))
					AND APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
					FOR XML PATH('association'),
					ROOT('Ida_GetSubclientsForConfigurationPolicyResp'))
			END
			ELSE
			BEGIN
				SET @o_xmlString =
				(SELECT APP.clientId as '@clientId',
					APP.appTypeId as '@applicationId',
					APP.instance as '@instanceId',
					APP.backupSet as '@backupsetId',
					APP.id as '@subclientId',
					APP.subclientName as '@subclientName',
					APP.GUID as '@subclientGUID'
					FROM APP_Application APP (NOLOCK)
					LEFT JOIN APP_SubclientProp SubclientProp (NOLOCK)
					ON SubclientProp.componentNameId = APP.id
					WHERE SubclientProp.modified = 0
					AND SubclientProp.attrName = @attrName
					AND SubclientProp.attrVal = CAST(@policyId AS NVARCHAR(15))
					AND APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
					FOR XML PATH('association'),
					ROOT('Ida_GetSubclientsForConfigurationPolicyResp'))
			END
		END
		ELSE
		BEGIN
		IF @attrName = 'Content Indexing Policy ID'
			BEGIN
				INSERT INTO @SubclientIds
				SELECT componentNameId FROM APP_SubClientProp
				WHERE attrName = 'Enable Content Indexing'
				and attrVal = '1'
				and modified = 0
				DELETE @SubclientIds
				FROM @SubclientIds SC
				INNER JOIN APP_SubClientProp SCProp (NOLOCK)
				ON SC.Id = SCProp.componentNameId
				WHERE SCProp.modified = 0
				AND SCProp.attrVal = '1'
				AND SCProp.attrName in (N'DDB Backup', N'Turbo Mode Enable Stubbing', N'Use block level backup', N'Enable Snap Backups', N'Reference Copy Flag')
	 			-- Handle if subclient policy is associated.
				INSERT INTO @subclientWithSubclientPolicy
				SELECT SC.Id, SCProp.attrVal
				FROM @SubclientIds SC
				INNER JOIN APP_SubClientProp SCProp (NOLOCK)
				ON SC.Id = SCProp.componentNameId
				WHERE SCProp.attrName = 'Associated subclient Policy'
				AND SCProp.attrVal > '0'
				AND SCProp.modified = 0
				DELETE @SubclientIds
				FROM @SubclientIds SC
				INNER JOIN @subclientWithSubclientPolicy SCP
				ON SC.Id = SCP.subclientId
				DELETE @subclientWithSubclientPolicy
				FROM @subclientWithSubclientPolicy SCP
				INNER JOIN APP_SubClientProp SCProp (NOLOCK)
				ON SCP.subclientPolicyId = SCProp.componentNameId
				WHERE SCProp.modified = 0
				AND SCProp.attrVal = '1'
				AND SCProp.attrName in (N'DDB Backup', N'Turbo Mode Enable Stubbing', N'Use block level backup', N'Enable Snap Backups', N'Reference Copy Flag')
				INSERT INTO @SubclientIds
				SELECT SCP.subclientId
				FROM @subclientWithSubclientPolicy SCP
				SET @o_xmlString =
				(SELECT APP.clientId as '@clientId',
					APP.appTypeId as '@applicationId',
					APP.instance as '@instanceId',
					APP.backupSet as '@backupsetId',
					APP.id as '@subclientId',
					APP.subclientName as '@subclientName',
					APP.GUID as '@subclientGUID'
					FROM APP_Application APP (NOLOCK)
					LEFT JOIN @SubclientIds subclientIdList
					ON App.id = subclientIdList.Id
					LEFT JOIN APP_SubclientProp SubclientProp (NOLOCK)
					ON subclientIdList.Id = SubclientProp.componentNameId
					WHERE SubclientProp.modified = 0
					AND SubclientProp.attrName = @attrName
					AND SubclientProp.attrVal <> '0'
					AND APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
					FOR XML PATH('association'),
					ROOT('Ida_GetSubclientsForConfigurationPolicyResp'))
			END
			ELSE
			BEGIN
				SET @o_xmlString =
				(SELECT APP.clientId as '@clientId',
					APP.appTypeId as '@applicationId',
					APP.instance as '@instanceId',
					APP.backupSet as '@backupsetId',
					APP.id as '@subclientId',
					APP.subclientName as '@subclientName',
					APP.GUID as '@subclientGUID'
					FROM APP_Application APP (NOLOCK)
					LEFT JOIN APP_SubclientProp SubclientProp (NOLOCK)
					ON SubclientProp.componentNameId = APP.id
					WHERE SubclientProp.modified = 0
					AND SubclientProp.attrName = @attrName
					AND SubclientProp.attrVal <> '0'
					AND APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
					FOR XML PATH('association'),
					ROOT('Ida_GetSubclientsForConfigurationPolicyResp'))
			END
		END
	END
	ERROR_EXIT:
		IF @errorCode <> 0
			SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('Ida_GenericResp'), Type)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<Ida_GetSubclientsForConfigurationPolicyResp/>'
		SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientsForConfigurationPolicy')
	delete from GxQscripts where name = 'AppGetSubclientsForConfigurationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsForConfigurationPolicy')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsForConfigurationPolicy'
GO

insert into GXDBVersions values(2, 'AppGetSubclientsForConfigurationPolicy',  '00000000000000000000', 'AppGetSubclientsForConfigurationPolicy', '00000000000000000000')
GO

