

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientsForBackupset.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetSubclientsForBackupset')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubclientsForBackupset <<<'
	drop procedure AppGetSubclientsForBackupset
END
IF EXISTS (select * from GxQscripts where name='AppGetSubclientsForBackupset')
	delete from GxQscripts where name = 'AppGetSubclientsForBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsForBackupset')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsForBackupset'
GO
print '... Creating Procedure: AppGetSubclientsForBackupset'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetSubclientsForBackupset
  @xmlText XML
AS
DECLARE @bsGuid NVARCHAR(36) = @xmlText.value('(/App_GetSubclientsForBackupsetReq/@backupsetGuid)[1]', 'NVARCHAR(36)')
DECLARE @bsId INT = (SELECT TOP 1 id FROM APP_BackupSetName WITH(NOLOCK) WHERE GUID = @bsGuid)
DECLARE @clientId INT = NULL
DECLARE @instId INT = NULL
DECLARE @opxmlText XML
SELECT TOP 1 @clientId = clientId, @instId = instance
FROM APP_Application WITH(NOLOCK)
WHERE backupSet = @bsId
DECLARE @outSubclientData TABLE (
	subclientName NVARCHAR(MAX),
	subclientId INT,
	subclientGUID NVARCHAR(36)
)
INSERT INTO @outSubclientData
	SELECT APP.subclientName, APP.id, APP.GUID
	FROM APP_Application APP WITH(NOLOCK)
	JOIN APP_BackupSetName ABSN WITH(NOLOCK) on APP.backupSet = ABSN.id
	WHERE ABSN.GUID = @bsGuid
-- Check if input backupset GUID is from a child VM, if so, return the parent application ID as well
IF EXISTS (SELECT 1 FROM APP_InstanceProp WITH(NOLOCK) WHERE componentNameId = @instId AND modified = 0 AND attrName = 'Discovered VM Instance' AND attrVal = '1')
BEGIN
	INSERT INTO @outSubclientData
		SELECT APP.subclientName, App.id, APP.GUID
		FROM APP_Application APP
		JOIN APP_VMBackupSet VM ON APP.backupSet = VM.ParentBackupSetId
		WHERE VM.ChildBackupSetId = @bsId
			AND APP.id IN (SELECT CAST(attrVal AS INT) FROM APP_ClientProp WHERE componentNameId = @clientId AND modified = 0 AND attrName = 'VSA Discover Subclient ID')
END
SET @opxmlText = (
		SELECT (
			SELECT subclientName AS '@subclientName', subclientId AS '@subclientId', subclientGUID AS 'subclientGUID'
			FROM @outSubclientData
			FOR XML PATH('subclients'), TYPE
			)
		FOR XML PATH ('App_GetSubclientsForBackupsetResp'), TYPE
)
SELECT @opxmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientsForBackupset')
	delete from GxQscripts where name = 'AppGetSubclientsForBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsForBackupset')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsForBackupset'
GO

insert into GXDBVersions values(2, 'AppGetSubclientsForBackupset',  '00000000000000000000', 'AppGetSubclientsForBackupset', '00000000000000000000')
GO

