

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientsDistinctCloudIds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- This SP fetches distinct cloud id and type for given set of subclients.
--DefineIdListType.spb
IF NOT EXISTS (SELECT * FROM systypes where name = 'IdList')
BEGIN
CREATE TYPE IdList AS TABLE
  (
      id integer
  )
END
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubclientsDistinctCloudIds')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubclientsDistinctCloudIds <<<'
	drop procedure AppGetSubclientsDistinctCloudIds
END
IF EXISTS (select * from GxQscripts where name='AppGetSubclientsDistinctCloudIds')
	delete from GxQscripts where name = 'AppGetSubclientsDistinctCloudIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsDistinctCloudIds')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsDistinctCloudIds'
GO
print '... Creating Procedure: AppGetSubclientsDistinctCloudIds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubclientsDistinctCloudIds
  @subclientIds IdList READONLY,
  @i_fetchExchangeVirtualClouds INT = 1,
  @i_distinctClouds INT = 1
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--AppGetSubclientsCloudId.spb
	IF OBJECT_ID('tempdb.dbo.#getSubclientsCloudIdOutTbl') IS NOT NULL
		DROP TABLE #getSubclientsCloudIdOutTbl
	CREATE TABLE #getSubclientsCloudIdOutTbl
	(
		SubClientId INT,
		AppType INT,
		BackupsetId INT,
		PseudoClientId INT,
		CloudId INT,
		CloudType INT
	)
	CREATE INDEX Idx_getSubclientsCloudIdOutTbl_SubClientId on #getSubclientsCloudIdOutTbl(SubClientId)
	--insert subclientid, appType, backupsetid, pseudoclientId into temp table 	for given input
	INSERT INTO #getSubclientsCloudIdOutTbl
	SELECT A.id, A.appTypeId, A.backupSet, idx.currentIdxServer, 0,0
	FROM APP_Application A
	INNER JOIN App_IndexDBInfo Idx ON Idx.backupSetId = A.backupSet
	where A.id in ( select id from @subclientIds )
	AND Idx.idxDbEngineType = 2
AND ( (@i_distinctClouds = 1 AND A.appTypeId = 137 ) OR @i_distinctClouds=0)
	IF ( @i_distinctClouds = 1 )
	BEGIN
		INSERT INTO #getSubclientsCloudIdOutTbl
		SELECT DISTINCT 0, A.appTypeId, 0, idx.currentIdxServer, 0,0
		FROM APP_Application A
		INNER JOIN App_IndexDBInfo Idx ON Idx.backupSetId = A.backupSet
		where A.id in ( select id from @subclientIds )
		AND Idx.idxDbEngineType = 2
AND A.appTypeId != 137
	END
	-- for appType 137, pseudoclientid retrieved in above step can be physical node client id ( in case of standalone servers )
	-- so overwrite it with actual pseudoclientid here from IDAProp table.
	-- Also for apptype 137, we need extra property "backupset type" to identify usermbx/journalmbx/contentstorembx
IF EXISTS (SELECT  1 FROM #getSubclientsCloudIdOutTbl where AppType = 137)
	BEGIN
		UPDATE #getSubclientsCloudIdOutTbl
		SET PseudoClientId = CAST(IP.attrVal AS int)
		FROM #getSubclientsCloudIdOutTbl T
		INNER JOIN App_Application A ON A.id = T.SubClientId
		INNER JOIN APP_IDAName IDAName ON IDAName.clientId = A.clientId
		INNER JOIN APP_IDAProp IP ON IP.componentNameId = IDAName.id
		where IP.modified = 0 AND IP.attrName ='OnePass Index Server'
AND T.AppType= 137
	END
	-- update cloud id and cloudtype based on pseudoclientid
	UPDATE  #getSubclientsCloudIdOutTbl
	SET CloudId = C.cloudId, CloudType = C.CloudType
	FROM #getSubclientsCloudIdOutTbl T
	INNER JOIN DM2Cloud C ON C.pseudoClientId = T.PseudoClientId
	IF ( @i_fetchExchangeVirtualClouds = 1 )
	BEGIN
		--insert journal index and mailbox index cloud id
		IF EXISTS (SELECT TOP 1 T.SubClientId FROM #getSubclientsCloudIdOutTbl T
					JOIN APP_BackupSetProp B ON B.componentNameId = T.BackupsetId
					where B.modified = 0 AND B.attrName='Exchange OnePass BackupSet Type'
AND T.AppType= 137 AND B.attrVal = '1' AND T.CloudType = 1 ) --standalone server, user mailbox
			INSERT INTO #getSubclientsCloudIdOutTbl
			SELECT 0, 0, 0,0, C.cloudId, C.CloudType
			FROM DM2Cloud C
where C.flags &  4 > 0
		IF EXISTS (SELECT TOP 1 T.SubClientId FROM #getSubclientsCloudIdOutTbl T
					JOIN APP_BackupSetProp B ON B.componentNameId = T.BackupsetId
					where B.modified = 0 AND B.attrName='Exchange OnePass BackupSet Type'
AND T.AppType= 137 AND B.attrVal in ('2','3') AND T.CloudType = 1) --standalone server, journal or contentstore mailbox
			INSERT INTO #getSubclientsCloudIdOutTbl
			SELECT 0, 0, 0,0, C.cloudId, C.CloudType
			FROM DM2Cloud C
where C.flags & 2 > 0
		--since we returned virtual cloud, we dont need standalone indexservers in output
DELETE FROM #getSubclientsCloudIdOutTbl where AppType =  137 AND CloudType = 1
	END
	--select output
	SELECT distinct CloudId,CloudType from #getSubclientsCloudIdOutTbl where CloudId <> 0
	--drop temp tables
	IF OBJECT_ID('tempdb.dbo.#getSubclientDataSourceOutTbl') IS NOT NULL
		DROP TABLE #getSubclientDataSourceOutTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientsDistinctCloudIds')
	delete from GxQscripts where name = 'AppGetSubclientsDistinctCloudIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsDistinctCloudIds')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsDistinctCloudIds'
GO

insert into GXDBVersions values(2, 'AppGetSubclientsDistinctCloudIds',  '00000000000000000000', 'AppGetSubclientsDistinctCloudIds', '00000000000000000000')
GO

