

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientsDataSource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--DefineIdListType.spb
IF NOT EXISTS (SELECT * FROM systypes where name = 'IdList')
BEGIN
CREATE TYPE IdList AS TABLE
  (
      id integer
  )
END
SET NOCOUNT ON
-- This SP fetches datasource id for given set of subclients. It fetches only those datasourceIds which are associated to backupsetGUID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubclientsDataSource')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubclientsDataSource <<<'
	drop procedure AppGetSubclientsDataSource
END
IF EXISTS (select * from GxQscripts where name='AppGetSubclientsDataSource')
	delete from GxQscripts where name = 'AppGetSubclientsDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsDataSource')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsDataSource'
GO
print '... Creating Procedure: AppGetSubclientsDataSource'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubclientsDataSource
  @subclientIds IdList READONLY
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--we dont want distinct clouds.. we want all datasources
	DECLARE @i_distinctClouds INT = 0
--AppGetSubclientsCloudId.spb
	IF OBJECT_ID('tempdb.dbo.#getSubclientsCloudIdOutTbl') IS NOT NULL
		DROP TABLE #getSubclientsCloudIdOutTbl
	CREATE TABLE #getSubclientsCloudIdOutTbl
	(
		SubClientId INT,
		AppType INT,
		BackupsetId INT,
		PseudoClientId INT,
		CloudId INT,
		CloudType INT
	)
	CREATE INDEX Idx_getSubclientsCloudIdOutTbl_SubClientId on #getSubclientsCloudIdOutTbl(SubClientId)
	--insert subclientid, appType, backupsetid, pseudoclientId into temp table 	for given input
	INSERT INTO #getSubclientsCloudIdOutTbl
	SELECT A.id, A.appTypeId, A.backupSet, idx.currentIdxServer, 0,0
	FROM APP_Application A
	INNER JOIN App_IndexDBInfo Idx ON Idx.backupSetId = A.backupSet
	where A.id in ( select id from @subclientIds )
	AND Idx.idxDbEngineType = 2
AND ( (@i_distinctClouds = 1 AND A.appTypeId = 137 ) OR @i_distinctClouds=0)
	IF ( @i_distinctClouds = 1 )
	BEGIN
		INSERT INTO #getSubclientsCloudIdOutTbl
		SELECT DISTINCT 0, A.appTypeId, 0, idx.currentIdxServer, 0,0
		FROM APP_Application A
		INNER JOIN App_IndexDBInfo Idx ON Idx.backupSetId = A.backupSet
		where A.id in ( select id from @subclientIds )
		AND Idx.idxDbEngineType = 2
AND A.appTypeId != 137
	END
	-- for appType 137, pseudoclientid retrieved in above step can be physical node client id ( in case of standalone servers )
	-- so overwrite it with actual pseudoclientid here from IDAProp table.
	-- Also for apptype 137, we need extra property "backupset type" to identify usermbx/journalmbx/contentstorembx
IF EXISTS (SELECT  1 FROM #getSubclientsCloudIdOutTbl where AppType = 137)
	BEGIN
		UPDATE #getSubclientsCloudIdOutTbl
		SET PseudoClientId = CAST(IP.attrVal AS int)
		FROM #getSubclientsCloudIdOutTbl T
		INNER JOIN App_Application A ON A.id = T.SubClientId
		INNER JOIN APP_IDAName IDAName ON IDAName.clientId = A.clientId
		INNER JOIN APP_IDAProp IP ON IP.componentNameId = IDAName.id
		where IP.modified = 0 AND IP.attrName ='OnePass Index Server'
AND T.AppType= 137
	END
	-- update cloud id and cloudtype based on pseudoclientid
	UPDATE  #getSubclientsCloudIdOutTbl
	SET CloudId = C.cloudId, CloudType = C.CloudType
	FROM #getSubclientsCloudIdOutTbl T
	INNER JOIN DM2Cloud C ON C.pseudoClientId = T.PseudoClientId
	select SubclientId, AppType, BackupsetId, PseudoClientId, CloudId, CloudType, 0 as DataSourceId, '' as Property, 0 as CaseClient
	into #getSubclientDataSourceOutTbl
	from #getSubclientsCloudIdOutTbl
	CREATE INDEX Idx_getSubclientDataSourceOutTbl_SubClientId on #getSubclientDataSourceOutTbl(SubClientId)
	CREATE INDEX Idx_getSubclientDataSourceOutTbl_DataSourceId on #getSubclientDataSourceOutTbl(DataSourceId)
	-- for apptype 137, we need extra property "backupset type" to identify usermbx/journalmbx/contentstorembx
IF EXISTS (SELECT  1 FROM #getSubclientDataSourceOutTbl where AppType = 137)
	BEGIN
		UPDATE #getSubclientDataSourceOutTbl
		SET Property = attrVal
		FROM #getSubclientDataSourceOutTbl T
		INNER JOIN APP_BackupSetProp B ON B.componentNameId = T.BackupsetId
		where B.modified = 0 AND B.attrName='Exchange OnePass BackupSet Type'
AND T.AppType= 137
	END
	DECLARE @l_backupsetguidPropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid = 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F')
	DECLARE @l_subSourceTypePropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid= 'F3C96257-7468-41CD-B40D-CF6D0D945DD3')
	--update datasourceId for standalone
	UPDATE #getSubclientDataSourceOutTbl
	SET DataSourceId = DS.DataSourceId,
	CaseClient= CASE ISNULL(C.id,0) WHEN 0 THEN 0 ELSE 1 END
	FROM SEDataSourceProperty DS (NOLOCK)
	JOIN APP_BackupSetName B ON (DS.PropertyId = @l_backupsetguidPropId and CAST( B.GUID AS nvarchar(36)) = DS.PropertyValue)
								OR ( dbo.isBackupSetGuidExists(DS.DataSourceId,CAST( B.GUID AS VARCHAR(36))) = 1)
	JOIN #getSubclientDataSourceOutTbl T ON B.id = T.BackupsetId
	JOIN SECollectionInfo SC ON SC.CloudID = T.CloudId
	JOIN SEDataSource D ON D.CoreId = SC.CoreId AND DS.DataSourceId = D.DataSourceId
	JOIN APP_Application A ON A.id = T.SubClientId
	LEFT JOIN CMDefinition C ON C.clientId = A.clientId
	where T.CloudType =1
	--update datasourceId for cloud
	UPDATE #getSubclientDataSourceOutTbl
	SET DataSourceId = DS.DataSourceId,
	CaseClient= CASE ISNULL(C.id,0) WHEN 0 THEN 0 ELSE 1 END
	FROM SEDataSourceProperty DS (NOLOCK)
	JOIN APP_BackupSetName B ON (DS.PropertyId = @l_backupsetguidPropId and CAST( B.GUID AS nvarchar(36)) = DS.PropertyValue)
								OR ( dbo.isBackupSetGuidExists(DS.DataSourceId,CAST( B.GUID AS VARCHAR(36))) = 1)
	JOIN #getSubclientDataSourceOutTbl T ON B.id = T.BackupsetId
	JOIN SEDataSourceProperty DS1 ON DS1.DataSourceId = DS.DataSourceId
	JOIN SECollectionInfo SC ON SC.CloudID = T.CloudId
	JOIN SEDataSource D ON D.CoreId = SC.CoreId AND DS.DataSourceId = D.DataSourceId
	JOIN APP_Application A ON A.id = T.SubClientId
	LEFT JOIN CMDefinition C ON C.clientId = A.clientId
	where DS1.PropertyId = @l_subSourceTypePropId AND DS1.PropertyValue <> 'metainfo'
	AND T.CloudType =5 AND T.DataSourceId = 0
	--select output
	SELECT * from #getSubclientDataSourceOutTbl order by SubClientId
	--drop temp tables
	IF OBJECT_ID('tempdb.dbo.#getSubclientDataSourceOutTbl') IS NOT NULL
		DROP TABLE #getSubclientDataSourceOutTbl
	IF OBJECT_ID('tempdb.dbo.#getSubclientsCloudIdOutTbl') IS NOT NULL
		DROP TABLE #getSubclientsCloudIdOutTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientsDataSource')
	delete from GxQscripts where name = 'AppGetSubclientsDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientsDataSource')
	delete from GXDBVersions where aliasname = 'AppGetSubclientsDataSource'
GO

insert into GXDBVersions values(2, 'AppGetSubclientsDataSource',  '00000000000000000000', 'AppGetSubclientsDataSource', '00000000000000000000')
GO

