

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientPoliciesList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetSubclientPoliciesList()
--  |
--  | Description:  SP for retreiving subclient policies list for XML based framework
--  |
--  |       Input:  XML input containing user id, hide flag
--  |      Output:  XML Output containing subclient policies list with id, name and status.
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetSubclientPoliciesList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubclientPoliciesList <<<'
	drop procedure AppGetSubclientPoliciesList
END
IF EXISTS (select * from GxQscripts where name='AppGetSubclientPoliciesList')
	delete from GxQscripts where name = 'AppGetSubclientPoliciesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientPoliciesList')
	delete from GXDBVersions where aliasname = 'AppGetSubclientPoliciesList'
GO
print '... Creating Procedure: AppGetSubclientPoliciesList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetSubclientPoliciesList
  @i_xml XML	OUTPUT,
  @shouldReturnCursor INT = 0
AS
  DECLARE @o_xml XML
DECLARE @userId INT
DECLARE @hide INT
DECLARE @backupsetId INT=0
SET @userId = ISNULL((SELECT @i_xml.value('(/App_GetSubclientPoliciesListReq/processinginstructioninfo/user/@userId)[1]', 'INT')), 1)
SET @hide = ISNULL((SELECT @i_xml.value('(/App_GetSubclientPoliciesListReq/@hideFlag)[1]', 'INT')), 0x0001)
SET @backupsetId = ISNULL((SELECT @i_xml.value('(/App_GetSubclientPoliciesListReq/@backupsetId)[1]', 'INT')), 0)
IF OBJECT_ID ('tempdb.dbo.#SCPolicyListTbl') IS NOT NULL
	DROP TABLE #SCPolicyListTbl
CREATE TABLE #SCPolicyListTbl
(
	clientId		INT,
	apptypeId		INT,
	instanceId		INT,
	scPolicyId		INT,
	scId			INT,
	scPolicyName	NVARCHAR(128),
	scPolicyStatus	INT
)
DECLARE @restrictSCPs INT = 1  --default behavior to restrict subclient policies.
SELECT @restrictSCPs = CAST(value AS INT)
	FROM GxGlobalParam (NOLOCK)
	WHERE name = 'restrictSubclientPolicies' AND modified = 0
IF (@restrictSCPs = 0 OR @userId = 0)			--Old behavior. Get all subclient policies.
	INSERT INTO #SCPolicyListTbl (clientId, appTypeId, instanceId, scPolicyId, scId, scPolicyName, scPolicyStatus)
		SELECT 2, 1030, 1, id, 0, name, status
		FROM App_BackupsetName
		WHERE status & 128 <> 0
ELSE
BEGIN
	INSERT INTO #SCPolicyListTbl (clientId, apptypeId, instanceId, scPolicyId, scId)
EXEC sec_getIdaObjectsForUserWrapper @userId, 6, 0, 0
	DELETE FROM #SCPolicyListTbl
WHERE apptypeId <> 1030
	IF @backupsetId <> 0
	BEGIN
		DELETE FROM #SCPolicyListTbl
		WHERE scPolicyId <> @backupsetId
	END
	UPDATE #SCPolicyListTbl
	SET scPolicyName = BS.name,
		scPolicyStatus = BS.status
	FROM #SCPolicyListTbl SCP INNER JOIN APP_BackupSetName BS WITH(NOLOCK)
		ON SCP.scPolicyId = BS.id AND ((BS.status & 128) = 128)
END
IF ((@hide & 0x0001) = 0x0001)
	DELETE FROM #SCPolicyListTbl
WHERE ((scPolicyStatus & 0x00010) = 0x00010)
IF ((@hide & 0x0002) = 0x0002)
	DELETE FROM #SCPolicyListTbl
WHERE ((scPolicyStatus & 0x00002) = 0x00002)
IF ((@hide & 0x0008) = 0x0008)
	DELETE FROM #SCPolicyListTbl
WHERE ((scPolicyStatus & 0x00020) = 0x00020)
DELETE FROM SP
FROM #SCPolicyListTbl AS SP
       INNER JOIN (
                     SELECT
                           scPolicyId,
                           MAX(scId) AS MaxId
                     FROM #SCPolicyListTbl
                     GROUP BY
                           scPolicyId
                     HAVING
                           COUNT(scPolicyId) > 1
       ) t ON
              SP.scPolicyId = t.scPolicyId
WHERE
       SP.scId <> t.MaxId
SET @o_xml = (SELECT
					(SELECT
						(SELECT scPolicyStatus AS '@status',
							(SELECT scPolicyId AS '@backupsetId',
									scPolicyName AS '@backupsetName'
							FOR XML PATH('backupSetEntity'), TYPE)
						FOR XML PATH('subClientPolicy'), TYPE)
					FROM #SCPolicyListTbl
					FOR XML PATH('subClientPolicyList'), TYPE)
			FOR XML PATH('App_GetSubclientPoliciesListResp'), TYPE)
IF OBJECT_ID ('tempdb.dbo.#SCPolicyListTbl') IS NOT NULL
	DROP TABLE #SCPolicyListTbl
IF @shouldReturnCursor = 1
	SELECT @o_xml
ELSE
	SET @i_xml = @o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientPoliciesList')
	delete from GxQscripts where name = 'AppGetSubclientPoliciesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientPoliciesList')
	delete from GXDBVersions where aliasname = 'AppGetSubclientPoliciesList'
GO

insert into GXDBVersions values(2, 'AppGetSubclientPoliciesList',  '00000000000000000000', 'AppGetSubclientPoliciesList', '00000000000000000000')
GO

