

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubclientIdOfContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSubclientIdOfContent <<<'

IF EXISTS (select * from sysobjects where name='AppGetSubclientIdOfContent')
	drop procedure AppGetSubclientIdOfContent
IF EXISTS (select * from GxQscripts where name='AppGetSubclientIdOfContent')
	delete from GxQscripts where name = 'AppGetSubclientIdOfContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientIdOfContent')
	delete from GXDBVersions where aliasname = 'AppGetSubclientIdOfContent'
GO
print '... Creating Procedure: AppGetSubclientIdOfContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubclientIdOfContent
  @inputXML XML
AS
DECLARE @content NVARCHAR(MAX) = (SELECT @inputXML.value('(/App_GetSubclientIdOfContentRequest/@path)[1]','VARCHAR(MAX)'))
DECLARE @delimiter NVARCHAR(16) = '\'
DECLARE @subPath NVARCHAR(MAX)
DECLARE @pathToMatch NVARCHAR(MAX) = 'UNC-NT_'
IF OBJECT_ID('tempdb.dbo.#SubclientIds') IS NOT NULL
    DROP TABLE #SubclientIds
CREATE TABLE #SubclientIds ( subclientId INT, clientId INT )
INSERT #SubclientIds (subclientId, clientId)
SELECT  content.componentNameId, subclient.clientId
FROM  APP_ScFilterFile content WITH(NOLOCK)
CROSS APPLY (
			SELECT _ID
			FROM dbo.SplitStringByDelimiter(@content,@delimiter)
			WHERE content.fileName like  @pathToMatch + _ID + @delimiter +'%'
			) cq
INNER JOIN APP_Application subclient ON subclient.id = content.componentNameId
WHERE content.type = 1 AND content.modified = 0
DECLARE @xmlResult XML
SET @xmlResult =
				(SELECT
					(SELECT DISTINCT subclientId AS '@subclientId',
									clientId AS '@clientId'
						FROM #SubclientIds
					FOR XML PATH('subclient'),TYPE)
				FOR XML PATH('App_GetSubclientIdOfContentResponse'))
SELECT @xmlResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubclientIdOfContent')
	delete from GxQscripts where name = 'AppGetSubclientIdOfContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubclientIdOfContent')
	delete from GXDBVersions where aliasname = 'AppGetSubclientIdOfContent'
GO

insert into GXDBVersions values(2, 'AppGetSubclientIdOfContent',  '00000000000000000000', 'AppGetSubclientIdOfContent', '00000000000000000000')
GO

