

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubClientRetentionProps.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--   [AppGetSubClientRetentionProps   - Add content in the AppGetSubClientRetentionProps.sp
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubClientRetentionProps')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubClientRetentionProps <<<'
	drop procedure AppGetSubClientRetentionProps
END
IF EXISTS (select * from GxQscripts where name='AppGetSubClientRetentionProps')
	delete from GxQscripts where name = 'AppGetSubClientRetentionProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubClientRetentionProps')
	delete from GXDBVersions where aliasname = 'AppGetSubClientRetentionProps'
GO
print '... Creating Procedure: AppGetSubClientRetentionProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubClientRetentionProps
  @inXML XML,
  @outXML XML output
AS
SET NOCOUNT OFF
--input xml attributes
DECLARE @inAppId int = @inXML.value('(/App_GetSubClientRetentionPropsReq/@appId)[1]', 'integer')
DECLARE @inAppGUID varchar(128) = @inXML.value('(/App_GetSubClientRetentionPropsReq/@appGUID)[1]', 'nvarchar(max)')
DECLARE @inIsIndexingV2 int = @inXML.value('(/App_GetSubClientRetentionPropsReq/@isIndexingV2)[1]', 'integer')
DECLARE @inCalledFromSP int = @inXML.value('(/App_GetSubClientRetentionPropsReq/@calledFromSP)[1]', 'integer')
--temp variables
DECLARE @itemDeletionDays int = -1
DECLARE @archivalDays int = -1
DECLARE @systemDeletedStubExpirationDays int = -1
DECLARE @backupRetentionMode int = 0
DECLARE @archiveRetentionMode int = 0
DECLARE @extendedStoragePolicyRetentionMode int = 0
DECLARE @numPreviousVersions int = 0
DECLARE @numDaysOfVersions int = -1
DECLARE @keepOlderVersions int = 0
DECLARE @jobStartTime int = @inXML.value('(/App_GetSubClientRetentionPropsReq/@jobStartTime)[1]', 'integer')
DECLARE @presentCSTime int = dbo.GetUnixTime(GetUTCDate())
DECLARE @maxIntVal INT = 2147483647
DECLARE @componentNameId INT = 0
DECLARE @maxIntValNumDays INT = 12427 --34 years. Since we have only signed int in sql, 68 years max reduced to 34 years.
DECLARE @associatedPolicyId INT = 0
DECLARE @useSubclientPolicyRetention INT = 0
DECLARE @lastRetentionSettingChangeTime INT = 0
DECLARE @appTypeId INT = 0
DECLARE @retainPerDayPeriod INT = 1
DECLARE @retainPerWeekPeriod INT = 1
DECLARE @retainPerMonthPeriod INT = 6
--output variables
DECLARE @itemDeletionCutOffTime int = 0 -- infinite retention by default
DECLARE @archivalCutOffTime int = 0
DECLARE @systemDeletedStubCutOffTime int = 0
DECLARE @numVersionsCutOffTime int = 0
SET @outXML = N''
--argument error check
IF (@inAppId='' or @inAppId is null)
BEGIN
	GOTO CX_EXIT
END
IF (@inIsIndexingV2='' or @inIsIndexingV2 is null or @inIsIndexingV2=0)
BEGIN
	--indexing v1 properties fetch is not supported by this SP.
	GOTO CX_EXIT
END
SET @associatedPolicyId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @inAppId AND attrName = N'Associated subclient Policy' AND modified = 0 AND cs_attrName = checksum(N'Associated subclient Policy') ), 0)
SET @useSubclientPolicyRetention = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = N'Subclient Policy Has Retention' AND modified = 0 AND cs_attrName = checksum(N'Subclient Policy Has Retention') ),0)
SET @componentNameId = @inAppId
IF @useSubclientPolicyRetention > 0
BEGIN
	--set component name Id to subclient policy ID
	SET @componentNameId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @inAppId AND attrName = 'Associated subclient Policy' AND modified = 0), 0)
END
--Get extended storage policy retention settings if set
--In case of duplicate properties, Pick latest property by ORDER BY id and select top 1.
--Pre  SP7, the property 'Is Turbo Subclient' is being used by onepass IDA to indicate whether onepass is enabled on subclient.
--post SP7, the property 'Is Turbo Subclient' is being used to indicate ESP mode for FS, onepass and sql apptypes.
SET @appTypeId	= ISNULL((Select top 1 appTypeId from App_Application WITH (NOLOCK) where id = @inAppId), 0)
SET @extendedStoragePolicyRetentionMode = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Turbo Subclient' AND modified = 0 AND cs_attrName = checksum(N'Is Turbo Subclient') ORDER BY id DESC), 0)
IF @extendedStoragePolicyRetentionMode = 1
BEGIN
IF (@appTypeId = 22 OR @appTypeId = 81)
	BEGIN
		--For sql archiving apptype, None of the retention modes are set but number of versions are set.
		--Hence set the backup retention mode to 1 to honour number of versions.
		SET @backupRetentionMode = 1
		SET @itemDeletionDays 	 = 0
	END
	ELSE
	BEGIN
SET @archiveRetentionMode = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Archive Retention Mode Enabled' AND modified = 0 AND cs_attrName = checksum(N'Is Archive Retention Mode Enabled') ORDER BY id DESC), 0)
SET @archivalDays = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'User deleted stubs expiration days' AND modified = 0 AND cs_attrName = checksum(N'User deleted stubs expiration days') ORDER BY id DESC), -1)
SET @backupRetentionMode = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Backup Retention Mode Enabled' AND modified = 0 AND cs_attrName = checksum(N'Is Backup Retention Mode Enabled') ORDER BY id DESC), 0)
SET @itemDeletionDays = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Days to keep items past their expiration' AND modified = 0 AND cs_attrName = checksum(N'Days to keep items past their expiration') ORDER BY id DESC), -1)
		--Post SP5, the property 'Archived expiration days' is not used.
SET @systemDeletedStubExpirationDays=ISNULL((select TOP 1 attrVal from APP_SubClientProp WITH (NOLOCK) where componentNameId = @componentNameId and attrName = N'Archived expiration days' and modified=0 AND cs_attrName = checksum(N'Archived expiration days') ORDER BY id DESC), -1)
	END
	--Get Nversions settings
SET @keepOlderVersions = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Keep older Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Keep older Synth Full Versions') ORDER BY id DESC), 0)
SET @numPreviousVersions = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Number of Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Number of Synth Full Versions') ORDER BY id DESC), 0)
SET @numDaysofVersions = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Number of Days of Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Number of Days of Synth Full Versions') ORDER BY id DESC), -1)
SET @retainPerDayPeriod = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Retain daily version period' AND modified = 0 AND cs_attrName = checksum(N'Retain daily version period') ORDER BY id DESC), 1)
SET @retainPerWeekPeriod = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Retain weekly version period' AND modified = 0 AND cs_attrName = checksum(N'Retain weekly version period') ORDER BY id DESC), 1)
SET @retainPerMonthPeriod = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Retain monthly version period' AND modified = 0 AND cs_attrName = checksum(N'Retain monthly version period') ORDER BY id DESC), 6)
END
ELSE
BEGIN
	--FS Block level synthetic full drops all deleted volumes by default since it doesnt have retentions setting (or) ESP ON.
	IF ((
	EXISTS ( SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = @appTypeId ) --'APPGRP_W2KFileSystem
	OR
	EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = @appTypeId) --'APPGRP_UnixFileSystem
	) AND
EXISTS (SELECT 1 FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Use block level backup' AND modified = 0 AND cs_attrName = checksum(N'Use block level backup') )
	)
	BEGIN
		SET @itemDeletionDays = 0
	END
END
--get latest retention settings changed time for retention routine
SET @lastRetentionSettingChangeTime = ISNULL((SELECT MAX(created) from APP_SubClientProp where componentNameId=@componentNameId and attrName in (
N'Is Turbo Subclient',
N'Is Archive Retention Mode Enabled',
N'User deleted stubs expiration days',
N'Is Backup Retention Mode Enabled',
N'Days to keep items past their expiration',
N'Archived expiration days',
N'Keep older Synth Full Versions',
N'Number of Synth Full Versions',
N'Number of Days of Synth Full Versions',
N'Retain daily version period',
N'Retain weekly version period',
N'Retain monthly version period'
) AND modified=0 ), 0)
--get cutoff times from numdays option
--When numDays=0, the cutoff will be set to present time (drop immediately)
--When numDays<0, the cutoff will be set to zero (infinite retention)
--When numDays>0 & numdays>34years, the cutoff will be set to zero (infinite retention)
--When numDays>0 & numdays<34years, the cutoff will be set to (jobstarttime-numdaysinsecs)
--set item deletion cutoff time
IF (@itemDeletionDays >= 0 AND @itemDeletionDays < @maxIntValNumDays)
BEGIN
	SET @itemDeletionCutOffTime = @jobStartTime - (@itemDeletionDays * 24 * 60 * 60)
END
--set archival cutoff time from archival days
IF (@archivalDays >= 0 AND @archivalDays < @maxIntValNumDays)
BEGIN
	SET @archivalCutOffTime = @jobStartTime - (@archivalDays * 24 * 60 * 60)
END
--set system deleted cutoff time
IF (@systemDeletedStubExpirationDays >= 0 AND @systemDeletedStubExpirationDays < @maxIntValNumDays)
BEGIN
	SET @systemDeletedStubCutOffTime = @jobStartTime - (@systemDeletedStubExpirationDays * 24 * 60 * 60)
END
--set older versions number (or) cutoff time
IF (@numPreviousVersions < 0)
	SET @numPreviousVersions = 0
--FS Retention GUI provides n previous Versions. So we add 1 to reflect total versions for a file.
--SynthFull Restore for SQL Archive Restore carries forward all versions
IF (@numPreviousVersions < @maxIntVal)
	SET @numPreviousVersions += 1
--set numVersions Cutoff time from num days of versions.
IF (@numDaysofVersions >= 0 AND @numDaysofVersions < @maxIntValNumDays)
BEGIN
	SET @numVersionsCutOffTime = @jobStartTime - (@numDaysofVersions * 24 * 60 * 60)
END
--set retainPerDayPeriod, retainPerWeekPeriod, retainPerMonthPeriod to 0 in case of invalid values
IF (@retainPerDayPeriod < 0)
	SET @retainPerDayPeriod = 0
IF (@retainPerWeekPeriod < 0)
	SET @retainPerWeekPeriod = 0
IF (@retainPerMonthPeriod < 0)
	SET @retainPerMonthPeriod = 0
IF ( @inCalledFromSP = 1 )
BEGIN
	--called from SP for retention routine
	SET @outXML = (SELECT @itemDeletionCutOffTime as '@itemDeletionCutOffTime', @archivalCutOffTime as '@archivalCutOffTime', @systemDeletedStubCutOffTime as '@systemDeletedStubCutOffTime',
	@archiveRetentionMode as '@archiveRetentionMode', @backupRetentionMode as '@backupRetentionMode', @extendedStoragePolicyRetentionMode as '@extendedStoragePolicyRetentionMode',
	@keepOlderVersions as '@keepOlderVersions', @numPreviousVersions as '@numVersions', @numVersionsCutOffTime as '@numVersionsCutOffTime',
	@inAppId as '@appId', @inAppGUID as '@appGUID', @lastRetentionSettingChangeTime as '@lastRetentionSettingChangeTime',
	@retainPerDayPeriod as '@retainPerDayPeriod', @retainPerWeekPeriod as '@retainPerWeekPeriod', @retainPerMonthPeriod as '@retainPerMonthPeriod'
	FOR XML PATH('subclientInfoList') , TYPE)
END
ELSE
BEGIN
	--called from cpp for synthetic full
	SET @outXML = (SELECT @itemDeletionCutOffTime as '@itemDeletionCutOffTime', @archivalCutOffTime as '@archivalCutOffTime', @systemDeletedStubCutOffTime as '@systemDeletedStubCutOffTime',
	@archiveRetentionMode as '@archiveRetentionMode', @backupRetentionMode as '@backupRetentionMode', @extendedStoragePolicyRetentionMode as '@extendedStoragePolicyRetentionMode',
	@keepOlderVersions as '@keepOlderVersions', @numPreviousVersions as '@numVersions', @numVersionsCutOffTime as '@numVersionsCutOffTime',
	@retainPerDayPeriod as '@retainPerDayPeriod', @retainPerWeekPeriod as '@retainPerWeekPeriod', @retainPerMonthPeriod as '@retainPerMonthPeriod'
	FOR XML PATH('App_GetSubClientRetentionPropsResp') , TYPE)
END
CX_EXIT:
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubClientRetentionProps')
	delete from GxQscripts where name = 'AppGetSubClientRetentionProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubClientRetentionProps')
	delete from GXDBVersions where aliasname = 'AppGetSubClientRetentionProps'
GO

insert into GXDBVersions values(2, 'AppGetSubClientRetentionProps',  '00000000000000000000', 'AppGetSubClientRetentionProps', '00000000000000000000')
GO

