

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubClientListForAdminConsole.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +------------------------------------------------------------------------------------------+
--  |           Procedure : "AppGetSubClientsetListForAdminConsole"
--  |   This Procedure is used to get a list of subclient with limited set of properties.
--  +------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSubClientListForAdminConsole')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSubClientListForAdminConsole <<<'
	drop procedure AppGetSubClientListForAdminConsole
END
IF EXISTS (select * from GxQscripts where name='AppGetSubClientListForAdminConsole')
	delete from GxQscripts where name = 'AppGetSubClientListForAdminConsole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubClientListForAdminConsole')
	delete from GXDBVersions where aliasname = 'AppGetSubClientListForAdminConsole'
GO
print '... Creating Procedure: AppGetSubClientListForAdminConsole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubClientListForAdminConsole
  @i_userId INT,
  @i_localeId INT,
  @i_xmlReq XML,
  @o_xmlResp XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @WindowsServersCount INT = 0
DECLARE @UnixServersCount INT = 0
DECLARE @NASCount INT = 0
DECLARE @FSCount INT=0
DECLARE @DBCount INT = 0
DECLARE @VMCount INT = 0
DECLARE @CloudAppsCount INT =0
DECLARE @i_includeVMClients INTEGER =
ISNULL((SELECT  ref.value('@includeVMClients', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetSubClientPropertiesRequest/adminConsoleFilter') R ( ref )),0)
DECLARE @i_includeHiddenClients INTEGER =
ISNULL((SELECT  ref.value('@hiddenclients', 'int') AS client
                              FROM    @i_xmlReq.nodes('App_GetSubClientPropertiesRequest/adminConsoleFilter') R ( ref )),0)
DECLARE @i_hideLaptopAndDummyclients INTEGER =
ISNULL((SELECT  ref.value('@hideLaptopAndDummyClients', 'int')
                              FROM    @i_xmlReq.nodes('App_GetSubClientPropertiesRequest/adminConsoleFilter/propertiesFilter') R ( ref )),0)
DECLARE @i_excludeInfrastuctureClients INTEGER =
ISNULL((SELECT  ref.value('@excludeInfrastureClients', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetSubClientPropertiesRequest/adminConsoleFilter') R ( ref )),0)
DECLARE @i_fsType INTEGER  =
ISNULL((SELECT  ref.value('@fsType', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetSubClientPropertiesRequest/adminConsoleFilter') R ( ref )),0)
IF object_id('tempdb.dbo.#i_subclientList') is not null
Drop Table #i_subclientList
CREATE TABLE #i_subclientList
(
	clientId                   INT,
	clientName                 NVARCHAR(510),
	clientDisplayName		   NVARCHAR(510),
	appTypeId                  INT,
	appTypeName                NVARCHAR(255),
	osGroup					   nVARCHAR(30),
	instanceId                 INT,
	instanceName               NVARCHAR(255),
	backupsetId                INT,
	backupSetName              NVARCHAR(510),
	subclientId					INT  ,
	subclientNAme				NVARCHAR(510),
	subclientGUID			   UNIQUEIDENTIFIER,
	subclientStatus			   INT,
	lastBackupTime             INT DEFAULT 0,
	totalBackupSize            BIGINT DEFAULT 0,
	errorCode                  INT DEFAULT 0,
	errorString                NVARCHAR(510) DEFAULT N'',
	-- Plan Association Details Start
	planId                  INT NULL,
	planType                INT NULL,
	planSubType             INT NULL,
	planName                NVARCHAR(1024) NULL,
	-- Plan  Association Details END
    enableBackup			INT NULL,
	isDefaultSubclient		INT NULL,
	subclientPolicy			INT NULL,
    primary key(subclientId),
	SLAStatus				INT DEFAULT 3, --Excluded by default. For new subclients we may not have an entry in RptSlaSubclient table.
	SLACategory INT DEFAULT 0,
	SLACategoryDescription	NVARCHAR(255) DEFAULT '',
	lastBackupJobInfo XML DEFAULT(NULL)
)
DECLARE  @subclientFlagsToFilterOUT BIGINT = CAST(0x00010 AS INT) |CAST( 0x00002 AS INT)|CAST(0x00004 AS INT)
|CAST(0x80000 AS INT) | CAST(0x1000 AS INT)|CAST(0x20000 AS INT)
IF object_id('tempdb.dbo.#getIdaObjects') is not null
DROP TABLE #getIdaObjects
CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
CREATE CLUSTERED INDEX #getIdaObject_idx ON #getIdaObjects(clientId,appTypeId,instanceId,backupsetId,subclientId)
EXEC dbo.sec_getIdaObjectsForUser  @i_userId/*user Id*/,7,0 /*Permission Id*/,1 /*Inherit from children*/,'#getIdaObjects'
INSERT INTO #i_subclientList(clientId, clientName,clientDisplayName, appTypeId, appTypeName, osGroup, instanceId, instanceName, backupsetId, backupsetName, subclientId,subclientName,subclientGuid, subclientStatus,isDefaultSubclient)
SELECT AC.Id,
AC.name,
AC.displayName,
ida.type,
ida.name,
ATG.osGroup,
instance.id,
instance.name,
backupset.id,
backupset.name,
subclient.id,
subclient.subclientName,
subclient.guid,
subclient.subclientstatus,
CASE WHEN subclient.subclientstatus&0x8<>0 THEN 1 ELSE 0 END
FROM #getIdaObjects supportedSubClients  WITH(NOLOCK)
INNER JOIN APP_application  as subclient  ON supportedSubClients.subclientId=subclient.id
INNER JOIN APP_BackupSetName AS backupset  WITH(NOLOCK) ON supportedSubClients.backupSetId = backupSet.id
AND (subclient.subclientstatus & @subclientFlagsToFilterOUT) =0
AND
(
-- Include any hidden clients if any present.
(@i_includeHiddenClients > 0)
 OR
((subclient.subclientstatus & 0x00020) <> 0x00020)  -- CV_STATUS_HIDDEN
)
INNER JOIN APP_Client AS AC  WITH(NOLOCK) on supportedSubClients.clientId = AC.id
INNER JOIN App_iDatype AS ida  WITH(NOLOCK) ON supportedSubClients.appTypeId = ida.type
INNER JOIN APP_InstanceName AS instance  WITH(NOLOCK) ON supportedSubClients.instanceId = instance.id
INNER JOIN CT_ClientProperties AS cpt  WITH(NOLOCK) on supportedSubClients.clientId = cpt.clientId
INNER JOIN simOperatingSystem AS SOS  WITH(NOLOCK) on SOS.id = AC.simOperatingSystemId
INNER JOIN App_AppTypeGroups AS ATG with (NOLOCK) on ATG.appTypeId = ida.type
AND ATG.app = 'file system'
AND
(
	((ATG.osGroup = 'windows') AND
	 (@i_fsType = 1 OR @i_fsType=3))
	OR
	((ATG.osGroup = 'unix') AND
	(@i_fsType = 2 OR @i_fsType=3))
	OR
	((ATG.osGroup = 'nas') AND
	(@i_fsType = 4 OR @i_fsType=3))
)
LEFT OUTER JOIN APP_clientPRop clientProp on AC.id=componentNameId
						and clientProp.attrNAme='Index Server Type' and clientProp.attrVal=15 and clientProp.modified=0
LEFT OUTER JOIN APP_SubClientProp subclientProp on subclient.id=subclientProp.componentNameId
						AND subclientProp.attrName in ('DDB Backup', 'Index SubClient') AND  subclientProp.modified=0
WHERE
(
	(
	/*This logic should hide or show laptop and dummy clients based on @i_hideLaptopAndDummyclients flag set*/
    (@i_excludeInfrastuctureClients = 0 OR cpt.IsInfrastructure = 0 OR cpt.IsInfrastructure is null)
    AND
    (
	/*This logic should hide or show laptop and dummy clients based on @i_hideLaptopAndDummyclients flag set*/
	@i_hideLaptopAndDummyclients = 0
    OR ((AC.specialClientFlags = 0) AND (AC.status & 0x1000 = 0))
    OR (AC.specialClientFlags & 0x20 = 0x20)
    OR (SOS.SubType= 'NAS' )
    OR (SOS.id in (49,118))
	)
    OR
    (
    (@i_includeVMClients=1)
    AND (cpt.virtualServerDiscovered=1)
    AND (cpt.lastBackupJobId <> 0)
    )
	)
	AND
	(
	 (@i_includeHiddenClients>0)
	 OR
	 (AC.specialClientFlags & 0x1 <> 0x1)
	)
	AND clientProp.componentNAmeId is NULL
	AND subclientprop.componentNameId is null
)
--Get  list of subclients on which last job ran is differential
 UPDATE tbl
set totalBackupSize = sum_totalUncomBytes
FROM  #i_subclientList TBL
JOIN ( SELECT appId ,SUM(totalUncompBytes) as sum_totalUncomBytes  FROM   JMBkpStats JM
		WHERE JM.status in  (1,3,14) and dataStatus=0
		group by JM.appId) JOB ON JOB.appId=TBL.subclientId
UPDATE subclientList
SET subclientList.lastBackupTime  = CAST(ISNULL(ABP.attrVal ,0) AS BIGINT)
FROM #i_subclientList subclientList
INNER JOIN APP_SubclientProp ABP WITH(NOLOCK)
ON ABP.componentNameId=subclientList.subclientId AND ABP.attrName = 'Last Data Protected Time' AND ABP.modified=0 AND cs_attrName = CHECKSUM(N'Last Data Protected Time')
UPDATE subclientList
SET subclientList.planId=AP.id,
subclientList.planType=AP.type,
subclientList.planSubType=AP.subType,
subclientList.planName=AP.name
FROM #i_subclientList subclientList
INNER JOIN APP_SubclientProp ABP WITH(NOLOCK)
ON ABP.componentNameId=subclientList.subclientId AND ABP.attrName = 'Associated Plan' AND ABP.modified=0 AND cs_attrName = CHECKSUM(N'Associated Plan')
    INNER JOIN App_Plan AP
ON AP.id=ABP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
-- Sets the SLA status. 1 - Met, 2 - Missed, 3 - Exclude
UPDATE T
SET T.SLAStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
	T.SLACategory = SLA.Category,
	T.SLACategoryDescription = dbo.WR_GetSLACategoryString(@i_localeId,SLA.Category)
FROM #i_subclientList T
INNER JOIN RptSLASubclient SLA ON SLA.appId = T.subclientId AND SLA.clientId = T.clientId AND SLA.fullJobsOnly = 0
UPDATE subclientList
SET subclientList.lastBackupJobInfo  = ABP.attrVal
FROM #i_subclientList subclientList
INNER JOIN APP_SubclientProp ABP WITH(NOLOCK)
ON ABP.componentNameId=subclientList.subclientId AND ABP.attrName = 'Last Backup Job Info' AND ABP.modified=0 AND cs_attrName = CHECKSUM(N'Last Backup Job Info')
UPDATE subclientList
SET enableBackup = CASE WHEN  action=1 THEN 0 ELSE 1 END,
 subclientPolicy = ISNULL(APP_SubclientProp.attrVal,0)
FROM #i_subclientList subclientList  LEFT JOIN APP_SubclientProp WITH (NOLOCK)
ON componentNameId = subclientId and  attrName = N'Associated subclient Policy' AND modified=0 AND cs_attrName = CHECKSUM(N'Associated subclient Policy' )
LEFT JOIN  JMJobAction JM  ON JM.clientId = 1 AND JM.mediaAgentID = 1 AND JM.appType = 0 AND JM.optype = 4 AND
((APP_SubclientProp.attrVal is not null and  CAST(JM.appId as varchar(40)) =APP_SubclientProp.attrVal)
OR (APP_SubclientProp.attrVal is  null and  CAST(JM.appId as varchar(40)) =subclientList.subclientId))
--------------------------------------------------------------------------------Server/FS Backupset Summary Begin ---------------------------------------------------------------------
select @FSCount = count(DISTINCT subclientId) from #i_subclientList
select @NASCount = COUNT(DISTINCT subclientId) from #i_subclientList where osGroup = 'nas'
select @WindowsServersCount = COUNT(DISTINCT subclientId) from #i_subclientList where osGroup = 'windows'
select @UnixServersCount = COUNT(DISTINCT subclientId) from #i_subclientList where osGroup = 'unix'
--------------------------------------------------------------------------------Server/FS Backupset Summary End  ----------------------------------------------------------------------
SET @o_xmlResp = ISNULL((SELECT
(SELECT
lastBackupTime as 'commonProperties/@lastBackupTime',
totalBackupSize as 'commonProperties/@totalBackupSize',
enableBackup   as 'commonProperties/@enableBackup',
isDefaultSubclient as 'commonProperties/@isDefaultSubclient',
SLAStatus as 'commonProperties/@slaStatus',
SLACategory as 'commonProperties/@slaCategory',
SLACategoryDescription as 'commonProperties/@slaCategoryDescription',
subclientPolicy as 'commonProperties/associatedPolicy/@subclientPolicyId',
7 as 'subClientEntity/@_type_',
appTypeName as 'subClientEntity/@appName',
appTypeId as 'subClientEntity/@applicationId',
subclientGuid as 'subClientEntity/@subclientGUID',
backupsetId as 'subClientEntity/@backupsetId',
backupSetName as 'subClientEntity/@backupsetName',
clientId as 'subClientEntity/@clientId',
clientName as 'subClientEntity/@clientName',
clientDisplayName as 'subClientEntity/@displayName',
instanceId as 'subClientEntity/@instanceId',
instanceName as 'subClientEntity/@instanceName',
subclientId AS 'subClientEntity/@subclientId',
subclientName AS 'subClientEntity/@subclientName',
planId as 'planEntity/@planId',
planType as 'planEntity/@planType',
planSubType as 'planEntity/@planSubType',
planName as 'planEntity/@planName',
(select CAST(lastBackupJobInfo AS XML) FOR XML PATH('commonProperties'),TYPE)
from #i_subclientList
ORDER BY
clientName, backupsetName,subclientName
for XML PATH('subClientProperties'), TYPE),
(SELECT @FScount AS '@fsCount',
@NasCount '@nasFilersCount',
@DBCount '@databasesCount',
@VMcount '@vmsCount',
@CloudAppsCount '@cloudAppsCount',
@windowsServersCount '@windowsServersCount' ,
@UnixServersCount '@unixServersCount'
FOR XML PATH('overview'), TYPE)
FOR XML PATH('App_GetSubClientPropertiesResponse')),'<App_GetSubClientPropertiesResponse/>')
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubClientListForAdminConsole')
	delete from GxQscripts where name = 'AppGetSubClientListForAdminConsole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubClientListForAdminConsole')
	delete from GXDBVersions where aliasname = 'AppGetSubClientListForAdminConsole'
GO

insert into GXDBVersions values(2, 'AppGetSubClientListForAdminConsole',  '00000000000000000000', 'AppGetSubClientListForAdminConsole', '00000000000000000000')
GO

