

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSubClientDetailsForPreview.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSubClientDetailsForPreview.sp,v $ $Id: AppGetSubClientDetailsForPreview.sp,v 1.1.2.4 2017/06/17 00:03:56 pankajkumar Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetSubClientDetailsForPreview   -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSubClientDetailsForPreview <<<'

IF EXISTS (select * from sysobjects where name='AppGetSubClientDetailsForPreview')
	drop procedure AppGetSubClientDetailsForPreview
IF EXISTS (select * from GxQscripts where name='AppGetSubClientDetailsForPreview')
	delete from GxQscripts where name = 'AppGetSubClientDetailsForPreview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubClientDetailsForPreview')
	delete from GXDBVersions where aliasname = 'AppGetSubClientDetailsForPreview'
GO
print '... Creating Procedure: AppGetSubClientDetailsForPreview'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSubClientDetailsForPreview
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_subclientId integer,
  @i_subclientGUID nvarchar(36)='',
  @i_cloudId integer=0
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
BEGIN
	DECLARE @defaultGuid nvarchar(max) = (select cast(cast(0 as binary) as uniqueidentifier) )
	if ( LEN(@i_subClientGUID) = 0 )
	BEGIN
		set @i_subClientGUID = @defaultGuid
	END
	DECLARE @appId INT
	SELECT @appId = Id FROM APP_Application A WITH(NOLOCK)
	WHERE (ISNULL(@i_subClientId, 0) <> 0 and A.id = @i_subClientId) OR  (@i_subClientGuid<> @defaultGuid AND A.GUID = CONVERT(uniqueidentifier,@i_subClientGUID))
	-- check if given cloud id is valid
	-- we check it against AppGetFastServerList
	-- we want to consider exchange index clouds ( journal and mailbox index ) also as not valid clouds for preview
	-- so not passing 1 to SP
	CREATE TABLE #servers ( serverName NVARCHAR(MAX), clientId INT, clientName NVARCHAR(MAX), cloudId INT, hostName VARCHAR(MAX), baseport INT, version VARCHAR(MAX),	engineName VARCHAR(MAX) , serverType INT)
	INSERT INTO #servers
	exec AppGetFastServerList
	IF @i_cloudId <=0 OR NOT EXISTS( SELECT cloudId from #servers where cloudId = @i_cloudId )
	BEGIN
		CREATE TABLE #cloudId ( cienabled INT,cloudId INT,  engineType nvarchar(max))
		INSERT INTO #cloudId
		exec AppGetCloudId @appId, 0
		SELECT TOP 1 @i_cloudId = cloudId FROM #cloudId
	END
	-- get details either based on subclient id or subclient guid
	--if both not specified, empty table returned
	IF ISNULL(@appId, 0) <> 0
	BEGIN
		SELECT A.id as r_subClientId, A.GUID as r_guid, A.backupSet as r_bkpSetId , A.appTypeId as r_appTypeId, A.clientId as r_clientId, A.origCCId as r_commcellId , ISNULL(B.number, 0) as r_commCellNumber , @i_cloudId as CloudId, ISNULL(C.attrVal, 0) as DataType, A.instance as r_instance
		FROM APP_Application A WITH (NOLOCK)
		LEFT JOIN APP_COMMCELL B WITH (NOLOCK) ON A.origCCId = B.Id
		LEFT JOIN APP_SubClientProp C WITH(NOLOCK) ON A.id = C.componentNameId AND attrName = 'Cloud Apps Instance Type' AND C.modified = 0
		WHERE A.id = @appId
	END
END
	IF object_id('tempdb.dbo.#servers') IS NOT NULL
		DROP TABLE #servers
	IF object_id('tempdb.dbo.#cloudId') IS NOT NULL
		DROP TABLE #cloudId
-- RETURN RESPONSE
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSubClientDetailsForPreview')
	delete from GxQscripts where name = 'AppGetSubClientDetailsForPreview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSubClientDetailsForPreview')
	delete from GXDBVersions where aliasname = 'AppGetSubClientDetailsForPreview'
GO

insert into GXDBVersions values(2, 'AppGetSubClientDetailsForPreview',  '00010001000200040000', 'AppGetSubClientDetailsForPreview', '00010001000200040000')
GO

