

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetStoragePolicyInfo.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetStoragePolicyInfo.sp,v $ $Id: AppGetStoragePolicyInfo.sp,v 1.4.12.17 2020/10/17 03:59:15 shubhamagrawal Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 08/12/2014
-- Description:
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetStoragePolicyInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetStoragePolicyInfo <<<'
	drop procedure AppGetStoragePolicyInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetStoragePolicyInfo')
	delete from GxQscripts where name = 'AppGetStoragePolicyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetStoragePolicyInfo')
	delete from GXDBVersions where aliasname = 'AppGetStoragePolicyInfo'
GO
print '... Creating Procedure: AppGetStoragePolicyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetStoragePolicyInfo
  @i_storagePolicyId INT,
  @i_primaryCopyOnly INT,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- table variable that will hold list of extended retention rules
DECLARE @extendedRetentionRules AS TABLE
(
    copyId              INT,
    retentionRule       INT,
    retentionDays       INT,
    GraceDays           INT,
    EveryXHours         INT,
    RuleNo              INT
)
INSERT INTO @extendedRetentionRules(copyId, retentionRule, retentionDays, GraceDays, EveryXHours, RuleNo)
    SELECT  copyId, retentionRule, retentionDays, GraceDays, EveryXHours, ROW_NUMBER() OVER (PARTITION BY copyId ORDER BY copyId) AS  RuleNo
    FROM  [dbo].[archAgingRuleExtended] (NOLOCK)
DECLARE @backupCopyEnabled INT = (SELECT SNP.enabled FROM ArchMaterializeSnapshotProp SNP WITH(NOLOCK) WHERE archGroupId = @i_storagePolicyId)
SET @o_xmlText = (SELECT
							@backupCopyEnabled AS '@enableBackupCopy',
                    (SELECT         id          AS '@storagePolicyId',
                                    name        AS '@storagePolicyName',
                                    17          AS '@__type__'
                        FROM        archGroup (NOLOCK)
                        WHERE       id = @i_storagePolicyId
                        FOR XML PATH('storagePolicy'), TYPE),
                    (SELECT
                             AGC.type                           AS '@copyType',
							 AGC.isSnapCopy						AS '@isSnapCopy',
               				 AGC.isMirrorCopy         AS '@isMirrorCopy',
							 (SELECT TOP 1 CASE
											WHEN LibraryTypeId <> 3 THEN 4 --'Tape'
											WHEN EXISTS(SELECT 1 FROM MMMountPath MP WHERE MP.LibraryId = MMLibrary.LibraryId AND MP.MountPathTypeId = 7) THEN 2 --cloud
											WHEN EXISTS(SELECT 1 FROM MMSDSStoragePool S WHERE S.LibraryId = MMLibrary.LibraryId) THEN 3 --hyperscale
											ELSE 1 --disk
										END
                            FROM    MMLibrary INNER JOIN MMMasterPool  ON MMLibrary.LibraryId      = MMMasterPool.LibraryId
                                              INNER JOIN MMDrivePool            ON MMDrivePool.MasterPoolId = MMMasterPool.MasterPoolId
                                              INNER JOIN MMDataPath             ON MMDataPath.DrivePoolId   = MMDrivePool.DrivePoolId
                            WHERE   MMDataPath.CopyId = AGC.id)  AS '@storageType',
                            (CASE WHEN EXISTS(SELECT 1 FROM archGroup (NOLOCK) WHERE id = @i_storagePolicyId AND defaultCopy     = AGC.id) THEN 1
                                  ELSE 0 END)                   AS '@isDefault',
                             AGC.isActive                       AS '@active',
                             AGC.copy                           AS '@copyPrecedence',
                        (SELECT     AGC.id                      AS '@copyId',
                                    AGC.name                    AS '@copyName',
                                    18                          AS '@__type__'
                            FOR XML PATH('StoragePolicyCopy'), TYPE),
                        (SELECT     MMLibrary.LibraryId         AS '@libraryId',
                                    MMLibrary.AliasName         AS '@libraryName',
                                    9                           AS '@__type__'
                            FROM    MMLibrary (NOLOCK) INNER JOIN MMMasterPool (NOLOCK) ON MMLibrary.LibraryId      = MMMasterPool.LibraryId
                                              INNER JOIN MMDrivePool           (NOLOCK) ON MMDrivePool.MasterPoolId = MMMasterPool.MasterPoolId
                                              INNER JOIN MMDataPath            (NOLOCK) ON MMDataPath.DrivePoolId   = MMDrivePool.DrivePoolId
                            WHERE   MMDataPath.CopyId = AGC.id
                            FOR XML PATH('library'), TYPE),
                        (SELECT     AG2.id                      AS '@storagePolicyId',
                                    AG2.name                    AS '@storagePolicyName',
                                    17                          AS '@__type__'
                            FROM    archGroup AG2  INNER JOIN archCopyToGlobalPolicy GP ON GP.globalPolicyId = AG2.id
WHERE	(AG2.Flags & ( 256|8388608 ) ) > 0
									AND GP.CopyId = AGC.id
                         FOR XML PATH('useGlobalPolicy'), TYPE),
                         (SELECT     AGC3.id                      AS '@copyId',
                                    AGC3.name                    AS '@copyName',
                                    18                          AS '@__type__'
                            FROM    archGroupCopy AGC3
                            WHERE   AGC3.id = AGC.sourceCopyId AND AGC3.id>0
                         FOR XML PATH('sourceCopy'), TYPE),
                        (SELECT     AG3.id                      AS '@storagePolicyId',
                                    AG3.name                    AS '@storagePolicyName',
                                    17                          AS '@__type__'
                            FROM    archGroupCopy AGC3 JOIN archGroup AG3 ON AGC3.archGroupId = AG3.id
WHERE       AGC3.id IN (SELECT destMediaCopyId FROM archGroupCopy  WHERE id = AGC.id AND (extendedFlags & 2) > 0)
AND (AGC3.extendedFlags & 1) > 0
                         FOR XML PATH('globalAuxCopy'), TYPE),
                        (SELECT     MMDrivePool.DrivePoolId     AS '@drivePoolId',
                                    MMDrivePool.DrivePoolName   AS '@drivePoolName',
                                    47                          AS '@__type__'
                            FROM    MMDrivePool (NOLOCK) INNER JOIN MMDataPath (NOLOCK) ON MMDataPath.DrivePoolId = MMDrivePool.DrivePoolId
                            WHERE   MMDataPath.CopyId = AGC.id
                            FOR XML PATH('drivePool'), TYPE),
                        (SELECT
									retentionDays               AS '@retainBackupDataForDays',
                                    fullCycles                  AS '@retainBackupDataForCycles',
                                    archiverRetDays             AS '@retainArchiverDataForDays',
                                    retentionJobs               AS '@jobs',
(SELECT CASE WHEN (flags & 128 > 0) THEN 1 ELSE 0 END AS '@jobBasedRetention'
									 FOR XML PATH ('retentionFlags'), TYPE),
                                    (SELECT     retentionRule       AS '@rule',
                                                retentionDays       AS '@endDays',
                                                GraceDays           AS '@graceDays',
                                                EveryXHours         AS '@everyXHours'
                                     FROM       @extendedRetentionRules R
                                     WHERE      R.copyId = AGC.id AND R.RuleNo = 1
                                     FOR XML PATH('extendedRetentionRuleOne'), TYPE),
                                    (SELECT     retentionRule       AS '@rule',
                                                retentionDays       AS '@endDays',
                                                GraceDays           AS '@graceDays',
                                                EveryXHours         AS '@everyXHours'
                                     FROM       @extendedRetentionRules R
                                     WHERE      R.copyId = AGC.id AND R.RuleNo = 2
                                     FOR XML PATH('extendedRetentionRuleTwo'), TYPE),
                                    (SELECT     retentionRule       AS '@rule',
                                                retentionDays       AS '@endDays',
                                                GraceDays           AS '@graceDays',
                                                EveryXHours         AS '@everyXHours'
                                     FROM       @extendedRetentionRules R
                                     WHERE      R.copyId = AGC.id AND R.RuleNo = 3
                                     FOR XML PATH('extendedRetentionRuleThree'), TYPE)
                            FROM       archAgingRule (NOLOCK)
                            WHERE      copyId = AGC.id
                            FOR XML PATH('retentionRules'), TYPE),
							(SELECT
(CASE WHEN AGC.dedupeFlags&262144 > 0 THEN (SELECT 1 FOR XML PATH ('enableDeduplication'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('enableClientSideDedup'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&8388608 > 0 THEN (SELECT 1 FOR XML PATH ('enableDASHFull'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&33554432 > 0 THEN (SELECT 1 FOR XML PATH ('pauseAndRecoverCurrentDDB'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&67108864 > 0 THEN (SELECT 1 FOR XML PATH ('automaticallyPauseAndRecoverDDB'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&134217728 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalDedupStore'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&268435456 > 0 THEN (SELECT 1 FOR XML PATH ('hostGlobalDedupStore'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&1073741824 > 0 THEN (SELECT 1 FOR XML PATH ('enableSourceSideDiskCache'), TYPE) END)
								FOR XML PATH('dedupeFlags'), TYPE),
							(SELECT
(CASE WHEN AGC.extendedFlags&1 > 0 THEN (SELECT 1 FOR XML PATH ('globalAuxCopyPolicy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&2 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalAuxCopyPolicy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&256 > 0 THEN (SELECT 1 FOR XML PATH ('arrayReplicaCopy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&2048 > 0 THEN (SELECT 1 FOR XML PATH ('overRideGACPRetention'), TYPE) END),
(CASE WHEN AGC.extendedFlags&65536 > 0 THEN (SELECT 1 FOR XML PATH ('overRideGACPEncryption'), TYPE) END),
(CASE WHEN AGC.extendedFlags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('defaultReplicaCopy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&4096 > 0 THEN (SELECT 1 FOR XML PATH ('globalStoragePolicy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&8192 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalStoragePolicy'), TYPE) END)
								FOR XML PATH('extendedFlags'), TYPE),
							(SELECT
(CASE WHEN ((SEL.type <> 8) AND (SEL.type <> 4) AND (SEL.numPeriod <> 1))
									  THEN (SELECT 16777216 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_ADVANCED 16777216
								 END),
								 --CYCLES
(CASE WHEN ((SEL.numPeriod=1) AND (SEL.type=1)) --CVA_SELECT_BY_CYCLE
										THEN (SELECT 2 FOR XML PATH('selectiveRule'), TYPE) --SELECTIVE_ALLFULL
								 END),
								 --HOURS
(CASE WHEN ((SEL.type=10) AND (SEL.numPeriod=1)) --CVA_SELECT_BY_HOURS 10 (SEL.type)
										THEN (SELECT 262144 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_HOUR = 262144
								 END),
								 --DAYS
(CASE WHEN ((SEL.type=3) AND (SEL.numPeriod=1)) --CVA_SELECT_BY_DAYS 3 (SEL.type)
										THEN (SELECT 524288 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_DAY = 524288
								 END),
								--WEEK
(CASE WHEN (SEL.numPeriod=1) AND (SEL.type = 2)			--CVA_SELECT_BY_WEEKDAY 2 (SEL.type)
										THEN (SELECT 4 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_WEEK = 4
									END),
								--MONTH
(CASE WHEN (SEL.numPeriod=1) AND (SEL.type = 4) THEN (SELECT 8 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_MONTH = 8
WHEN (SEL.numPeriod=3) AND (SEL.type = 4) THEN (SELECT 16 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_QUARTER = 16,
WHEN (SEL.numPeriod=6) AND (SEL.type = 4) THEN (SELECT 32 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_HALFYEAR = 32,
WHEN (SEL.numPeriod=12) AND (SEL.type = 4) THEN (SELECT 64 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_YEAR = 64,
WHEN (SEL.type = 4) THEN (SELECT 16777216 FOR XML PATH ('selectiveRule'), TYPE)					--SELECTIVE_ADVANCED 16777216
									END)
							FROM archSelectiveCopy SEL
							WHERE SEL.copyId= AGC.id
							FOR XML PATH ('selectiveCopyRules'),TYPE)
                        FROM        archGroupCopy AGC (NOLOCK)
                        WHERE       AGC.archGroupId = @i_storagePolicyId
AND AGC.type <> 5
                                AND ((@i_primaryCopyOnly = 0) OR (AGC.id IN (SELECT defaultCopy FROM [archGroup])))
                        FOR XML PATH('copy'), TYPE)
					FOR XML PATH('App_StoragePolicyInfoResp'),TYPE)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetStoragePolicyInfo')
	delete from GxQscripts where name = 'AppGetStoragePolicyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetStoragePolicyInfo')
	delete from GXDBVersions where aliasname = 'AppGetStoragePolicyInfo'
GO

insert into GXDBVersions values(2, 'AppGetStoragePolicyInfo',  '00010004001200170000', 'AppGetStoragePolicyInfo', '00010004001200170000')
GO

