

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlJobList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSqlJobList.sp,v $ $Id: AppGetSqlJobList.sp,v 1.1.6.4 2018/03/27 08:47:58 jiechen Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "rptGetBackupVMs"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSqlJobList <<<'

IF EXISTS (select * from sysobjects where name='AppGetSqlJobList')
	drop procedure AppGetSqlJobList
IF EXISTS (select * from GxQscripts where name='AppGetSqlJobList')
	delete from GxQscripts where name = 'AppGetSqlJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlJobList')
	delete from GXDBVersions where aliasname = 'AppGetSqlJobList'
GO
print '... Creating Procedure: AppGetSqlJobList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlJobList
  @i_userId int,
  @i_clientId int,
  @i_instanceId int,
  @i_databaseName nvarchar(max) = N''
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @clientName nvarchar(max) = ''
declare @instanceName nvarchar(max) = ''
DECLARE @o_xmlText XML
DECLARE @userHasCapability int = 0
if @i_databaseName is null
begin
	set @i_databaseName=''
end
-- first check whether user has permission on instance
declare @appTypeId int = 0
select @appTypeId = appTypeId from app_application where clientId=@i_clientId and instance=@i_instanceId
EXECUTE sec_checkPermissionOnEntity @i_userId, 13, @userHasCapability OUTPUT, 3,@i_clientId, 4,@appTypeId, 5,@i_instanceId
if @userHasCapability=0
begin
	-- throw error below and return
	select @o_xmlText = (
		select 1 '@errorCode',
		'Access denied. User has no browse capabilities on instance' '@errorString'
		for xml path('errorResp'),root('Api_SqlJobInfo'))
	SELECT @o_xmlText o_xmlString
	return
end
select @clientName = name from App_client where id = @i_clientId
select @instanceName = name from App_instancename where id=@i_instanceId
IF object_id('tempdb.dbo.#SQLJobsFinal') is not null DROP TABLE #SQLJobsFinal
CREATE TABLE #SQLJobsFinal
(
	jobid int,
	backup_set_id int,
	DatabaseName NVarchar(max),
	typeV CHAR(1),
	backup_size bigint,
	backup_start_date int,
	backup_finish_date int,
	backupmethod varchar(16)
)
Insert into #SQLJobsFinal
exec QS_GetSqlJobList @clientName, @instanceName, 0,0,@i_databaseName, 0,0,0
delete SQLJobsFinal
from #SQLJobsFinal SQLJobsFinal,
(
	select min(backup_finish_date) as backup_finish_date from #SQLJobsFinal
) T
where T.backup_finish_date <> SQLJobsFinal.backup_finish_date
select @o_xmlText = (select top 1 jobid '@jobid',
	DatabaseName '@DatabaseName',
	typeV '@type',
	backup_size '@backup_size',
	backup_start_date '@backupStartDate',
	backup_finish_date '@backupFinishDate',
	backupmethod '@backupMethod',
	backup_set_id as 'backupset/@backupsetId'
	from #SQLJobsFinal
for xml path('Api_SqlJobInfo'))
IF @o_xmlText is NULL
    SET @o_xmlText = '<Api_SqlJobInfo/>'
SELECT @o_xmlText o_xmlString
IF object_id('tempdb.dbo.#SQLJobsFinal') is not null DROP TABLE #SQLJobsFinal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlJobList')
	delete from GxQscripts where name = 'AppGetSqlJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlJobList')
	delete from GXDBVersions where aliasname = 'AppGetSqlJobList'
GO

insert into GXDBVersions values(2, 'AppGetSqlJobList',  '00010001000600040000', 'AppGetSqlJobList', '00010001000600040000')
GO

