

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlInstances.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSqlInstances.sp,v $ $Id: AppGetSqlInstances.sp,v 1.10.2.25 2020/08/19 17:21:11 ankumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSqlInstances')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSqlInstances <<<'
	drop procedure AppGetSqlInstances
END
IF EXISTS (select * from GxQscripts where name='AppGetSqlInstances')
	delete from GxQscripts where name = 'AppGetSqlInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlInstances')
	delete from GXDBVersions where aliasname = 'AppGetSqlInstances'
GO
print '... Creating Procedure: AppGetSqlInstances'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlInstances
  @userId integer,
  @clientId integer = 0,
  @cap bigint = -1,
  @serverType varchar(128),
  @restoreType integer = 0
AS
DECLARE @isAllAssociationsSet int
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @isAllAssociationsSet = 0
IF @cap = -1
SET @cap = (power(2, 13-1) | power(2, 20-1) | power(2, 22-1))
IF object_id('tempdb.dbo.#AppGetSqlInstances_UserObjects') is not null DROP TABLE #AppGetSqlInstances_UserObjects
create table  #AppGetSqlInstances_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2013, 0, '#AppGetSqlInstances_UserObjects'
Delete from #AppGetSqlInstances_UserObjects
WHERE 	(capabilities & @cap) = 0
if exists(
	select 1 from #AppGetSqlInstances_UserObjects sec
where (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
)
begin
	set @isAllAssociationsSet = 1
end
IF OBJECT_ID('tempdb.dbo.#AllInstTable') IS NOT NULL
	DROP TABLE #AllInstTable
CREATE TABLE #AllInstTable  (
	clientId int,
	id int,
	name nvarchar(512),
	MSSqlVersion nvarchar(128),
	serverType nvarchar(128),
	osType	varchar(128),
	clientName varchar(128)
)
IF @restoreType <> 2
BEGIN
	INSERT INTO #AllInstTable
		SELECT DISTINCT A.clientid, I.id, I.NAME, IP.attrval,
				CASE WHEN ISNULL(Px.attrval, N'') = N'' THEN 'DataBase Engine' ELSE Px.attrval END,
				SO.type, C.NAME
		FROM   app_application A
			   INNER JOIN app_instancename I ON A.instance = I.id  AND A.apptypeid = 81
			   INNER JOIN app_instanceprop IP ON I.id = IP.componentnameid
					AND IP.attrname = 'MSSQL Version' AND ( ( I.status & 16 ) != 16 )
					AND (( I.status & 4 ) != 4 )
			   LEFT OUTER JOIN app_instanceprop Px ON Px.componentnameid = IP.componentnameid
					AND Px.attrname = 'MSSQL Server Type'
			   INNER JOIN APP_CLIENT C ON A.clientid = C.id
					AND (( C.status & 4 /*DELETED*/) != 4)
					AND ((( I.status & 2 /*UNINSTALLED*/) != 2)
							OR (EXISTS(SELECT clientId, simPackageID
										FROM siminstalledpackages
										WHERE  clientid = A.clientid
											AND (simpackageid = 353 /* N_WIN_PACKAGE_MSSQL */ OR simPackageID = 1212 /* N_UNIX_PACKAGE_SQLSERVER */)))
							OR (EXISTS(SELECT clientId, simPackageID
										FROM siminstalledpackages
										WHERE clientid IN (SELECT PMClientId
															FROM APP_VMToPMMap avp where avp.VMClientId = C.id)
											AND (simpackageid = 353 /* N_WIN_PACKAGE_MSSQL */ OR simPackageID = 1212 /* N_UNIX_PACKAGE_SQLSERVER */)))
						)
			   INNER JOIN simoperatingsystem SO ON C.simoperatingsystemid = SO.id
		WHERE  (A.clientid = @clientId OR @clientId = 0)
					AND ((@isAllAssociationsSet = 1)
						OR EXISTS (SELECT 1 FROM   #appgetsqlinstances_userobjects sec
							 WHERE  sec.clientid = A.clientid  AND ( sec.apptypeid = 0 OR sec.apptypeid = A.apptypeid )
									AND (sec.instanceid = 0 OR sec.instanceid = A.instance)))
			   AND ((@restoreType = 0  AND A.clientid NOT IN (SELECT id FROM APP_CLIENT
										WHERE  status & 0x20000000 /*CV_STATUS_MSSQLAG*/ = 0x20000000))
						OR (@restoreType = 1 /*RECOVERY_POINT*/
							-- client needs to have 353 installed
							AND A.clientid IN (SELECT clientid FROM   siminstalledpackages WHERE simpackageid = 353)
							-- client needs to have MA installed
							AND A.clientid IN (SELECT clientid FROM   siminstalledpackages WHERE simpackageid = 51 /*N_WIN_PACKAGE_MEDIAAGENT*/)
							-- filter out Cloud instances
							AND I.id NOT IN (SELECT DISTINCT componentnameid FROM   app_instanceprop
												WHERE  attrname = 'MSSQL Server Type' AND attrval IN ( 'Azure DataBase Engine', 'Azure Managed DataBase Engine', 'Aws DataBase Engine' )))
						OR ((@restoreType = 3 /*ANALYSIS_SERVICE*/)
								AND I.id IN (SELECT DISTINCT componentnameid FROM   app_instanceprop
													WHERE  attrname = 'MSSQL Server Type' AND attrval like 'Analysis Services'))
						OR ((@restoreType = 4 /*WINDOWS_CLIENTS*/ OR @restoreType = 7 /*CLOUD_APPS_WINDOWS*/)
									AND (SO.id = 210 /* WINDOWS */))
						OR ((@restoreType = 5 /* MSSQL_AG */ )AND A.clientid IN (SELECT id FROM   APP_CLIENT
										WHERE  status & 0x20000000 /*CV_STATUS_MSSQLAG*/ = 0x20000000))
						OR ((@restoreType = 6 /*CLOUD_APPS*/ OR @restoreType = 7 /*CLOUD_APPS_WINDOWS*/)
								-- filter out Cloud instances
								AND I.id IN (SELECT DISTINCT componentnameid FROM   APP_InstanceProp
												WHERE  attrname = 'MSSQL Server Type'
													AND ((@restoreType IN (6,7)
															AND attrval IN ( 'Azure DataBase Engine', 'Azure Managed DataBase Engine', 'Aws DataBase Engine' ))))
							)
					)
END
ELSE IF @restoreType = 2
BEGIN
	INSERT INTO #AllInstTable
		SELECT DISTINCT AC.id AS ClientId, 0 AS InstanceID, N'' AS InstanceName,
			N'' as Version, N'' as engType, SO.Type as OsType, AC.name AS CLientName
		FROM APP_Client AC
			JOIN APP_ClientProp ACP ON ACP.componentNameId = AC.id
				AND ((ACP.attrName = 'Virtual Client' AND ACP.attrVal = '1')
					OR EXISTS(SELECT 1 FROM   siminstalledpackages AS SIM WITH (NOLOCK)
                                WHERE  clientid = AC.id AND
                                (AC.id = SIM.clientid and (SIM.simPackageID= 353 OR SIM.simPackageID = 1212) /*N_WIN_PACKAGE_MSSQL*/)))
			JOIN simOperatingSystem SO ON AC.simoperatingsystemid = SO.id
		WHERE ((@isAllAssociationsSet = 1)
						OR EXISTS (SELECT 1 FROM   #appgetsqlinstances_userobjects sec
							 WHERE  sec.clientid = AC.id  AND (sec.apptypeid = 0 OR sec.apptypeid = 81 )))
END
IF ((@serverType = '') OR (@serverType is NULL) OR (@serverType = 'DATABASE ENGINE'))
BEGIN
	SELECT clientId, id, name, MSSqlVersion as 'SQL Version', serverType, osType, clientName
	FROM #AllInstTable
	WHERE (serverType = '') OR (serverType is NULL) OR (serverType = 'DATABASE ENGINE')
		OR (serverType = 'AZURE DATABASE ENGINE') OR (serverType = 'AZURE MANAGED DATABASE ENGINE') OR (serverType = 'AWS DATABASE ENGINE')
END
ELSE IF (@serverType = 'AZURE DATABASE ENGINE')
BEGIN
	SELECT clientId, id, name, MSSqlVersion as 'SQL Version', serverType, osType, clientName
	FROM #AllInstTable
	WHERE (serverType = 'AZURE DATABASE ENGINE') OR (serverType = 'DATABASE ENGINE')
		OR (serverType = 'AWS DATABASE ENGINE')
END
ELSE IF (@serverType = 'AZURE MANAGED DATABASE ENGINE')
BEGIN
	SELECT clientId, id, name, MSSqlVersion as 'SQL Version', serverType, osType, clientName
	FROM #AllInstTable
	WHERE (serverType = 'AZURE MANAGED DATABASE ENGINE')
END
ELSE IF (@serverType = 'AWS DATABASE ENGINE')
BEGIN
	SELECT clientId, id, name, MSSqlVersion as 'SQL Version', serverType, osType, clientName
	FROM #AllInstTable
	WHERE (serverType = 'DATABASE ENGINE') OR (serverType = 'AWS DATABASE ENGINE')
		OR (serverType = 'AZURE DATABASE ENGINE')
END
ELSE
BEGIN
	SELECT clientId, id, name, MSSqlVersion as 'SQL Version', serverType, osType, clientName FROM #AllInstTable
		WHERE serverType = 'Analysis Services'
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlInstances')
	delete from GxQscripts where name = 'AppGetSqlInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlInstances')
	delete from GXDBVersions where aliasname = 'AppGetSqlInstances'
GO

insert into GXDBVersions values(2, 'AppGetSqlInstances',  '00010010000200250000', 'AppGetSqlInstances', '00010010000200250000')
GO

