

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlDbBrowseData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSqlDbBrowseData')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSqlDbBrowseData <<<'
	drop procedure AppGetSqlDbBrowseData
END
IF EXISTS (select * from GxQscripts where name='AppGetSqlDbBrowseData')
	delete from GxQscripts where name = 'AppGetSqlDbBrowseData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlDbBrowseData')
	delete from GXDBVersions where aliasname = 'AppGetSqlDbBrowseData'
GO
print '... Creating Procedure: AppGetSqlDbBrowseData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlDbBrowseData
  @XmlInputOutput XML OUTPUT
AS
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @UserId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/user/@userId)[1]','INT')), 0)
	DECLARE @InstanceId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@instanceID)[1]','INT')), 0)
	DECLARE @ToTime INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@toTime)[1]','INT')), 0)
	DECLARE @restoreType INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@restoreType)[1]','INT')), 0)
	DECLARE @JobId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@jobId)[1]','INT')), 0)
	DECLARE @browseDatabases INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@browseDatabases)[1]','INT')), 0)
	DECLARE @requestTime INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@requestTime)[1]','INT')), 0)
	DECLARE @copyPrecedence INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@copyPrecedence)[1]','INT')), 0)
	DECLARE @logShippingOnly INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@logShippingOnly)[1]','INT')), 0)
	DECLARE @includeAgeData INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@includeAgeData)[1]','INT')), 0)
	DECLARE @commCellId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@commCellId)[1]','INT')), 0)
	DECLARE @includeDeviceInfo INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@includeDeviceInfo)[1]','INT')), 0)
	DECLARE @includeChainInfo INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@includeChainInfo)[1]','INT')), 0)
	DECLARE @includeLogMarkInfo INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@includeLogMarkInfo)[1]','INT')), 0)
	DECLARE @excludeBeforeTime INT = ISNULL((SELECT @XmlInputOutput.value('(/App_SqlGetbrowseDataReq/@excludeBeforeTime)[1]','INT')), 0)
	DECLARE @ClientId INT = 0
	DECLARE @HasRights INT = 1
	DECLARE @errorCode INT = 0
	DECLARE @errorMessage NVARCHAR(1024) = N''
	SELECT TOP 1 @ClientId = clientId FROM APP_APPLICATION WITH (NOLOCK) WHERE instance = @InstanceId
	IF OBJECT_ID('tempdb.dbo.#All_Database_Chain') IS NOT NULL
		DROP TABLE dbo.#All_Database_Chain
	CREATE TABLE #All_Database_Chain(backupsetId INTEGER, majorVersion INT, minorVersion INT, backupType  CHAR, backupFinishTime INTEGER,
					appId INT, instance INT, sqlNameId INT, isCopy INT, backupMethod INT, firstLsn NUMERIC(25, 0), lastLsn NUMERIC(25, 0),
					checkpointLsn NUMERIC(25, 0), fullbackupLsn NUMERIC(25, 0))
	IF OBJECT_ID('tempdb.dbo.#SqlDatabaseFiles') IS NOT NULL
		DROP TABLE dbo.#SqlDatabaseFiles
	CREATE TABLE #SqlDatabaseFiles (sqlNameId INTEGER, fileGroupName NVARCHAR(1024), filePhysicalPath NVARCHAR(1024),
			logicalName NVARCHAR(1024), fileType INT, fileNumber INT, sqlBackupInfo INT, pageSize INT)
	-- CHECK IF USER HAS PERMISSION.
	-- USER PERMISSION CHECK CODE STARTS
	IF OBJECT_ID('tempdb.dbo.#SqlBrowsePermission') IS NOT NULL
		DROP TABLE #SqlBrowsePermission
	CREATE TABLE #SqlBrowsePermission (PermissionId INT)
EXEC sec_getPermissionsOnEntity '#SqlBrowsePermission', @UserId, 3, @ClientId
IF NOT EXISTS (SELECT PermissionId FROM #SqlBrowsePermission WHERE PermissionId = 13)
	BEGIN
		SET @HasRights = 0
	END
	IF @HasRights = 0
	BEGIN
		SET @errorCode = 100
		SET @errorMessage = N'User does not have browse permissions.'
		GOTO END_APPGETSQLBROWSEDATA
	END
	IF @ToTime = 0
	BEGIN
		SET @ToTime = dbo.GETUNIXTIME(GETDATE())
	END
	IF OBJECT_ID('tempdb.dbo.#SqlBrowseDatabases') IS NOT NULL
		DROP TABLE DBO.#SqlBrowseDatabases
	CREATE TABLE #SqlBrowseDatabases (databaseName NVARCHAR(1024), databaseId INT, sqlVersion NVARCHAR(256), sqlNameId INT, backupFinishDate INT)
	DECLARE @databaseCountInReq INT = 0
	SELECT @databaseCountInReq = @XmlInputOutput.value('count(/App_SqlGetbrowseDataReq/database)', 'INT')
	If @databaseCountInReq = 0
	BEGIN
		EXEC dbo.[AppGetSqlBrowseDatabases] @ToTime, @InstanceId, @restoreType, 0, @copyPrecedence, @includeAgeData, @excludeBeforeTime, @JobId, @commCellId, 0, N'#SqlBrowseDatabases', NULL, 1
	END
	ELSE
	BEGIN
	 -- INSERT INTO table.
		INSERT INTO #SqlBrowseDatabases
			SELECT	ISNULL(Tbl.Col.value('@databaseName', N'NVARCHAR(1024)'), N''),
					ISNULL(Tbl.Col.value('@databaseId', N'INT'), 0),
					ISNULL(Tbl.Col.value('@sqlVersion', N'NVARCHAR(256)'), N''),
					ISNULL(Tbl.Col.value('@sqlNameId', N'INT'), 0),
					ISNULL(Tbl.Col.value('@backupFinishDate', N'INT'), 0)
		FROM @XmlInputOutput.nodes('/App_SqlGetbrowseDataReq/database') as Tbl(Col)
	END
	-- IF INCLUDE CHAIN DETAILS SET, ADD CHAIN FOR EACH DB.
	IF @includeDeviceInfo = 1 OR @includeChainInfo = 1
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#single_Database_Chain') IS NOT NULL
		DROP TABLE dbo.#single_Database_Chain
		CREATE TABLE #single_Database_Chain(backupsetId INTEGER, majorVersion INT, minorVersion INT, backupType  CHAR, backupFinishTime INTEGER,
						appId INT, instance INT, sqlNameId INT, isCopy INT, backupMethod INT, firstLsn NUMERIC(25, 0), lastLsn NUMERIC(25, 0),
						checkpointLsn NUMERIC(25, 0), fullbackupLsn NUMERIC(25, 0))
		DECLARE @SqlNameIdVal INT = 0
		DECLARE @SqlDatabaseName NVARCHAR(1024) = N''
		DECLARE CUR_SQL_CHAIN_ITER CURSOR FOR SELECT sqlNameId, databaseName FROM #SqlBrowseDatabases
		OPEN CUR_SQL_CHAIN_ITER
		FETCH CUR_SQL_CHAIN_ITER INTO @SqlNameIdVal, @SqlDatabaseName
		WHILE @@FETCH_STATUS = 0
		BEGIN
				TRUNCATE TABLE #single_Database_Chain
				EXECUTE SqlGetDbChain_V2 @InstanceId, @SqlDatabaseName, @restoreType, @ToTime, @requestTime, @copyPrecedence, @logShippingOnly, @includeAgeData, N'#single_Database_Chain'
				INSERT INTO #All_Database_Chain SELECT * FROM #single_Database_Chain
				-- IF INCLUDE DEVICEINFO SET : ADD DEVICES INFO
				DECLARE @sqlLatestBackupSet INT = 0
				SELECT @sqlLatestBackupSet = MAX(backupSetid) FROM #single_Database_Chain GROUP BY sqlNameId
				INSERT INTO #SqlDatabaseFiles
					SELECT @SqlNameIdVal AS sqlnameId, PIV.[2] AS fileGroupName, PIV.[3] AS filePhysicalPath, PIV.[4] AS logicalName,
						PIV.TYPE AS fileType, PIV.NUMBER AS fileNumber, PIV.SQLDBBACKUPINFOID AS sqlBackupInfo, PIV.PAGESIZE AS pageSize
						FROM (SELECT SN2.NAME, SFB.TYPE, SFB.NUMBER, SN.TYPE AS NAMETYPE, SFB.PAGESIZE, SFB.SQLDBBACKUPINFOID FROM
								SQLFILEBACKUPINFO SFB INNER JOIN SQLNAMES SN
									ON SN.ID = SFB.SQLNAMEFGID OR SN.ID = SFB.SQLNAMELOGID OR SN.ID = SFB.SQLNAMEPHYID
								INNER JOIN SQLNAMES2 SN2 ON SN.SQLID = SN2.ID
								WHERE SQLDBBACKUPINFOID = @sqlLatestBackupSet) AS SRC
						PIVOT( MAX([NAME]) FOR NAMETYPE IN ([2], [4], [3])) PIV
				FETCH CUR_SQL_CHAIN_ITER INTO @SqlNameIdVal, @SqlDatabaseName
		END
		CLOSE CUR_SQL_CHAIN_ITER
		DEALLOCATE CUR_SQL_CHAIN_ITER
	END
	END_APPGETSQLBROWSEDATA:
	IF @errorCode = 0
	BEGIN
		SET @XmlInputOutput = ISNULL((SELECT	databases.*,
										(SELECT * FROM #All_Database_Chain dbChain WHERE dbChain.sqlNameId = databases.sqlNameId FOR XML AUTO, TYPE),
										(SELECT * FROM #SqlDatabaseFiles dbFile WHERE dbFile.sqlNameId = databases.sqlNameId FOR XML AUTO, TYPE),
										(SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH('response'), type)
									FROM #SqlBrowseDatabases databases FOR XML AUTO, ROOT(N'App_SqlGetbrowseDataRsp')), N'<App_SqlGetbrowseDataRsp />')
	END
	ELSE
	BEGIN
		SET @XmlInputOutput = ISNULL((SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage'
								FOR XML PATH('response'), root('App_SqlGetbrowseDataRsp'), type), N'<App_SqlGetbrowseDataRsp />')
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @XmlInputOutput = ISNULL((SELECT @@ERROR AS '@errorCode', 'Failed to get browse data.' AS '@errorMessage'
							FOR XML PATH('response'), root('App_SqlGetbrowseDataRsp'), type), N'<App_SqlGetbrowseDataRsp />')
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlDbBrowseData')
	delete from GxQscripts where name = 'AppGetSqlDbBrowseData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlDbBrowseData')
	delete from GXDBVersions where aliasname = 'AppGetSqlDbBrowseData'
GO

insert into GXDBVersions values(2, 'AppGetSqlDbBrowseData',  '00000000000000000000', 'AppGetSqlDbBrowseData', '00000000000000000000')
GO

