

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlClientInstances.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSqlClientInstances')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSqlClientInstances <<<'
	drop procedure AppGetSqlClientInstances
END
IF EXISTS (select * from GxQscripts where name='AppGetSqlClientInstances')
	delete from GxQscripts where name = 'AppGetSqlClientInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlClientInstances')
	delete from GXDBVersions where aliasname = 'AppGetSqlClientInstances'
GO
print '... Creating Procedure: AppGetSqlClientInstances'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlClientInstances
  @XmlInputOutput XML OUTPUT
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @userId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLClientInstanceReq/processinginstructioninfo/user/@userId)[1]','INT')), 0)
	DECLARE @includeRestoreOnlyClients INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLClientInstanceReq/@includeRestoreOnlyClients)[1]','INT')), 0)
	DECLARE @includeAgClients INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLClientInstanceReq/@includeAgClients)[1]','INT')), 0)
	DECLARE @clientId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLClientInstanceReq/@clientId)[1]','INT')), 0)
	DECLARE @instanceId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLClientInstanceReq/@instanceid)[1]','INT')), 0)
	IF OBJECT_ID('tempdb.dbo.#ClientDetails') IS NOT NULL DROP TABLE #ClientDetails
	CREATE TABLE #ClientDetails (ClientId INT PRIMARY KEY, OsId INT, HostName NVARCHAR(256), JobResults NVARCHAR(512), status INT,
			Flags INT, ClientName NVARCHAR(256),  VirtualClient INT, SPVersion NVARCHAR(256), IndexingV2Client INT,
			Timezone NVARCHAR(256), IndexingV2Sql INT, TimezoneName NVARCHAR(256), ClientType INT, OSName NVARCHAR(256), OsType NVARCHAR(256))
	IF OBJECT_ID('tempdb.dbo.#InstanceDetails') IS NOT NULL
		DROP TABLE #InstanceDetails
	CREATE TABLE #InstanceDetails (InstanceId INT, ClientId INT PRIMARY KEY(InstanceId, ClientId), InstanceName NVARCHAR(256), Status INT,
					ServerType NVARCHAR(256), ServerVersion NVARCHAR(256))
	IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
		DROP TABLE #ClientInstanceDetails
	CREATE TABLE #ClientInstanceDetails (ClientId INT, InstanceId INT PRIMARY KEY(InstanceId, ClientId))
	-- Get all client and instance IDs from subclient.
	INSERT INTO #ClientInstanceDetails
		SELECT DISTINCT clientId, instance FROM APP_Application WHERE appTypeId = 81
			AND ((clientId = @clientId OR @clientId = 0) AND (@instanceId = 0 OR instance = @instanceId))
	-- User Permission Check Code Starts
	IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL
		DROP TABLE #tt_getAllIdaObjects
	CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	-- Get all IDA objects on which current USER have permissions.
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
	-- Based on operation, remove those clients for which current user does not have any permissions.
	DELETE FROM #ClientInstanceDetails where ClientId not in (select clientID from #tt_getAllIdaObjects)
	-- Validate clients available
	IF NOT EXISTS(SELECT 1 FROM #ClientInstanceDetails)
		RAISERROR('No clients found for given user.', 16, -1)
	IF OBJECT_ID('tempdb.dbo.#tt_ReplicasPerAG') IS NOT NULL
			DROP TABLE #tt_ReplicasPerAG
	CREATE TABLE #tt_ReplicasPerAG (instanceId INT, replicaId INT, primary key(instanceId, replicaId), endpointUrl NVARCHAR(1024), role int, instanceName NVARCHAR(512))
	-- Update Replica details for AG instances.
	IF(EXISTS(SELECT 1 FROM #ClientInstanceDetails CD JOIN APP_Client ac ON ac.id = CD.ClientId
			WHERE ((ac.status & 0x20000000 /* CV_STATUS_MSSQLAG */) = 0x20000000)))
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tt_Replicas') IS NOT NULL
			DROP TABLE #tt_Replicas
		CREATE TABLE #tt_Replicas (instanceId INT, availableReplicas XML)
		INSERT #tt_Replicas
			SELECT DISTINCT instance.componentNameId, instance.attrVal
			FROM APP_Application subclient WITH(NOLOCK)
				INNER JOIN APP_InstanceProp instance WITH(NOLOCK) ON instance.componentNameId = subclient.instance
			WHERE subclient.appTypeId = 81 /*CV_APPTYPE_MSSQL*/
				AND instance.attrName = N'Availability Replicas' and instance.modified = 0
		-- Store AG instance.
		INSERT INTO #tt_ReplicasPerAG
			SELECT DISTINCT S.instanceId, REP.C.value('(replicaClient/@clientId)[1]', 'INT') AS ReplicaId,
				ISNULL(REP.C.value('@endpointURL', 'nvarchar(1024)'), N'') as endpointURL,
				REP.C.value('@role', 'INT') AS role,
				ISNULL(REP.C.value('@name', 'nvarchar(1024)'), N'') as instance
			FROM #tt_Replicas AS S
				CROSS  APPLY S.availableReplicas.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList') as REP(C)
		IF @instanceId <> 0
			INSERT INTO #ClientInstanceDetails
				SELECT DISTINCT replicaId, 0 FROM #tt_ReplicasPerAG RP WHERE @instanceId = RP.instanceId
					AND RP.replicaId not in (SELECT DISTINCT ClientId FROM #ClientInstanceDetails)
		IF @clientId <> 0
			INSERT INTO #ClientInstanceDetails
				SELECT DISTINCT replicaId, 0 FROM #tt_ReplicasPerAG RP JOIN #ClientInstanceDetails CID
					ON RP.instanceId = CID.InstanceId
					WHERE RP.replicaId not in (SELECT DISTINCT ClientId FROM #ClientInstanceDetails)
	END
	IF OBJECT_ID('tempdb.dbo.#tt_ProxyServers') IS NOT NULL DROP TABLE #tt_ProxyServers
	CREATE TABLE #tt_ProxyServers (instanceId INT, proxyId INT primary key(instanceId, proxyId))
	IF OBJECT_ID('tempdb.dbo.#tt_ProxiesPerCloudInstance') IS NOT NULL DROP TABLE #tt_ProxiesPerCloudInstance
	CREATE TABLE #tt_ProxiesPerCloudInstance(instance INT, proxy INT, PRIMARY KEY(instance, proxy))
	-- Update Proxy details for cloud instances.
	IF(EXISTS(SELECT 1 FROM #ClientInstanceDetails CD JOIN APP_Client ac ON ac.id = CD.ClientId
			WHERE (AC.specialClientFlags & 2) = 2))
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tt_Proxies') IS NOT NULL
			DROP TABLE #tt_Proxies
		CREATE TABLE #tt_Proxies (instanceId INT, proxies XML)
		INSERT #tt_Proxies
		SELECT AP.instance, ID.attrVal
			FROM APP_IDAProp ID
				JOIN APP_IDAName INA
					ON INA.id = ID.componentNameId AND INA.appTypeId = 81
						AND ID.attrName = N'Cloud Proxy Servers'
						AND ID.modified = 0
				JOIN APP_Application AP
					ON AP.clientId = INA.clientId
				JOIN #ClientInstanceDetails CD
					ON CD.InstanceId = AP.instance AND AP.appTypeId = 81
		-- Store AG instance.
		INSERT INTO #tt_ProxiesPerCloudInstance
			SELECT DISTINCT S.instanceId, REP.C.value('(client/@clientId)[1]', 'INT') AS proxy
			FROM #tt_Proxies AS S
				CROSS  APPLY S.proxies.nodes('App_MemberServers/memberServers') as REP(C)
		IF @instanceId <> 0
			INSERT INTO #ClientInstanceDetails
				SELECT DISTINCT proxy, 0 FROM #tt_ProxiesPerCloudInstance RP WHERE @instanceId = RP.instance
					AND RP.proxy NOT IN (SELECT ClientId FROM #ClientInstanceDetails)
		IF @clientId <> 0
			INSERT INTO #ClientInstanceDetails
				SELECT DISTINCT proxy, 0 FROM #tt_ProxiesPerCloudInstance RP JOIN #ClientInstanceDetails CID
					ON RP.instance = CID.InstanceId
					WHERE RP.proxy NOT IN (SELECT ClientId FROM #ClientInstanceDetails)
	END
	/** Client **/
	IF OBJECT_ID('tempdb..#TEMP_APP_CLIENT_PROP') IS NOT NULL
		DROP TABLE #TEMP_APP_CLIENT_PROP
	CREATE TABLE #TEMP_APP_CLIENT_PROP(
		componentNameId INT,
		VirtualClient NVARCHAR(1024),
		SpVersion NVARCHAR(1024),
		IndexingV2 NVARCHAR(1024),
		TzoneId NVARCHAR(1024),
		IndexingV2SQL NVARCHAR(1024))
	CREATE NONCLUSTERED INDEX IDX_Temp_Client_Props
		ON #TEMP_APP_CLIENT_PROP(componentNameId, SpVersion, IndexingV2, TzoneId, IndexingV2SQL)
	INSERT INTO #TEMP_APP_CLIENT_PROP
		SELECT  pvt.componentNameId,
			pvt.[Virtual Client] AS VirtualClient,
			ISNULL(pvt.[SP Version Info], N'') AS SpVersion,
			ISNULL(pvt.[IndexingV2], 0) AS IndexingV2,
			ISNULL(pvt.[timezone Id], 0) AS TzoneId,
			ISNULL(pvt.[IndexingV2_MSSqlServer], 0) AS IndexingV2SQL
		FROM
		(
			SELECT
				componentNameId,
				attrName,
				attrVal
			FROM APP_ClientProp ACP
				JOIN #ClientInstanceDetails CI
					ON CI.clientId  = ACP.componentNameId
						AND ACP.modified = 0
						AND ACP.attrName IN
							(
								N'Virtual Client',
								N'SP Version Info',
								N'IndexingV2',
								N'timezone Id',
								N'IndexingV2_MSSqlServer',
								N'timezone'
							)
		)   AS  CLS
		PIVOT(
			MAX([attrVal])
			FOR attrName IN
			(
				[Virtual Client],
				[SP Version Info],
				[IndexingV2],
				[timezone Id],
				[IndexingV2_MSSqlServer],
				[timezone]
			)
		)AS pvt
	INSERT INTO #ClientDetails
		SELECT
			ac.id,
			ac.simOperatingSystemId,
			ac.net_hostname,
			ac.jobResultDir,
			ac.status,
			ac.specialClientFlags,
			ac.displayName,
			CASE WHEN pvt.VirtualClient IS NULL THEN
				CASE WHEN (ac.specialClientFlags & 0x02) = 0x02 THEN 1 ELSE 0 END
				ELSE CAST(pvt.VirtualClient AS INT) END AS VirtualClient,
			ISNULL(pvt.SpVersion, N'') AS SPVersionInfo,
			CAST(ISNULL(pvt.IndexingV2, N'0') AS INT) AS IndexingV2,
			ISNULL(stz.TimeZoneName, N'') AS TimeZoneName,
			CAST(ISNULL(pvt.IndexingV2SQL, N'0') AS INT) AS IndexingV2Sql,
			CAST(ISNULL(pvt.TzoneId, N'0') AS INT) AS timezoneId,
			0,
			N'Any',
			N'Any'
		FROM APP_Client ac
			JOIN (SELECT DISTINCT ClientId FROM #ClientInstanceDetails) cid
				ON ac.id = cid.ClientId
			LEFT JOIN #TEMP_APP_CLIENT_PROP pvt
				ON cid.ClientId = pvt.componentNameId
			LEFT JOIN SchedTimeZone stz
				ON CAST(stz.TimeZoneID AS NVARCHAR(128)) = pvt.TzoneId
	-- OS details
	UPDATE CD SET
		CD.OSName = OS.Name, CD.OsType = OS.Type
	FROM #ClientDetails CD JOIN simOperatingSystem OS  WITH(NOLOCK) ON OS.id = CD.OsId
	/** Instance **/
	IF OBJECT_ID('tempdb..#TEMP_APP_INSTANCE_PROP') IS NOT NULL
		DROP TABLE #TEMP_APP_INSTANCE_PROP
	CREATE TABLE #TEMP_APP_INSTANCE_PROP (
		componentNameId INT,
		ServerType NVARCHAR(1024),
		InstanceVersion NVARCHAR(1024)
	)
	CREATE NONCLUSTERED INDEX IDX_Temp_Instance_Props
		ON #TEMP_APP_INSTANCE_PROP (componentNameId, ServerType, InstanceVersion)
	INSERT INTO #TEMP_APP_INSTANCE_PROP
		SELECT pvt.componentNameId,
			pvt.[MSSQL Server Type] AS ServerType,
			pvt.[MSSQL Version] AS InstanceVersion
		FROM
		(
			SELECT
				componentNameId,
				attrName,
				attrVal
			FROM APP_InstanceProp AIP
				JOIN #ClientInstanceDetails CI
					ON CI.InstanceId  = AIP.componentNameId
						AND AIP.modified = 0
						AND AIP.attrName IN
							(
								N'MSSQL Server Type',
								N'MSSQL Version'
							)
		)   AS  CLS
		PIVOT(
			MAX([attrVal])
			FOR attrName IN
			(
				[MSSQL Server Type],
				[MSSQL Version]
			)
		)AS pvt
	INSERT INTO #InstanceDetails
		SELECT ai.id,
			cid.ClientId,
			ai.name,
			ai.status,
			CASE  WHEN (IsNull(pvt.ServerType, '') = '' AND (pvt.InstanceVersion is not NULL)) THEN 'Database Engine' ELSE pvt.ServerType END AS type,
			pvt.InstanceVersion as version
		FROM APP_InstanceName ai JOIN #ClientInstanceDetails cid
				ON ai.id = cid.InstanceId
			JOIN #TEMP_APP_INSTANCE_PROP pvt
				ON ai.id = pvt.componentNameId
	-- Lets update type for each client based on instance type.
	-- 0 : Normal Client with DB or Analysis engine.
	-- 1 : AG client
	-- 2 : AWS client
	-- 3 : Azure Client
	-- 4 : MIXED client
	UPDATE CD SET
		-- MSSQL_AG
		CD.ClientType = CASE WHEN CD.ClientType <> 0 THEN 4 ELSE 1 END
	FROM #ClientDetails CD WHERE ((CD.status & 0x20000000 /* CV_STATUS_MSSQLAG */) = 0x20000000)
	UPDATE CD SET
		-- CLOUD_APPS_AZURE
		CD.ClientType = CASE WHEN CD.ClientType <> 0 THEN 4 ELSE 3 END
	FROM #ClientDetails CD JOIN #InstanceDetails ID on CD.ClientId = ID.ClientId
		WHERE (ID.ServerType = 'Azure DataBase Engine') OR (ID.ServerType = 'Azure Managed DataBase Engine')
	UPDATE CD SET
		-- CLOUD_APPS_AWS
		CD.ClientType = CASE WHEN CD.ClientType <> 0 THEN 4 ELSE 2 END
	FROM #ClientDetails CD JOIN #InstanceDetails ID on CD.ClientId = ID.ClientId
		WHERE (ID.ServerType = 'Aws DataBase Engine')
	-- Update OS details for AG instances.
	IF(EXISTS(SELECT 1 FROM #ClientDetails CD
			WHERE ((CD.status & 0x20000000 /* CV_STATUS_MSSQLAG */) = 0x20000000)))
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tt_InstanceOsInfo') IS NOT NULL
			DROP TABLE #tt_InstanceOsInfo
		CREATE TABLE #tt_InstanceOsInfo (instanceId INT, OsName NVARCHAR(256), OsType NVARCHAR(256))
		-- Store AG instance OS information.
		INSERT INTO #tt_InstanceOsInfo
			SELECT  DISTINCT RP.InstanceId, CD.OsName, CD.OsType
					FROM #tt_ReplicasPerAG RP
						JOIN #ClientDetails CD ON RP.ReplicaId = CD.ClientId
					ORDER BY RP.InstanceId
		UPDATE CD SET
			CD.OsName = CASE WHEN T.NumOs = 1 THEN ios.OsName ELSE 'Any' END,
			CD.OsType = CASE WHEN  T.NumOs = 1 THEN ios.OsType ELSE 'Any' END
		FROM #ClientDetails CD JOIN #InstanceDetails ID ON CD.ClientId = ID.ClientId
			-- Filter on AG instances
			JOIN #tt_InstanceOsInfo ios ON ios.instanceId = ID.InstanceId
			-- Get # of OS found on for the AG instance.
			JOIN (SELECT instanceId, count(instanceId) NumOs FROM #tt_InstanceOsInfo GROUP BY instanceId) T
				ON ios.instanceId = T.instanceId
	END
	SET @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage' FOR XML PATH('response'), TYPE),
							(SELECT CD.ClientId AS "@cId", CD.ClientName AS "@cName", CD.ClientType AS "@cType", CD.Flags AS "@flags", CD.HostName AS "@host",
									CD.IndexingV2Client AS "@idxV2", CD.IndexingV2Sql AS "@idxV2Sql", CD.OSName AS "@osName", CD.OsType AS "@osType",
									CD.SPVersion AS "@spVersion", CD.status AS "@status", CD.Timezone AS "@tzone", CD.TimezoneName AS "@tzName",
									CD.VirtualClient AS "@vClient",
									(SELECT ID.InstanceId AS "@insId", ID.InstanceName AS "@insName", ID.ServerType AS "@sType",
											ID.ServerVersion AS "@sVersion", ID.Status AS "@status",
											(SELECT RP.replicaId AS "@repId", RP.role AS "@role", Rp.endpointUrl AS "@epURL",
												RP.instanceName AS "@name"
												FROM #tt_ReplicasPerAG RP
												WHERE Rp.instanceId = ID.InstanceId
												FOR XML PATH('replica'), type),
											(SELECT PC.proxy AS "@proxyId"
												FROM #tt_ProxiesPerCloudInstance PC
												WHERE PC.instance = ID.InstanceId
												FOR XML PATH('proxy'), type)
											FROM #InstanceDetails ID WHERE  ID.ClientId = CD.ClientId
										FOR XML PATH('SqlInstance'), TYPE)
								FROM #ClientDetails CD  FOR XML PATH('SqlClient'), TYPE)
							FOR XML PATH(''), ROOT(N'App_GetSQLClientInstanceRsp')), N'<App_GetSQLClientInstanceRsp />')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @XmlInputOutput = (SELECT @@ERROR AS '@errorCode', 'Failed to get client and instance details.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'App_GetSQLClientInstanceRsp'))
END CATCH
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlClientInstances')
	delete from GxQscripts where name = 'AppGetSqlClientInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlClientInstances')
	delete from GXDBVersions where aliasname = 'AppGetSqlClientInstances'
GO

insert into GXDBVersions values(2, 'AppGetSqlClientInstances',  '00000000000000000000', 'AppGetSqlClientInstances', '00000000000000000000')
GO

