

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlBrowseDatabasesXml.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| Stored Procedure: AppGetSqlBrowseDatabasesXml
--	|
--	| Description:
--	|	This SP will be used to get database list for latest browse or job
--  |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSqlBrowseDatabasesXml')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSqlBrowseDatabasesXml <<<'
	drop procedure AppGetSqlBrowseDatabasesXml
END
IF EXISTS (select * from GxQscripts where name='AppGetSqlBrowseDatabasesXml')
	delete from GxQscripts where name = 'AppGetSqlBrowseDatabasesXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlBrowseDatabasesXml')
	delete from GXDBVersions where aliasname = 'AppGetSqlBrowseDatabasesXml'
GO
print '... Creating Procedure: AppGetSqlBrowseDatabasesXml'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlBrowseDatabasesXml
  @ioXmlInput XML OUTPUT, 
  @i_outTableArgs nvarchar(255)
AS
  DECLARE @o_xml XML
SET NOCOUNT OFF
-- Input Arguments
DECLARE @i_unixTime				INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@unixTime)[1]','INT')), 0)
DECLARE @i_serverId				INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@serverId)[1]','INT')), 0)
DECLARE @i_browseType			INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@browseType)[1]','INT')), 0)
DECLARE @i_dataType 			INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@dataType)[1]','INT')), 0)
DECLARE @i_copyPrecedence 		INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@copyPrecedence)[1]','INT')), 0)
DECLARE @i_includeAgedData		INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@includeAgedData)[1]','INT')), 0)
DECLARE @i_excludeBeforeTime	INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@excludeBeforeTime)[1]','INT')), 0)
DECLARE @i_jobid				INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@jobid)[1]','INT')), 0)
DECLARE @i_ccid_1 				INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@ccid_1)[1]','INT')), 0)
DECLARE @i_ccid_2 				INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@ccid_2)[1]','INT')), 0)
DECLARE @i_backupMethods		NVARCHAR(255) = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@backupMethods)[1]','NVARCHAR(255)')), N'')
DECLARE @i_browseSystemDB		INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@browseSystemDB)[1]','INT')), 0)
DECLARE @i_includeCanClone		INT = ISNULL((SELECT @ioXmlInput.value('(/App_GetSQLBrowseDatabasesReq/@cloneable)[1]','INT')), 0)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#appIdTable') IS NOT NULL DROP TABLE #appIdTable
CREATE TABLE #appIdTable ( appId INT )
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
CREATE TABLE #archFileIdTable (archFileId INT, commCellId INT, jobId INT)
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
CREATE TABLE #sqlDbBackupFileIdTable (sqlDbBackupFileId INT, commCellId INT)
IF @i_jobid = 0
BEGIN
    INSERT  INTO #appIdTable
        SELECT  DISTINCT appId
        FROM    sqlDbBackupInfo
        WHERE   instanceId = @i_serverId
            AND backup_finish_Date <= @i_unixTime
            AND backup_finish_Date >= @i_excludeBeforeTime
    IF @i_copyPrecedence = 0
        INSERT  INTO #archFileIdTable
        SELECT a.id, a.commCellId, a.jobid
        FROM    archFile a, archFileCopy b, archGroupCopy c
        WHERE   a.appId IN (SELECT appId FROM #appIdTable)
            AND a.id = b.archFileId AND a.commCellId = b.commCellId
            AND a.cTime >= @i_excludeBeforeTime
            AND a.cTime <= @i_unixTime
            AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
            AND b.archCopyId = c.id
            AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
    ELSE
        INSERT  INTO #archFileIdTable
        SELECT  DISTINCT a.id, a.commCellId, a.jobid
        FROM    archFile a, archFileCopy b, archGroupCopy c
        WHERE   a.appId IN (SELECT appId FROM #appIdTable)
            AND a.id = b.archFileId AND a.commCellId = b.commCellId
            AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
            AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
            AND a.cTime >= @i_excludeBeforeTime
            AND a.cTime <= @i_unixTime
            AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
            AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
END
ELSE
BEGIN
    INSERT  INTO #appIdTable
        SELECT  DISTINCT appId
        FROM    archfile
        WHERE   jobid = @i_jobid
            AND commCellId = @i_ccid_1
    IF @i_copyPrecedence = 0
        INSERT  INTO #archFileIdTable
        SELECT a.id, a.commCellId, a.jobid
        FROM    archFile a, archFileCopy b, archGroupCopy c
        WHERE   a.appId IN (SELECT appId FROM #appIdTable)
            AND a.id = b.archFileId AND a.commCellId = b.commCellId
            AND a.jobid = @i_jobid
            AND a.commcellid = @i_ccid_1
            AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
            AND b.archCopyId = c.id
            AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
    ELSE
        INSERT  INTO #archFileIdTable
        SELECT  DISTINCT a.id, a.commCellId, a.jobid
        FROM    archFile a, archFileCopy b, archGroupCopy c
        WHERE   a.appId IN (SELECT appId FROM #appIdTable)
            AND a.id = b.archFileId AND a.commCellId = b.commCellId
            AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
            AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
            AND a.jobid = @i_jobid
            AND a.commcellid = @i_ccid_1
            AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
            AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
END
update #archFileIdTable
		set #archFileIdTable.commCellId = JMPreparedJob.commCellId, #archFileIdTable.jobId = JMPreparedJob.jobId, #archFileIdTable.archFileId = archFile.id
	from JMPreparedJob, archFile
	WHERE JMPreparedJob.preparedJobId = #archFileIdTable.jobId and
		JMPreparedJob.preparedJobCCId = #archFileIdTable.commCellId AND
		archFile.jobId = JMPreparedJob.jobId and
		archFile.commCellId = JMPreparedJob.commCellId
INSERT  INTO #sqlDbBackupFileIdTable
SELECT  DISTINCT sqlDbBackupFileId, b.commCellId
FROM    sqlArchiveInfo a, #archFileIdTable b
WHERE   a.aFileId = b.archFileId AND a.commCellId = b.commCellId
BEGIN
        INSERT  INTO #sqlDbBackupFileIdTable
            SELECT  DISTINCT dbinfo.ID, afid.commCellId
            FROM sqldbbackupinfo dbinfo, #archFileIdTable afid
            WHERE
            dbinfo.jobId = afid.jobId and
            dbinfo.id not in (select sqlDbBackupFileId from #sqlDbBackupFileIdTable) and
            dbinfo.backupMethod = 2
END
IF object_id('tempdb.dbo.#finalDatabaseList') is not null DROP TABLE #finalDatabaseList
	CREATE TABLE #finalDatabaseList (databaseName nvarchar(1024), databaseId int, version nvarchar(256),
			sqlNameId int, backup_finish_date int, jobId int, lastBkpSet int, mjrVersion int,
			lastLsn NUMERIC(25, 0), fullBkpLsn NUMERIC(25, 0), bkpType char, minorVersion int, buildVersion int, commCellId int)
;WITH last_bkp_details (backup_finish_time, sqlnameId, BkpSetId, commCellId, row_num) AS
	(SELECT b.backup_finish_date, b.sqlNameId, b.id, a.commCellId, ROW_NUMBER() OVER (PARTITION BY  b.sqlNameId ORDER BY backup_finish_date DESC)
		from #sqlDbBackupFileIdTable a JOIN sqlDbBackupInfo b ON b.id = a.sqlDbBackupFileId)
		INSERT INTO #finalDatabaseList
			select sn2.name, sdbi.dbId, concat(sdbi.majorVersion, '.', sdbi.minorVersion, '.', sdbi.buildVersion) as version,
				sdbi.sqlNameId, lbd.backup_finish_time, sdbi.jobId, sdbi.id as bkpSetId,
				sdbi.majorVersion, sdbi.last_lsn, sdbi.full_bkup_lsn, sdbi.type, sdbi.minorVersion, sdbi.buildVersion, lbd.commCellId
			FROM last_bkp_details lbd JOIN sqlDbBackupInfo sdbi
				ON lbd.sqlNameId = sdbi.sqlNameId AND sdbi.instanceId = @i_ServerId AND lbd.BkpSetId = sdbi.id
				JOIN sqlNames sn ON sn.id = lbd.sqlNameId
				JOIN sqlNames2 sn2 on sn.sqlId = sn2.id
				WHERE lbd.row_num = 1
				AND ((@i_browseSystemDB = 1) OR( sn2.name != 'model' AND sn2.name != 'msdb' AND sn2.name != 'master' AND sn2.name != 'tempdb'))
-- Lets get the FULL backup details now.
IF OBJECT_ID('tempdb.dbo.#fullBackupInfo') is not null DROP TABLE #fullBackupInfo
	CREATE TABLE #fullBackupInfo (sqlNameId int, backup_finish_date int, jobId int, backupmethod int, appId int, cloneable int)
;WITH SqlFullBkp (SqlNameId, BkpFinTime, AppId, BkpMethod, jobId, rn)  AS
	(select s.sqlNameId, s.backup_finish_Date, s.appId, s.backupmethod, s.jobId,
		ROW_NUMBER() OVER (PARTITION BY  s.sqlNameId ORDER BY s.backup_finish_date DESC) rn
		 FROM  sqlDbBackupInfo s JOIN #finalDatabaseList f ON s.sqlNameId = f.sqlNameId AND s.instanceId = @i_ServerId
				AND s.backup_finish_Date <= @i_unixTime
		WHERE
			(f.bkpType = 'D' AND f.lastBkpSet = s.id ) OR
			(f.mjrVersion = 7 and s.last_lsn = f.lastLsn and s.type = 'D') OR
			(f.mjrVersion >= 8 AND s.checkpoint_lsn = f.fullBkpLsn and s.type IN ('D', 'P')) OR
			(s.type IN ('D', 'P')))
	INSERT INTO #fullBackupInfo
		SELECT SqlNameId, BkpFinTime, jobId, BkpMethod, AppId, 0 from SqlFullBkp WHERE rn = 1
if len(@i_backupMethods) > 0
BEGIN
	DELETE FROM #fullBackupInfo WHERE backupmethod not in (select _ID from dbo.SplitIDs(@i_backupMethods))
END
IF @i_includeCanClone > 0
BEGIN
	;WITH CloneableCheck(jobId, cloneable) AS
	(SELECT SMVOL.JobId, AVG(CASE WHEN SMENG.Capabilities & 16777216 <> 0 THEN 1 ELSE 0 END) CloneAble
		FROM SMVolume SMVOL
			JOIN #fullBackupInfo FBI ON SMVOL.JobId = FBI.jobId
			JOIN SMVolSnapMap SMMAP ON SMVOL.SMVolumeId = SMMAP.SMVolumeId
			JOIN SMSnap SMSN  ON SMSN.SMSnapId = SMMAP.SMSnapId
			JOIN SMSnapShotEngine SMENG ON SMENG.SnapShotEngineId = SMSN.SnapShotEngineId
		GROUP BY SMVOL.JobId)
	UPDATE FBI SET FBI.cloneable = CC.cloneable
		FROM #fullBackupInfo FBI JOIN CloneableCheck CC ON CC.jobId = FBI.jobId
END
if len(@i_outTableArgs) = 0
BEGIN
	SET @ioXmlInput = ISNULL((SELECT (SELECT fdl. databaseName AS '@dbName', fdl.databaseId AS '@databaseId', fdl.mjrVersion AS '@majorVersion',
											fdl.minorVersion AS '@minorVersion', fdl.buildVersion AS '@buildVersion', fdl.backup_finish_date AS '@backupFinishDate',
											fdl.jobId AS '@jobId',  fdl.commCellId AS '@commCellId', fbi.appId AS '@fullAppId', fbi.jobId AS '@fullJobId',
											fbi.backupmethod AS '@fullBackupmethod', fbi.backup_finish_date AS '@fullBackupTime', fbi.cloneable AS '@cloneable'
										FROM #finalDatabaseList fdl JOIN #fullBackupInfo fbi
											ON fdl.sqlNameId = fbi.sqlNameId FOR XML PATH('SqlDatabases'), type)
									  FOR XML PATH(''), root('App_GetSQLBrowseDatabaseResp')), N'<App_GetSQLBrowseDatabaseResp />')
	SELECT @ioXmlInput
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#OutfinalDatabaseList') is not null DROP TABLE #OutfinalDatabaseList
	CREATE TABLE #OutfinalDatabaseList (databaseName nvarchar(1024), databaseId int, version nvarchar(256),
			sqlNameId int, backup_finish_date int, jobId int)
	INSERT INTO #OutfinalDatabaseList
		SELECT fdl.databaseName, fdl.databaseId, fdl.version, fdl.sqlNameId, fdl.backup_finish_date, fdl.jobId
			FROM #finalDatabaseList fdl JOIN #fullBackupInfo fbi
			ON fdl.sqlNameId = fbi.sqlNameId
	declare @finalExecStatement NVARCHAR(1024) = N''
	set @finalExecStatement = 'INSERT INTO '+ @i_outTableArgs +' SELECT * FROM #OutfinalDatabaseList'
	exec (@finalExecStatement)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlBrowseDatabasesXml')
	delete from GxQscripts where name = 'AppGetSqlBrowseDatabasesXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlBrowseDatabasesXml')
	delete from GXDBVersions where aliasname = 'AppGetSqlBrowseDatabasesXml'
GO

insert into GXDBVersions values(2, 'AppGetSqlBrowseDatabasesXml',  '00000000000000000000', 'AppGetSqlBrowseDatabasesXml', '00000000000000000000')
GO

