

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlAuth.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSqlAuth.sp,v $ $Id: AppGetSqlAuth.sp,v 1.2.294.16 2020/08/12 20:57:23 abhinawkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSqlAuth')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSqlAuth <<<'
	drop procedure AppGetSqlAuth
END
IF EXISTS (select * from GxQscripts where name='AppGetSqlAuth')
	delete from GxQscripts where name = 'AppGetSqlAuth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlAuth')
	delete from GXDBVersions where aliasname = 'AppGetSqlAuth'
GO
print '... Creating Procedure: AppGetSqlAuth'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlAuth
  @instanceId integer,
  @skipInstance integer,
--skipInstance = 1 when called from guiserver, or called for restore to disk
  @i_clientId integer,
  @i_cloudServer integer
AS
  DECLARE @oInstanceId integer
  DECLARE @authType integer
  DECLARE @userName nvarchar(1024)
  DECLARE @userPassword nvarchar(1024)
  DECLARE @level integer
/*
Ways to use it:
0] Give instance ID as input.
	'skipInstance' used for skipping instance level properties.
1] Input table with multiple instances.
	DECLARE INPUT TABLE - for multiple instances.
	Eg:
	IF OBJECT_ID('tempdb..#temp_instances') IS NOT NULL DROP TABLE #temp_instances
	CREATE TABLE #temp_instances (instance int)
	INSERT INTO #temp_instances values(8)
	INSERT INTO #temp_instances values(9)
2] Out table for multiple or single rows.
	Eg:
	DROP TABLE #SQLAuthDetails
	CREATE TABLE #SQLAuthDetails (instanceId int, authType int,
		userName nvarchar(1024), userPassword nvarchar(1024), level int)
	Type:	1-use windows NT auth, 2-username and pwd are returned, 0-couldnot find anything
	level:	1-instance, 2-ida, 3-cli group, 4-commcell
*/
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Check if the request to get authentication information is for discovery of cloud servers
DECLARE @discoverCloudServer bit = 0
if(@instanceId = 0 AND @i_cloudServer = 1)
	SET @discoverCloudServer  = 1
ELSE
	SET @discoverCloudServer  = 0
-- Check if we need authentication information for restore to disk
DECLARE @isRestoreToDisk bit = 0
IF(@instanceId = 0 AND @skipInstance = 1 AND @i_clientId <> 0 AND @discoverCloudServer = 0)
	set @isRestoreToDisk = 1
IF OBJECT_ID('tempdb..#itt_instances') IS NOT NULL DROP TABLE #itt_instances
CREATE TABLE #itt_instances (instance int)
-- Do not populate #itt_instances if the request to get authentication information is for
-- discovery of cloud server or restore to disk.
IF(@discoverCloudServer = 0 AND @isRestoreToDisk = 0)
BEGIN
	IF ((OBJECT_ID('tempdb..#temp_instances') IS NULL) AND (@instanceId <> 0))
		INSERT INTO #itt_instances values(@instanceId)
	ELSE
		/*
			DECLARE INPUT TABLE - for multiple instances.
			Eg:
			IF OBJECT_ID('tempdb..#temp_instances') IS NOT NULL DROP TABLE #temp_instances
			CREATE TABLE #temp_instances (instance int)
			INSERT INTO #temp_instances values(8)
			INSERT INTO #temp_instances values(9)
		*/
		INSERT INTO #itt_instances SELECT instance FROM #temp_instances
END
IF OBJECT_ID('tempdb..#ott_InstanceAuth') IS NOT NULL
	DROP TABLE #ott_InstanceAuth
CREATE TABLE #ott_InstanceAuth (instance int, clientId int,
		authLvl int, isOverride INT,  uname nvarchar(1024), pswd nvarchar(1024), authType int)
IF(@discoverCloudServer = 0 AND @isRestoreToDisk = 0)
BEGIN
	INSERT INTO #ott_InstanceAuth SELECT DISTINCT ap.instance, ap.clientId, 0, 0, N'', N'', 0
		FROM #itt_instances ia JOIN APP_Application ap ON ap.instance = ia.instance
END
ELSE
	INSERT INTO #ott_InstanceAuth SELECT 0, @i_clientId, 0, 0, N'', N'', 0
-- Instance level
IF (@skipInstance = 0 AND @discoverCloudServer  = 0)
BEGIN
	UPDATE IA
		SET IA.authLvl = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 THEN 1 ELSE 0 END,
		IA.isOverride = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 THEN 1 ELSE 0 END,
		IA.uname = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 AND pvt.[MSSQL Use Windows Authentication] = 0 THEN pvt.[MSSQL username] ELSE N'' END,
		IA.pswd = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 AND pvt.[MSSQL Use Windows Authentication] = 0 AND pvt.[MSSQL username] IS NOT NULL
			THEN pvt.[MSSQL password] ELSE N'' END,
		IA.authType = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1
						THEN CASE WHEN pvt.[MSSQL Use Windows Authentication] = 0
								THEN 2 ELSE 1 END
						ELSE 0 END
	FROM #ott_InstanceAuth IA
			LEFT JOIN (SELECT componentNameId, attrName, CASE WHEN attrName = 'MSSQL password' THEN dbo.pswConvertV5ToV3(attrVal) ELSE attrVal END AS attrVal
					FROM APP_InstanceProp WHERE modified = 0) AS IP
					PIVOT(MAX([attrVal]) FOR attrName in ([MSSQL Override Global Authentication], [MSSQL Use Windows Authentication],
										[MSSQL username], [MSSQL password]))AS pvt ON ia.instance = pvt.componentNameId
	WHERE IA.authLvl = 0
END
-- IDA Level
BEGIN
	UPDATE IA SET
		IA.authLvl = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 THEN 2 ELSE 0 END,
		IA.isOverride = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 THEN 1 ELSE 0 END,
		IA.uname = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 AND pvt.[MSSQL Use Windows Authentication] = 0 THEN pvt.[MSSQL username] ELSE N'' END,
		IA.pswd = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1 AND pvt.[MSSQL Use Windows Authentication] = 0 THEN dbo.pswConvertV5ToV3(pvt.[MSSQL password]) ELSE N'' END,
		IA.authType = CASE WHEN pvt.[MSSQL Override Global Authentication] = 1
						THEN CASE WHEN pvt.[MSSQL Use Windows Authentication] = 0
								THEN 2 ELSE 1 END
						ELSE 0 END
	FROM #ott_InstanceAuth IA
			JOIN APP_IDAName INA ON INA.clientId = ia.clientId AND INA.apptypeId = 81
			LEFT JOIN (SELECT componentNameId, attrName, attrVal FROM APP_IDAProp IX WHERE IX.modified = 0) AS IDP
				PIVOT(max([attrVal]) for attrName in ([MSSQL Override Global Authentication], [MSSQL Use Windows Authentication], [MSSQL username], [MSSQL password])
			)AS pvt ON INA.id = pvt.componentNameId
		WHERE IA.authLvl = 0 OR IA.authType = 0
END
-- ClientGroup Level
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tt_OverideOptions') IS NOT NULL DROP TABLE #tt_OverideOptions
	CREATE TABLE #tt_OverideOptions(clientId int, CGid int, compId int, overridden int, rn int)
	INSERT INTO #tt_OverideOptions
		SELECT CGA.clientId, CGA.clientGroupId,  componentId, longVal,
				ROW_NUMBER() OVER (PARTITION BY CGA.clientId ORDER BY CGA.clientGroupId ASC) rn
		FROM APP_ClientGroupAssoc CGA
			JOIN #ott_InstanceAuth IA on IA.clientId = CGA.clientId
			JOIN APP_ComponentProp CP on CP.componentId = CGA.clientGroupId
		WHERE CP.componentType = 8 AND propertyTypeId = 1200 AND dataType = 10
			AND modified = 0 AND longVal > 0 AND (IA.authLvl = 0 OR IA.authType = 0)
	-- WHEN more than one row found, use WIN AUTH.
	IF @@ROWCOUNT > 1
	BEGIN
		UPDATE IA SET
			IA.authLvl = 3,
			IA.isOverride = 0,
			IA.uname = N'',
			IA.pswd = N'',
			IA.authType = 1
		FROM #ott_InstanceAuth IA
			JOIN #tt_OverideOptions tt ON tt.clientId = IA.clientId
		WHERE (IA.authLvl = 0 OR IA.authType = 0)
	END
	ELSE
	BEGIN
		-- Only one row found. Update override property.
		UPDATE IA SET
			IA.authLvl = CASE WHEN OO.overridden = 1 THEN 3 ELSE 0 END,
			IA.isOverride = OO.overridden
		FROM #ott_InstanceAuth IA
			JOIN #tt_OverideOptions OO ON OO.clientId = IA.clientId
		WHERE OO.rn = 1 AND (IA.authLvl = 0 OR IA.authType = 0)
		-- Update uname and password.
		-- Get LSA or not, property id is 1201.
		UPDATE IA SET
			IA.authType = CASE WHEN longVal = 0 THEN 2 ELSE 1 END,
			IA.pswd = N'', IA.uname = N''
		FROM #ott_InstanceAuth IA
			JOIN #tt_OverideOptions VCG ON VCG.clientId = IA.clientId
			JOIN APP_ClientGroupAssoc CGA on VCG.CGid = CGA.clientGroupId AND IA.clientId = CGA.clientId
			JOIN APP_ComponentProp CP on CP.componentId = CGA.clientGroupId
			WHERE CP.componentType = 8 AND propertyTypeId = 1201 AND dataType = 10
				AND modified = 0 AND IA.authLvl = 3
		UPDATE IA SET
			IA.uname = stringVal
		FROM #ott_InstanceAuth IA
			JOIN #tt_OverideOptions VCG ON VCG.clientId = IA.clientId
			JOIN APP_ClientGroupAssoc CGA on VCG.CGid = CGA.clientGroupId AND IA.clientId = CGA.clientId
			JOIN APP_ComponentProp CP on CP.componentId = CGA.clientGroupId
			WHERE CP.componentType = 8 AND propertyTypeId = 1202 AND dataType = 1 AND modified = 0
				AND IA.authLvl = 3 AND IA.authType = 2
		UPDATE IA SET
			IA.pswd = stringVal
		FROM #ott_InstanceAuth IA
			JOIN #tt_OverideOptions VCG ON VCG.clientId = IA.clientId
			JOIN APP_ClientGroupAssoc CGA on VCG.CGid = CGA.clientGroupId AND IA.clientId = CGA.clientId
			JOIN APP_ComponentProp CP on CP.componentId = CGA.clientGroupId
			WHERE CP.componentType = 8 AND propertyTypeId = 1203 AND dataType = 1 AND modified = 0
				AND IA.authLvl = 3 AND IA.authType = 2
	END
END
-- Global property
BEGIN
	DECLARE @UseNTAuth VARCHAR(2) = N''
	DECLARE @isGlobalAuthFound INTEGER = 0
	SELECT @isGlobalAuthFound = COUNT(*) from GXGlobalParam where name = 'MSSQL Use Windows Authentication' AND modified = 0
	IF @isGlobalAuthFound <> 0
	BEGIN
		SELECT @UseNTAuth = value from GXGlobalParam where name = 'MSSQL Use Windows Authentication' AND modified = 0
		if(@UseNTAuth = '0')
		BEGIN
			UPDATE IA SET
				IA.authLvl = 4,
				IA.isOverride = 1,
				IA.uname = (select value from GXGlobalParam where name = 'MSSQL username' AND modified = 0),
				IA.pswd = (select value from GXGlobalParam where name = 'MSSQL password' AND modified = 0),
				IA.authType = 2
			FROM #ott_InstanceAuth IA WHERE (IA.authLvl = 0 OR IA.authType = 0)
		END
		ELSE
		BEGIN
			UPDATE IA SET
				IA.authLvl = 4,
				IA.isOverride = 1,
				IA.authType = 1
			FROM #ott_InstanceAuth IA WHERE (IA.authLvl = 0 OR IA.authType = 0)
		END
	END
END
-- When no settings found, set to default.
UPDATE IA SET
	IA.authLvl = 4, IA.isOverride = 0,
	IA.uname = N'', IA.pswd = N'',
	IA.authType = 1
FROM #ott_InstanceAuth IA WHERE (IA.authLvl = 0 AND @skipInstance = 1) OR (IA.authLvl = 0 AND IA.authType = 0)
IF OBJECT_ID('tempdb..#SQLAuthDetails') IS NULL
BEGIN
	IF @instanceId <> 0
		select instance, authType AS authType, uname AS userName, pswd AS userPassword, authLvl AS level
			FROM #ott_InstanceAuth WHERE instance = @instanceId
	ELSE
		select instance, authType AS authType, uname AS userName, pswd AS userPassword, authLvl AS level
			FROM #ott_InstanceAuth
END
ELSE IF OBJECT_ID('tempdb..#SQLAuthDetails') IS NOT NULL
BEGIN
	INSERT INTO #SQLAuthDetails (instanceId, authType, userName, userPassword, level)
		select instance, authType, uname, pswd, authLvl FROM #ott_InstanceAuth
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlAuth')
	delete from GxQscripts where name = 'AppGetSqlAuth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlAuth')
	delete from GXDBVersions where aliasname = 'AppGetSqlAuth'
GO

insert into GXDBVersions values(2, 'AppGetSqlAuth',  '00010002029400160000', 'AppGetSqlAuth', '00010002029400160000')
GO

