

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSqlAfilesForBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault  Systems, Inc.
--        The copyright notice above does not evidence any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSqlAfilesForBackup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSqlAfilesForBackup <<<'
	drop procedure AppGetSqlAfilesForBackup
END
IF EXISTS (select * from GxQscripts where name='AppGetSqlAfilesForBackup')
	delete from GxQscripts where name = 'AppGetSqlAfilesForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlAfilesForBackup')
	delete from GXDBVersions where aliasname = 'AppGetSqlAfilesForBackup'
GO
print '... Creating Procedure: AppGetSqlAfilesForBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSqlAfilesForBackup
  @ioXmlInput XML OUTPUT
AS
  DECLARE @outputXML XML
-- Logic to update or insert the backup information.
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_backupSetID INT = ISNULL((Select Tbl.Col.value('@backupId', 'int') From @ioXmlInput.nodes('App_SQLGetAfilesForBackupReq') Tbl(Col)), 0)
DECLARE @i_backupTime INT = ISNULL((Select Tbl.Col.value('@backupTime', 'int') From @ioXmlInput.nodes('App_SQLGetAfilesForBackupReq') Tbl(Col)), 0)
DECLARE @i_lastLSN NUMERIC(32,0) = ISNULL((Select CAST(Tbl.Col.value('@lastLsn', 'NVARCHAR(32)') AS NUMERIC(32,0)) From @ioXmlInput.nodes('App_SQLGetAfilesForBackupReq') Tbl(Col)), 0)
DECLARE @vssBackup INT = 0
select @vssBackup = count(*) from sqlfilebackupinfo where sqldbbackupinfoid = @i_backupSetID and type = 100
IF OBJECT_ID('tempdb..#SqlBackupInput') IS NOT NULL DROP TABLE #SqlBackupInput
CREATE TABLE #SqlBackupInput(commcellId INT, aFileId INT, aOffset BIGINT, aGroupId INT, appId INT, dbFile NVARCHAR(MAX))
IF(@vssBackup <> 0)
BEGIN
	if(@vssBackup > 1)
	BEGIN
		--5.9 BACKUP order by aFileId
		INSERT INTO #SqlBackupInput
			select commcellId, aFileId, aFileOffset, aGroupId, appId, DbFile
			from sqlArchiveInfo
			where sqldbbackupfileid = @i_backupSetID
	END
	ELSE
	BEGIN
		INSERT INTO #SqlBackupInput
			select commcellId, aFileId, aFileOffset, aGroupId, appId, DbFile
			from sqlArchiveInfo
			where sqldbbackupfileid = @i_backupSetID
	END
END
ELSE
BEGIN
	IF NOT EXISTS (SELECT 1 FROM sqlDbBackupInfo WHERE id = @i_backupSetID AND begins_log_chain = 'Y')
	BEGIN
		INSERT INTO #SqlBackupInput
			select commcellId, aFileId, aFileOffset, aGroupId, appId, DbFile
			from sqlArchiveInfo
			where sqldbbackupfileid = @i_backupSetID
	END
	ELSE
	BEGIN
		-- Get exapnded list of backups.
		-- Order of rows is not needed, so removed 'rn'.
		-- Order of rows should be based on Last LSN value and it has been taken care by clustered index and ordered insert.
		IF OBJECT_ID('tempdb..#GetLogChainExpanded') IS NOT NULL DROP TABLE #GetLogChainExpanded
		CREATE TABLE #GetLogChainExpanded(sqlInfoID INT, last_lsn numeric(25, 0), ckpt_lsn numeric(25, 0), backup_finish_time int, offset BIGINT)
		-- We can expect around 1000 rows here and there will be need to access each column in WHERE condition.
		-- To improve the lookup, created below INDEX.
		Create CLUSTERED INDEX IDX_lastlsn_time_GetLogChain ON #GetLogChainExpanded (sqlInfoID, last_lsn DESC, backup_finish_time DESC)
		-- Get compressed xml entries.
		IF OBJECT_ID('tempdb..#compressedEntries') IS NOT NULL DROP TABLE #compressedEntries
		CREATE TABLE #compressedEntries(sqlInfoID INT, xmlOffsets XML)
		-- Here entries will be less (not more than 100 rows)
		-- Lets check the performance and then fix accordingly.
		INSERT INTO #compressedEntries
			SELECT SA.sqlDbBackupFileId, CAST(SA.DbFile AS XML)
				FROM sqlArchiveInfo SA WHERE SA.sqlDbBackupFileId = @i_backupSetID
		-- Query takes more time if entries are high. Need to to verify the performance.
		INSERT INTO #GetLogChainExpanded
			select SA.sqlInfoID, CAST(M.C.value('@last_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0)) LastLSN,
				CAST(M.C.value('@ckpt_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0))  CKPT_LSN, M.C.value('@backupTime', 'INT') bkp_fin_time,
				M.C.value('@value', 'BIGINT') offset
			from #compressedEntries AS SA OUTER APPLY SA.xmlOffsets.nodes('/App_SqlAfile/offset') AS M(C)
				ORDER BY CAST(M.C.value('@last_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0)) DESC
		INSERT INTO #SqlBackupInput
			SELECT SA.commcellId, SA.aFileId, GC.offset, SA.aGroupId, SA.appId, N''
				FROM sqlArchiveInfo SA JOIN #GetLogChainExpanded GC ON GC.sqlInfoID = SA.sqlDbBackupFileId
				WHERE GC.backup_finish_time = @i_backupTime
	END
END
SET @outputXML = (SELECT (SELECT SB.commcellId AS '@commcellId', SB.aFileId AS '@aFileId', SB.aOffset AS '@aOffset',
								SB.aGroupId AS '@aGroupId', SB.appId AS '@appId', SB.dbFile AS '@dbFile'
								FROM #SqlBackupInput SB
								FOR XML PATH('afile'), TYPE),
						(SELECT 0 AS '@errorCode', N'' AS '@errorMessage' FOR XML PATH('response'), TYPE)
					FOR XML PATH('App_SQLGetAfilesForBackupRsp'))
SELECT @outputXML

IF EXISTS (select * from GxQscripts where name = 'AppGetSqlAfilesForBackup')
	delete from GxQscripts where name = 'AppGetSqlAfilesForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSqlAfilesForBackup')
	delete from GXDBVersions where aliasname = 'AppGetSqlAfilesForBackup'
GO

insert into GXDBVersions values(2, 'AppGetSqlAfilesForBackup',  '00000000000000000000', 'AppGetSqlAfilesForBackup', '00000000000000000000')
GO

