

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSourceBackupContents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetSourceBackupContents')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSourceBackupContents <<<'
	drop procedure AppGetSourceBackupContents
END
IF EXISTS (select * from GxQscripts where name='AppGetSourceBackupContents')
	delete from GxQscripts where name = 'AppGetSourceBackupContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSourceBackupContents')
	delete from GXDBVersions where aliasname = 'AppGetSourceBackupContents'
GO
print '... Creating Procedure: AppGetSourceBackupContents'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetSourceBackupContents
  @userId INT,
  @sourceServerId INT,
  @appTypeId INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @havePermission  		INT = 0
DECLARE @errorCode              INT = 0
DECLARE @errorString            NVARCHAR(MAX) = N'Successful'
DECLARE @sourceServerName       NVARCHAR(MAX)
IF OBJECT_ID('tempdb.dbo.#subclientsTbl') IS NOT NULL DROP TABLE #subclientsTbl
CREATE  TABLE #subclientsTbl (backupsetId INT, backupsetName NVARCHAR(MAX), subclientId INT, subclientName NVARCHAR(MAX) , isOnePassSubClient INT)
EXEC sec_checkPermissionOnEntity  @userId, 0, @havePermission OUTPUT, 3, @sourceServerId
IF @havePermission <> 1
BEGIN
	SET @errorCode = 1
	SET @errorString = N'User [' + CONVERT(NVARCHAR(30), @userId) + '] does not have rights on source Server [' + CONVERT(NVARCHAR(30), @sourceServerId) + '].'
	SET @o_xmlText = (SELECT (SELECT @errorCode AS '@errorCode',
							@errorString AS '@errorMessage'
							FOR XML PATH ('error'), TYPE)
						FOR XML PATH('App_GetSourceBackupContentResp'),TYPE)
END
ELSE
BEGIN
	SELECT @sourceServerName = name FROM APP_Client AC WITH(NOLOCK)
							WHERE AC.id  = @sourceServerId
	-- We do not want archiver set subclients. Excluding them and getting only FS and one-pass Subclients for response...
	INSERT INTO #subclientsTbl (backupsetId, backupsetName, subclientId, subclientName, isOnePassSubClient)
	SELECT APP.backupSet, BSN.name, APP.id, APP.subclientName, (CASE WHEN ((SP.componentNameId IS NOT NULL) OR (BP.componentNameId IS NOT NULL)) THEN 1 ELSE 0 END)
	FROM APP_Application APP WITH(NOLOCK)
	INNER JOIN APP_BackupSetName BSN WITH(NOLOCK) ON APP.backupSet = BSN.id
	LEFT JOIN APP_SubclientProp SP WITH(NOLOCK)
		ON APP.id = SP.componentNameId
AND SP.attrName = N'Turbo Mode Enable Stubbing'
AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
		AND SP.attrVal = '1'
		AND SP.modified = 0
	LEFT JOIN APP_BackupsetProp BP WITH(NOLOCK)
		ON BP.componentNameId = App.backupset
AND BP.attrName = 'Is Archiving Enabled'
		AND BP.attrVal = '1'
		AND BP.modified = 0
	WHERE 	APP.clientId = @sourceServerId
			AND APP.appTypeId = @appTypeId
	SET @o_xmlText = ISNULL((
						SELECT (SELECT
									@sourceServerId AS '@clientId',
									@sourceServerName as '@clientName',
3 AS '@_type_'
										FOR XML PATH ('sourceServer'), TYPE),
						(SELECT @errorCode AS '@errorCode',
								@errorString AS '@errorMessage'
								FOR XML PATH ('error'), TYPE),
						(SELECT (	CASE SUBSTRING(ASF.fileName,1,7)
                                	WHEN 'UNC-NT_' THEN REPLACE(ASF.fileName, 'UNC-NT_', '\\')
                                	ELSE ASF.fileName END
								) 	AS '@path',
								STBL.isOnePassSubClient AS '@isArchiveOrOnePassSubClient',
(SELECT STBL.subclientId AS '@subclientId', STBL.subclientName AS '@subclientName' , 7 AS '@_type_'
									FOR XML PATH ('subclient'), TYPE),
(SELECT STBL.backupsetId AS '@backupsetId', STBL.backupsetName AS '@backupsetName', 6 AS '@_type_'
									FOR XML PATH ('backupset'), TYPE)
								FROM #subclientsTbl STBL
								LEFT JOIN APP_ScFilterFile ASF WITH(NOLOCK) ON ASF.componentNameId = STBL.subclientId AND ASF.type = 1 AND ASF.modified = 0
								WHERE ASF.componentNameId IS NOT NULL
						FOR XML PATH ('sourceBackupContent'), TYPE)
					FOR XML PATH('App_GetSourceBackupContentResp'),TYPE), '<App_GetSourceBackupContentResp />')
END
--SELECT @o_xmlText
IF OBJECT_ID('tempdb.dbo.#subclientsTbl') IS NOT NULL DROP TABLE #subclientsTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSourceBackupContents')
	delete from GxQscripts where name = 'AppGetSourceBackupContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSourceBackupContents')
	delete from GXDBVersions where aliasname = 'AppGetSourceBackupContents'
GO

insert into GXDBVersions values(2, 'AppGetSourceBackupContents',  '00000000000000000000', 'AppGetSourceBackupContents', '00000000000000000000')
GO

