

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSnapDRReplicationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppGetSnapDRReplicationInfo						|
--	|		 Procedure to get snap replication DR information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSnapDRReplicationInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSnapDRReplicationInfo <<<'
	drop procedure AppGetSnapDRReplicationInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetSnapDRReplicationInfo')
	delete from GxQscripts where name = 'AppGetSnapDRReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSnapDRReplicationInfo')
	delete from GXDBVersions where aliasname = 'AppGetSnapDRReplicationInfo'
GO
print '... Creating Procedure: AppGetSnapDRReplicationInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSnapDRReplicationInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    ---'<Api_GetSnapDRReplicationReq><vApp vAppId="7"/><user userId="1"/> </Api_GetSnapDRReplicationReq>'
	DECLARE	@o_xmlString			XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @vappId				INT
       DECLARE @vAppXml            XML
	DECLARE @userId				INT
	-- READ THE XML
	DECLARE @inPropertyLevel		INT = 30 --ListPropertyLevels_AllProperties
	SELECT  @inPropertyLevel=ISNULL(ref.value('@propertyLevel', 'INT'), @inPropertyLevel),
	        @userId = ISNULL(ref.value('user[1]/@userId', 'INT'), 0),
			@vappId = ISNULL(ref.value('vApp[1]/@vAppId', 'INT'), 0)
			FROM @i_xmlString.nodes ('Api_GetSnapDRReplicationReq') R(ref)
	if ( @userId = 0)
	    SELECT @userId = ISNULL((SELECT @i_xmlString.value('(//processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	   declare @operationType int
       select @vAppXml =vxml, @operationType = operationType from App_VirtualApp where id = @vappId
       declare @subclientID int
       declare @destClientID int
       declare @destInstanceID int
       declare @destInstanceName nvarchar(256)
       declare @copyId  int
       declare @sourceInstanceId int
       declare @sourceClientId int
       declare @sourceGUID  nvarchar(256)
       declare @sourceClientName nvarchar(256)
       select @copyId = @vAppXml.value('(Api_VirtualAppReq/vApp/arrayReplication/@copyId)[1]', 'int')
       select @subclientID = isnull(@vAppXml.value('(Api_VirtualAppReq/vApp/arrayReplication/subclient/@subclientId)[1]', 'int'),0)
       select @destClientID = @vAppXml.value('(Api_VirtualAppReq/vApp/arrayReplication/destination/@clientId)[1]', 'int')
       select @destInstanceID = I.id ,
                 @destInstanceName = I.name
       from APP_InstanceName I
       inner join app_application A
       on I.id = A.instance
       inner join app_client C
       on A.clientId = C.id
       and C.id = @destClientID
       select @sourceInstanceId = instance,
                 @sourceClientId = clientId,
                 @sourceClientName = C.name
       from app_application A
       inner join app_client c
       on clientid = c.id
        where A.id = @subclientID
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
CREATE TABLE #livesync_InfoTable (replicationId INT, ccId INT, failoverStatus INT, clientName NVARCHAR(2048), sourceClientId int, sourceName nvarchar(2048), sourceGUID nvarchar(256), destName nvarchar(2048), destGUID nvarchar(256), instId INT, instanceName NVARCHAR(2048),subclientId INT,
lastSyncedBkpJob INT, destClientId INT, destInstanceId INT, sourceESXServer nvarchar(1024), destESXServer nvarchar(1024),vmToolsInstalled int, vmsyncjobid int, nics xml, ipaddressoption xml,destComputerName nvarchar(256),testfailoverstatus int, lastfailureReason nvarchar(1024), isindexingv2 int)
       CREATE CLUSTERED INDEX livesync_InfoTable_replicationId_taskId_Index1 ON #livesync_InfoTable ([replicationId])
--
                     INSERT #livesync_InfoTable
                       select ReplicationId, 2,  R.FailoverStatus, @sourceClientName, c.id,  c.name,  cp.attrval, R.DestinationVMName, R.DestinationVMGuid,  @sourceInstanceId, '', @subclientID, 0, @destClientID,
                        @destInstanceID, null , null,0,0,null,null, '',TestFailoverStatus,'',0
                       FROM App_VirtualAppReplication R
                       inner join app_client C
                       on R.ClientId = C.id
                       inner join app_clientprop cp
                       on cp.componentNameId = c.id
                       and cp.attrName ='Virtual Machine Instance UUID'
                       and cp.modified =0
                       and R.VappId = @vappId
		-- Check for security associations
	IF ( @userId > 0 )
		BEGIN
			DECLARE @isUserAdmin INT = 0
			IF OBJECT_ID('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
			CREATE TABLE #idaListTemp
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			EXECUTE sec_isUserAdmin   @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
			IF ( @isUserAdmin != 1 )
			BEGIN
				EXEC sec_getIdaObjectsForUser @userId, 7 /*SUBCLIENT_ENTITY*/ , 0, 0, '#idaListTemp'
				DELETE LS
				FROM #livesync_InfoTable LS
				LEFT OUTER JOIN #idaListTemp ida ON LS.subclientId = ida.t_subclientId
			END
	 END
	   -- incase of planned failover/unplanned failover, consider only active vms of the subclient
	   if ( @operationType	= 16 )
	   begin
			delete LS
			from #livesync_InfoTable  LS
			left join ( select  cast(cp.componentNameId as int) clientId from app_clientprop cp
	        inner join SMVMReplicationMap map
	        on cp.componentNameId = map.ClientId
	        and cp.attrName ='Last Backup Subclient'
			and cp.attrVal = @subclientID
	        and cp.modified =0
	        ) t
			on ls.sourceClientId = t.clientId
			where t.clientId is  null
			delete LS
			from #livesync_InfoTable LS
			inner join    APP_ClientProp ACP1
            ON ACP1.componentNameId= LS.sourceClientId AND ACP1.attrName='Virtual Machine Deletion Time' AND ACP1.modified=0 AND isnull(ACP1.attrVal,0) <>'0'
	   end
	   if ( @operationType	= 256 )
	   begin
			update LS set failoverStatus = vr.FailoverStatus
			from #livesync_InfoTable LS
    		inner join App_VirtualAppReplication vr
        	on vr.ClientId = LS.sourceClientId
        	and vr.FailoverStatus in ( 1, 2, 14)
    		inner join App_VirtualApp vapp
        	on vapp.id = vr.VappId
        	and vapp.operationType = 16
        	and vapp.id != @vappId
	   end
       declare @sourceServer table
       (
                     sourceServer  nvarchar(1024),
                     destServer      nvarchar(1024),
					 nics			xml
       )
        insert into @sourceServer
       select ref.value('@sourceServer', 'nvarchar(1024)'), ref.value('@destinationServer', 'nvarchar(1024)'), ref.query('restoreOption/nics')
                     FROM @vAppXml.nodes ('Api_VirtualAppReq/vApp/arrayReplication/server') R(ref)
        update LS
       set sourceESXServer = T.SourcePath,
          lastSyncedBkpJob = T.MasterJobId,
		  vmsyncjobid = T.LastSyncJobId
       from #livesync_InfoTable  LS
       inner join ( select map.ClientId as sourceclientid, vm.MasterJobId , vm.sourcepath, map.LastSyncJobId
					from ( select clientid, max(lastsyncjobid) lastsyncjobid, replicacopyid from
						   SMVMReplicationMap
						   where replicacopyid = @copyId
						   group by clientid, replicacopyid ) map
					inner join smvolume vm
					on vm.CopyId = @copyid
					and vm.jobid = map.lastsyncjobid
					and map.ReplicaCopyId = @copyid
                                                ) T
       on LS.sourceClientId = T.sourceClientId
	  update LS
	  set sourceESXServer = vmprop.attrVal
	  from #livesync_InfoTable LS
	  inner join app_vmprop vmprop
	  on LS.sourceClientId = vmprop.vmclientId
	  and vmprop.jobid = LS.lastSyncedBkpJob
	  and vmprop.attrname = 'vmHost'
	   if ( @subclientId = 0)
	   begin
		   update LS
		   set subclientId = j.appid ,
			   instid = a.instance
		   from #livesync_InfoTable LS
		   inner join jmbkpstats j
		   on ls.lastSyncedBkpJob = j.jobid
		   inner join app_application a
		   on j.appid = a.id
	   end
       update LS
       set destESXServer = destServer,
	   nics = S.nics
       from #livesync_InfoTable LS
       inner join @sourceServer S
       on LS.sourceESXServer = S.sourceServer
	  update LS
	  set vmToolsinstalled =1
	  from #livesync_InfoTable LS
	  inner join App_Clientprop vmprop
	  on LS.sourceClientId = vmprop.componentNameid
	  and vmprop.attrname = 'Virtual Machine Tools Version'
	  and vmprop.modified = 0
	  and vmprop.attrval  not in ('Not installed','')
	   declare @taskId int
	   declare @subTaskId int
	   declare @subTaskName nvarchar(1024)
		SELECT  @taskId=  TA.taskId,  @subTaskId = TS.subTaskId , @subTaskName = TS.subTaskName
		FROM    TM_AssocEntity TA
		join  TM_Task T on TA.taskId = T.taskId
		join  TM_Subtask TS on TS.taskId = TS.taskId
		where TA.copyId = @copyId and TS.operationType = 4003
		and T.taskType = 4
		-- on failover, this will be the master job that is used for mounting the datastores
		declare @mountJobId int
		select @mountJobId = attrval
		from App_VirtualAppprop
		where componentNameId = @vappId
		and attrName ='Mount Snap DR Job'
			IF OBJECT_ID('tempdb.dbo.#testVMList') IS NOT NULL DROP TABLE #testVMList
			CREATE TABLE #testVMList
			(
				replicationId int, proxyVMName nvarchar(256), proxyVMGuid nvarchar(256), testFailoverstatus int, jobxml xml, drTestFailoverJobid int, drTestFailoverJobStatus int,
				 drUndoTestFailoverJobId int, drUndoTestFailoverStatus int)
			insert into #testVMList (replicationId)
			select replicationid from #livesync_InfoTable
			update VM
			set drTestFailoverJobid = t.mountJobId,
			    drUndoTestFailoverJobId = t.unmountJobid
			from #testVMList VM
			inner join   (  select aj.replicationid,
								  max(case when phase = 38 and status!=8 then aj.jobid else 0 end) as mountJobId,
          max(case when phase = 39 then aj.jobid else 0 end) as unmountJobid
          from App_VirtualAppJobStats aj
			                inner join #testVMList vm
							on aj.replicationId = vm.replicationId
							and aj.vappId = @vappId
      where phase in ( 34, 38, 39)
							group by aj.replicationId
						 ) t
			on VM.replicationId = t.replicationId
			update VM
			set drTestFailoverJobStatus = AJ.status
			from #testVMList vm
			inner join App_VirtualAppJobStats AJ
			on vm.replicationId = AJ.replicationId
			and vm.drTestFailoverJobid = AJ.jobId
			and AJ.phase = 41
			update VM
			set jobxml = details
			from #testVMList vm
			inner join App_VirtualAppJobStats AJ
			on vm.replicationId = AJ.replicationId
			and vm.drTestFailoverJobid = AJ.jobId
			and AJ.phase = 38
			update VM
			set
				drUndoTestFailoverStatus = AJ.status
			from #testVMList vm
			inner join App_VirtualAppJobStats AJ
			on vm.replicationId = AJ.replicationId
			and vm.drUndoTestFailoverJobId = AJ.jobId
			and AJ.phase = 39
			delete from #testVMList
			where drUndoTestFailoverStatus =0 and drUndoTestFailoverJobId  > drTestFailoverJobid
			update #testVMList
			set testfailoverstatus =case when drUndoTestFailoverStatus =2 then 4
			         when drUndoTestFailoverStatus =1 then 5 end
			where drUndoTestFailoverJobId >0
			and drUndoTestFailoverJobId > drTestFailoverJobid
			update #testVMList
			set testfailoverstatus =case when drTestFailoverJobStatus =2 then 2
			         when drTestFailoverJobStatus = 0 then 1
					 when drTestFailoverJobStatus = 1 then 3
					 end
			where isnull(drUndoTestFailoverJobId,0) < drTestFailoverJobid
			update TMlist
			set testFailoverstatus = VA.TestFailoverStatus
			from #testVMList TMList
			inner join App_VirtualAppReplication VA
			on TMList.replicationId = VA.ReplicationId
			and VA.VappId = @vappId
  declare @vmmountjobs table
  (
   clientid int,
   jobid int,
   repid int,
   mountjobid int,
   vmmountjobs xml
  )
  insert into @vmmountjobs
  select rep.ClientId,  max(jobid), rep.ReplicationId, 0, null from App_VirtualAppJobStats j
  inner join App_VirtualAppReplication rep
  on j.replicationId = rep.ReplicationId
  and rep.VappId = j.vappId
  where j.vappid = @vappId
  and phase in ( 34, 38)
  and status =0
  group by rep.clientid, rep.ReplicationId
  update vmj
  set vmmountjobs = details
  from @vmmountjobs vmj
  inner join App_VirtualAppJobStats aj
  on vmj.jobid = aj.jobid
  and aj.phase in ( 34, 38)
  and vmj.repid = aj.replicationId
  update @vmmountjobs set mountjobid = vmmountjobs.value('(/Api_VirtualAppPhaseInfo/job/@jobid)[1]', 'int')
			update #testVMList
			set proxyVMName = jobxml.value('(/Api_VirtualAppPhaseInfo/job/entity/@newName)[1]', 'nvarchar(256)'),
			    proxyVMGUid = jobxml.value('(/Api_VirtualAppPhaseInfo/job/entity/@GUID)[1]', 'nvarchar(256)')
			from #testVMList vm
			IF OBJECT_ID('tempdb.dbo.#vmMountInfo') IS NOT NULL DROP TABLE #vmMountInfo
			CREATE TABLE #vmMountInfo
			(
				 clientId int,
				 archFileId int,
				 jobid int,
				 appid int,
				 mountstatus int,
				 mounthostid int
			)
		    insert into #vmMountInfo
			select distinct OriginClientId,
					archFileid,
					svm.jobId,
					appId,
					MountStatus,
					MountHostId
			from SMVolume svm
			inner join #livesync_InfoTable ls
			on svm.masterJobId = ls.lastSyncedBkpJob  and copyid = @copyId
			and PruneFlags = 1
       declare @vmipaddressoption table
       (
                     repid int,
					 ipoption			xml,
					 destComputerName  nvarchar(256)
       )
       insert into @vmipaddressoption
       select ref.value('@replicationId', 'int'), replace(cast(ref.query('vmStaticIPAddressOptions') as nvarchar(max)),'vmStaticIPAddressOptions', 'vmIPAddressOptions'),
					isnull(ref.value('@destComputerName','nvarchar(256)'), '')
                     FROM @vAppXml.nodes ('Api_VirtualAppReq/vApp/config/vmGroups/vmSequence') R(ref)
	   update LS
       set ipaddressoption = ipoption,
		   destComputerName = S.destComputerName
       from #livesync_InfoTable LS
       inner join @vmipaddressoption S
       on LS.replicationId = S.repid
	declare @vmfailurereason table
	(
		repid int,
		failureReason xml
	)
   insert into @vmfailurereason
   select  ReplicationId, details
   from (
	  select  rep.ReplicationId,  row_number() over ( partition by  j.replicationid order by endtime desc) as rn , details from App_VirtualAppJobStats j
	  inner join App_VirtualAppReplication rep
	  on j.replicationId = rep.ReplicationId
	  and rep.VappId = j.vappId
	  where j.vappid = @vappId	)T
  	where T.rn =1
	update LS
	set lastfailureReason = VF.failureReason.value('(Api_VirtualAppPhaseInfo/job/failure/@errorMessage)[1]','nvarchar(1024)')
	from #livesync_InfoTable LS
	inner join @vmfailurereason VF
	on LS.replicationId = VF.repid
	update LS
	set isindexingv2 = 1
	from #livesync_InfoTable LS
	inner join App_Clientprop cp
	ON ls.sourceClientId = CP.componentNameId
	and cp.attrname ='IndexingV2_VSA'
	and cp.modified =0
	and cp.attrVal ='1'
	-- FORM THE XML RESPONSE
		SET @o_xmlString =
				(
                                   SELECT INFO.replicationId '@replicationId',  INFO.failoverStatus '@failoverStatus', INFO.lastSyncedBkpJob '@lastSyncedBkpJob', INFO.sourceClientId as '@clientId', INFO.sourceName '@sourceName',
                                  INFO.sourceGUID '@sourceGuid', INFO.destName '@destinationName', Info.destGUID '@destinationGuid',
                                  @copyId '@copyId',
								  vmToolsinstalled '@vmToolsinstalled',
								  VM.proxyVMName as '@proxyVMName',
								  VM.proxyVMGuid as '@proxyVMGuid',
								  info.isindexingv2 AS '@isIndexingV2',
								  INFO.lastfailureReason as '@lastReplicationJobFailureReason',
								  ISNULL(INFO.testFailoverstatus,0) as '@testFailoverStatus',
                                    ccId 'source/@commCellId',  INFO.subclientId 'source/@subclientId', INFO.instId 'source/@instanceId',
                                  INFO.instanceName 'source/@instanceName',   INFO.ccId 'source/@clientId', INFO.clientName 'source/@clientName',
                    			  INFO.destClientId 'destination/@clientId', C.name 'destination/@clientName', C.displayName 'destination/@displayName', INFO.destInstanceId 'destination/@instanceId', I.name 'destination/@instanceName',
                                  @taskId 'subTask/@taskId',
								  @subTaskId 'subTask/@subtaskId', @subTaskName 'subTask/@subtaskName',
         						  isnull(vmj.mountjobid,@mountJobId) 'associatedJobs/@jobId', 59 'associatedJobs/@jobType',
                                  ( select INFO.destESXServer as '@esxHost',
										   INFO.destComputerName as '@destComputerName',
										    isnull(ipaddressoption, '')  ,
											isnull(INFO.nics,'')
                                    for xml path('restoreOption'), type),
									(   select
										clientid as '@ulClientId',
										appId as '@ulAppId',
										archFileid as '@ulArchiveFileId',
										mountStatus as '@mountStatus',
										mountHostId as '@mountHostId',
										INFO.sourceName as '@strVMName',
										INFO.sourceGUID as '@strVMGuid',
										jobid as '@ulsnapJobId'
										from #vmMountInfo mountInfo
										where mountInfo.clientId = INFO.sourceClientId
										for xml path ('mountInfo'), TYPE
										),
                                                       (  select DMAP.id as '@id' ,
							  	 DMAP.PairID as '@pairId',
								 DMAP.replicaGroupId as '@replicaGroupId',
								 RelationshipStatus as '@relationshipStatus',
                                                                  Ds1.DSGuid as 'source/@strDatastoreUUID',
                                                                        Ds1.DSName as 'source/@strDatastorename',
                                                                  Ds2.DSGuid as 'destination/@strDatastoreUUID',
                                                                        Ds2.DSName as 'destination/@strDatastorename',
																		Ds2.VolumeName as 'destinationVolume/@sName',
																	Ds2.ArrayNum as 'destinationVolume/@arrayNumber'
                                                              from SMVMReplicationMap DMAP
                                                           inner join smvmdatastore DS1
                                                              on DS1.id = DMAP.SourceDatastoreId
                                                              and DMAP.clientId = INFO.sourceClientId
                                                           inner join smvmdatastore DS2
                                                              on DS2.id = DMAP.DestinationDatastoreId
															  and dmap.LastSyncJobId = INFO.vmsyncjobid
                                                              for xml path('datastore'), TYPE
                                                              )
					FROM #livesync_InfoTable INFO
					JOIN APP_Client C (NOLOCK) ON C.id = INFO.destClientId
					LEFT OUTER JOIN APP_InstanceName I (NOLOCK) ON I.id = INFO.destInstanceId
					LEFT JOIN #testVMList VM
					on VM.replicationId = INFO.replicationId
    				left join @vmmountjobs vmj
    				on vmj.clientid = INFO.sourceClientId
					FOR XML PATH('siteInfo'),
                                  ROOT('Api_GetSnapDRReplicationResp')
				)
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), TYPE)
	IF @o_xmlString IS NULL
              SET @o_xmlString = '<Api_GetSnapDRReplicationResp/>'
		SELECT @o_xmlString AS o_xmlString
	IF object_id('tempdb.dbo.#livesync_InfoTable') is not null
		DROP TABLE #livesync_InfoTable
	IF object_id('tempdb.dbo.#livesync_PropTable') is not null
		drop table #livesync_PropTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSnapDRReplicationInfo')
	delete from GxQscripts where name = 'AppGetSnapDRReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSnapDRReplicationInfo')
	delete from GXDBVersions where aliasname = 'AppGetSnapDRReplicationInfo'
GO

insert into GXDBVersions values(2, 'AppGetSnapDRReplicationInfo',  '00000000000000000000', 'AppGetSnapDRReplicationInfo', '00000000000000000000')
GO

