

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSnapDRArchiveFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppGetSnapDRArchiveFiles						|
--	|		 Procedure to get snap replication DR information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSnapDRArchiveFiles')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSnapDRArchiveFiles <<<'
	drop procedure AppGetSnapDRArchiveFiles
END
IF EXISTS (select * from GxQscripts where name='AppGetSnapDRArchiveFiles')
	delete from GxQscripts where name = 'AppGetSnapDRArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSnapDRArchiveFiles')
	delete from GXDBVersions where aliasname = 'AppGetSnapDRArchiveFiles'
GO
print '... Creating Procedure: AppGetSnapDRArchiveFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSnapDRArchiveFiles
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_subclientId integer,
  @i_copyId integer,
  @i_reqxml XML
-----------------------------------------------------------
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @o_masterJobId INTEGER;
  DECLARE @o_vmName nvarchar(510);
  DECLARE @o_afileId INTEGER;
  DECLARE @o_jobId INTEGER;
  DECLARE @o_vmClientId INTEGER;
  DECLARE @o_vmGuid nvarchar(510);
  DECLARE @o_vmAppId INTEGER;
  DECLARE @o_mountStatus INTEGER;
  DECLARE @o_mountHostId INTEGER;
  DECLARE @o_isFailoverMount INTEGER;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
declare @jobids table
(
	masterJobId int
)
insert into @jobids
select ref.value('@val', 'int')
from @i_reqxml.nodes('Api_GetSnapDRAfiles/jobIds') R(ref)
declare @masterJobId  int
declare @isMountOperation int
set @isMountOperation = isnull(@i_reqxml.value('Api_GetSnapDRAfiles[1]/@isMountOperation', 'int'),1)
select @masterjobid = max(masterJobId) from SMVolume with (nolock) where appid =  @i_subclientId and copyid = @i_copyId and ( @isMountOperation =0 or PruneFlags = 1 )
if not exists ( select 1 from @jobids)
insert into @jobids select @masterjobid
set @masterJobId = (select max(masterjobid) as masterjobid from @jobids )
if ( @isMountOperation =0 )
begin
select distinct svm.MasterJobId as masterJobId,
        sourcedevice as VM,
		svm.archFileid,
		svm.jobId,
		OriginClientId as VMClientId,
		SourceGUID as VMGuid,
		appId as VMAppId,
		MountStatus,
		MountHostId,
		case when snap.flags is null then 0 else snap.flags & 512 end as isFailoverMount
from SMVolume svm with (nolock)
left join SMSnapResource snap with (nolock)
on svm.SMVolumeId = snap.SMVolumeId
where svm.masterJobId = @masterJobId  and copyid = @i_copyId and svm.jobid != @masterJobId
end
else
begin
select distinct svm.MasterJobId as masterJobId,
        sourcedevice as VM,
		svm.archFileid,
		svm.jobId,
		OriginClientId as VMClientId,
		SourceGUID as VMGuid,
		appId as VMAppId,
		MountStatus,
		MountHostId,
		case when snap.flags is null then 0 else snap.flags & 512 end as isFailoverMount
from SMVolume svm with (nolock)
inner join archFileCopy ac with (nolock)
on  ac.archCopyId = @i_copyId
and ac.isValid =1
left join SMSnapResource snap with (nolock)
on svm.SMVolumeId = snap.SMVolumeId
where svm.masterJobId = @masterJobId  and copyid = @i_copyId and svm.jobid != @masterJobId
and  PruneFlags = 1
end
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSnapDRArchiveFiles')
	delete from GxQscripts where name = 'AppGetSnapDRArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSnapDRArchiveFiles')
	delete from GXDBVersions where aliasname = 'AppGetSnapDRArchiveFiles'
GO

insert into GXDBVersions values(2, 'AppGetSnapDRArchiveFiles',  '00000000000000000000', 'AppGetSnapDRArchiveFiles', '00000000000000000000')
GO

