

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSmartNWTopologyOutGoingRoutes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual OR intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSmartNWTopologyOutGoingRoutes')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSmartNWTopologyOutGoingRoutes <<<'
	drop procedure AppGetSmartNWTopologyOutGoingRoutes
END
IF EXISTS (select * from GxQscripts where name='AppGetSmartNWTopologyOutGoingRoutes')
	delete from GxQscripts where name = 'AppGetSmartNWTopologyOutGoingRoutes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSmartNWTopologyOutGoingRoutes')
	delete from GXDBVersions where aliasname = 'AppGetSmartNWTopologyOutGoingRoutes'
GO
print '... Creating Procedure: AppGetSmartNWTopologyOutGoingRoutes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSmartNWTopologyOutGoingRoutes
  @clientId INTEGER
AS
  DECLARE @o_remoteClientId INTEGER
  DECLARE @o_fwOutGoingRouteOptions XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isPartOfSmartNetworkTopology INTEGER  = 0
EXEC IsClientPartOfSmartNetworkTopology @clientId, @isPartOfSmartNetworkTopology OUTPUT
IF @isPartOfSmartNetworkTopology IS NULL OR @isPartOfSmartNetworkTopology = 0
	RETURN
-- Topology Association : Table containing smart topology AND its associated groups along with useWildcardProxy option
IF OBJECT_ID('tempdb..#topoAssoc') IS NOT NULL
	DROP TABLE #topoAssoc
CREATE TABLE #topoAssoc
(
	topologyId INT,
	topologyType INT,
	useWildcardProxy INT,
	internalGrp INT,
	externalGrp INT,
	proxyGrp INT,
	perimeterProxyGroup INT,
	encryptTraffic	INT,
	connectionProtocol INT,
	numberOfStreams INT
	PRIMARY KEY (topologyId)
)
-- Insert topology associations
INSERT INTO #topoAssoc (topologyId, topologyType, useWildcardProxy, internalGrp, externalGrp, proxyGrp, perimeterProxyGroup, encryptTraffic, connectionProtocol, numberOfStreams)
SELECT TopoAssoc.topologyId
	, AFT.topologyType
	, CASE WHEN O.clientGroupId IS NULL THEN 0 ELSE O.useWildcardProxy END useWildcardProxy
	,TopoAssoc.internalGrp
	,TopoAssoc.externalGrp
	,ISNULL(TopoAssoc.proxyGrp,0)
	, ISNULL(TopoAssoc.perimeterProxyGroup, 0)
	, ISNULL(AFT.extendedProperties.value('(/App_TopologyExtendedProperties/@encryptTraffic)[1]','int'), 0)
, ISNULL(AFT.extendedProperties.value('(/App_TopologyExtendedProperties/@connectionProtocol)[1]','int'), 2)
	, ISNULL(AFT.extendedProperties.value('(/App_TopologyExtendedProperties/@numberOfStreams)[1]','int'), 1)
FROM
(
SELECT topologyId, MAX(CASE WHEN fwGroupType = 1 THEN groupId ELSE -2147483648 END) internalGrp,
MAX(CASE WHEN fwGroupType = 2 THEN groupId ELSE -2147483648 END) externalGrp,
MAX(CASE WHEN fwGroupType = 3 THEN groupId ELSE -2147483648 END) proxyGrp,
MAX(CASE WHEN fwGroupType = 4 THEN groupId ELSE -2147483648 END) perimeterProxyGroup
	FROM APP_FirewallTopologyAssoc group by topologyId
) TopoAssoc
INNER JOIN APP_FirewallTopology AFT ON TopoAssoc.topologyId = AFT.topologyId AND AFT.flag & 1 = 1
LEFT JOIN
(
SELECT clientGroupId, ISNULL(EP.extendedProps.value('./@useWildcardProxy','INT'),0) useWildcardProxy FROM APP_FirewallOptions AFO
CROSS APPLY AFO.extendedProperties.nodes('App_FirewallExtendedProperties') EP(extendedProps)
)O(clientGroupId, useWildcardProxy) ON TopoAssoc.externalGrp = O.clientGroupId
IF OBJECT_ID('tempdb..#tempTbl') IS NOT NULL
	DROP TABLE #tempTbl
CREATE TABLE #tempTbl
(
	topologyId INT,
	topologyType INT,
	useWildcardProxy INT,
	internalClientId INT,
	externalClientId INT,
	proxyClientGroupId INT,
	perimeterProxyClientGroupId INT,
	encryptTraffic INT,
	connectionProtocol INT,
	numberOfStreams INT
)
CREATE CLUSTERED INDEX Idx_tempTbl_externalClientId ON #tempTbl(externalClientId)
CREATE NONCLUSTERED INDEX Idx_tempTbl_internalClientId ON #tempTbl(internalClientId)
-- Expand non-mnemonic client group IN [@topoAssoc.externalGrp, #topoAssoc.internalGrp] to clientIds. Leave the mnemonic as IS. We will use the clientIds as context to get their mediaAgents.
INSERT INTO #tempTbl (topologyId, topologyType, useWildcardProxy, internalClientId, externalClientId, proxyClientGroupId, perimeterProxyClientGroupId, encryptTraffic, connectionProtocol, numberOfStreams)
SELECT TA.topologyId
,TA.topologyType
,TA.useWildcardProxy
,CASE WHEN ACGA.clientId IS NULL THEN CASE WHEN internalGrp < 0 THEN internalGrp ELSE 0 END ELSE ACGA.clientId END internalClientId
,CASE WHEN ACGA1.clientId IS NULL THEN CASE WHEN externalGrp < 0 THEN externalGrp ELSE 0 END ELSE ACGA1.clientId END externalClientId
,TA.proxyGrp proxyClientGroupId
,TA.perimeterProxyGroup perimeterProxyClientGroupId
,TA.encryptTraffic
,TA.connectionProtocol
,TA.numberOfStreams
FROM #topoAssoc TA
LEFT JOIN APP_ClientGroupAssoc ACGA ON TA.internalGrp = ACGA.clientGroupId
LEFT JOIN APP_ClientGroupAssoc ACGA1 ON TA.externalGrp = ACGA1.clientGroupId
--
--Get all clients for the mnemonic client group using the non-mnemonic group
--
--Code Below Here is From AppGetClientMediaAgentMap.spb
BEGIN
	IF OBJECT_ID('tempdb.dbo.#ClientMediaAgentMap') IS NOT NULL
		DROP TABLE #ClientMediaAgentMap
	CREATE TABLE #ClientMediaAgentMap
	(
		clientId INT,
		mediaAgentId INT,
		PRIMARY KEY(clientId,mediaAgentId)
	);
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL DROP TABLE #lt_Clients
	CREATE TABLE #lt_Clients
	(
		clientId	INT
		PRIMARY KEY(clientId)
	)
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL
		DROP TABLE #tempArchGrp
	CREATE TABLE #tempArchGrp
	(
		clientId	INT,
		archGroupId	INT,
		primaryCopyId smallint,
		primarySnapCopyId smallint
	)
	CREATE CLUSTERED INDEX  tempArchGrp_idx1 ON #tempArchGrp(primaryCopyId)
	CREATE NONCLUSTERED INDEX  tempArchGrp_idx2 ON #tempArchGrp(primarySnapCopyId, clientId)
DECLARE @cs_assocPlan INT = checksum('Associated Plan')
	-- Get all index servers
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
						(     serverURL NVARCHAR(512),
								clientId INT,
								clientName NVARCHAR(256),
								cloudId INT,
								hostName NVARCHAR(256),
								basePort INT,
								engineName  NVARCHAR(256),
								serverType INT,
								indexServerClientId INT,
								internalCloudName NVARCHAR(256)
						)
	EXEC DM2GetIndexServers
	-- Get Source Clients
		INSERT 	INTO #lt_Clients
		SELECT	CN.id
		FROM	App_Client CN WITH(READUNCOMMITTED)
		INNER JOIN #tempTbl T ON
		T.internalClientId > 0 AND CN.id=T.internalClientId
		WHERE CN.id > 1
		UNION
		SELECT CN.id
		FROM App_Client CN WITH(READUNCOMMITTED)
		INNER JOIN #tempTbl T ON
		T.externalClientId > 0 AND CN.id=T.externalClientId
		WHERE CN.id > 1
	--
	--Find destination clients
	--
	IF @@ROWCOUNT > 0
	BEGIN
		-- Get all the storage policies
		INSERT INTO #tempArchGrp
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.dataArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		UNION
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.logArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		--Get client to infrastructure map
		INSERT INTO #ClientMediaAgentMap
		-- MediaAgents
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primarySnapCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		-- DDB Engines
		SELECT 	TA.clientId, SS.clientId
		FROM 	#tempArchGrp TA,
				archCopySIDBStore CPS WITH(READUNCOMMITTED),
				IdxSIDBStore S WITH(READUNCOMMITTED),
				IdxSIDBSubStore SS WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = CPS.copyId
				AND CPS.SIDBStoreId = S.SIDBStoreId
				AND S.sealedTime = 0 --ActiveStores
				AND S.SIDBStoreId = SS.SIDBStoreId
		UNION
		-- IndexServers: Exchange
		SELECT 	CN.clientId, S.clientId
		FROM 	#lt_Clients CN,
				APP_IDAName IDN WITH(READUNCOMMITTED),
				App_IdaProp IP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = IDN.clientId
				AND IP.componentNameId = IDN.ID
				AND IP.attrName = 'OnePass Index Server'
				AND IP.modified = 0
				AND S.indexServerClientId = CAST (IP.AttrVal AS INT)
		UNION
		-- IndexServers: Edge
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_EdgeDriveAssociation EDGE WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = EDGE.clientId
AND S.indexServerClientId = EDGE.entityId AND EDGE.entityType = 3
		UNION
		-- IndexServers: Edge Laptop clients
		SELECT	CN.clientId, EDW.webserverId
		FROM 	#lt_Clients CN
				INNER JOIN App_Client CL  WITH(READUNCOMMITTED) ON CN.clientId = CL.id
				INNER JOIN App_SyncCloudConfig SC  WITH(READUNCOMMITTED) ON CL.id = SC.clientId
				INNER JOIN App_SyncCloudFolder SF  WITH(READUNCOMMITTED) ON SC.syncWebFolderId = SF.syncWebFolderId
				INNER JOIN APP_Application APP  WITH(READUNCOMMITTED) ON APP.id = SC.subclientId
				INNER JOIN AppEdgeDriveWebserverAssociation EDW  WITH(READUNCOMMITTED) ON EDW.edgeClientId = APP.clientId
WHERE 	CL.status & 0x1000 > 0
AND SF.flag &  0x10 > 0
AND APP.subclientStatus & 0x20000 > 0
		UNION
		-- IndexServers: FileSystem
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_Application APP WITH(READUNCOMMITTED),
				App_IndexDBInfo idx WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	CN.clientId = APP.clientId
				AND idx.backupSetId = APP.backupSet
				AND S.indexServerClientId = idx.currentIdxServer
		UNION
		-- IndexServers: Plan VSA
		SELECT  T.clientId, S.clientId
		FROM  	(
					SELECT 	CN.clientId, CAST(CP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_clientProp CP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = CP.componentNameId
AND CP.attrName = 'Associated Plan'
							AND CP.modified = 0
					UNION
					SELECT 	CN.clientId, CAST(SCP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_Application SC WITH(READUNCOMMITTED),
							App_SubclientProp SCP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = SC.clientId
							AND SCP.componentNameId = SC.id
							AND SCP.cs_attrName = @cs_assocPlan
AND SCP.attrName = 'Associated Plan'
							AND SCP.modified = 0
				) AS T,
				App_PlanProp PROP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	PROP.componentNameId = T.PlanId
				AND PROP.attrName = 'Analytics Index Server Id'
				AND PROP.modified = 0
				AND S.indexServerClientId = CAST (PROP.AttrVal AS INT)
		UNION
		-- Remote SoftwareCache: Client Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_clientProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CP.componentNameId
				AND CP.attrName = N'UPDATE CACHE AGENT ID'
				AND CP.modified = 0
				AND CAST(CP.attrVal AS INT) = UA.id
		UNION
		-- Remote SoftwareCache: ClientGroup Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_ClientGroupAssoc CGA WITH(READUNCOMMITTED),
				APP_ComponentProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CGA.clientId
				AND CGA.clientGroupId = CP.componentId
AND CP.componentType = 8
AND CP.propertyTypeId = 1300
				AND CP.modified = 0
				AND CP.longVal = UA.id
		--
		--Remove entries if source and dest are same
		--
		DELETE 	#ClientMediaAgentMap
		WHERE	clientId = mediaAgentId
		-- Remove entries for invalid MAs.
		-- Example: On deleting a DDB MA without deleting relevant partition info (feature introduced in SP19), a MA entry with clientid=1 (NOCLIENT) is used as a placeholder.
		-- Such MA ids are invalid for general processing
		DELETE 	#ClientMediaAgentMap
		WHERE	mediaAgentId < 2
	END
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL 			DROP TABLE #lt_Clients
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL 		DROP TABLE #tempArchGrp
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
IF OBJECT_ID('tempdb..#topoAssoc') IS NOT NULL
	DROP TABLE #topoAssoc
IF OBJECT_ID('tempdb..#tempTblAfterSub') IS NOT NULL
	DROP TABLE #tempTblAfterSub
CREATE TABLE #tempTblAfterSub
(
	topologyId INT,
	topologyType INT,
	useWildcardProxy INT,
	internalClientId INT,
	externalClientId INT,
	proxyClientGroupId INT,
	perimeterProxyClientGroupId INT,
	encryptTraffic INT,
	connectionProtocol INT,
	numberOfStreams INT
)
CREATE CLUSTERED INDEX Idx_tempTblAfterSub_proxyClientGroupId ON #tempTblAfterSub(proxyClientGroupId)
-- Substitute the mnemonic with required clientIds : Substituting mediaAgentIds FOR [My Media Agents(-2), My CommServe AND Media Agents(-3)].
INSERT INTO #tempTblAfterSub
SELECT topologyId,topologyType,useWildcardProxy,internalClientId,externalClientId,proxyClientGroupId, perimeterProxyClientGroupId, encryptTraffic, connectionProtocol, numberOfStreams FROM
(
	SELECT TBL.topologyId,
	TBL.topologyType,
	TBL.useWildcardProxy ,
	CASE WHEN TBL.internalClientId <0 THEN CMA.mediaAgentId ELSE TBL.internalClientId END internalClientId,
	CASE WHEN TBL.externalClientId <0 THEN CMA.mediaAgentId ELSE TBL.externalClientId END externalClientId,
	TBL.proxyClientGroupId,
	TBL.perimeterProxyClientGroupId,
	TBL.encryptTraffic,
	TBL.connectionProtocol,
	TBL.numberOfStreams
	FROM #tempTbl TBL
	LEFT JOIN #ClientMediaAgentMap CMA
	ON TBL.externalClientId = CMA.clientId AND (TBL.internalClientId IN (-2,-3))
	UNION
	SELECT TBL.topologyId,
	TBL.topologyType,
	TBL.useWildcardProxy ,
	CASE WHEN TBL.internalClientId <0 THEN CMA.mediaAgentId ELSE TBL.internalClientId END internalClientId,
	CASE WHEN TBL.externalClientId <0 THEN CMA.mediaAgentId ELSE TBL.externalClientId END externalClientId,
	TBL.proxyClientGroupId,
	TBL.perimeterProxyClientGroupId,
	TBL.encryptTraffic,
	TBL.connectionProtocol,
	TBL.numberOfStreams
	FROM #tempTbl TBL
	LEFT JOIN #ClientMediaAgentMap CMA
	ON TBL.internalClientId = CMA.clientId AND (TBL.externalClientId IN (-2,-3))
)M WHERE internalClientId IS NOT NULL AND externalClientId IS NOT NULL
IF OBJECT_ID('tempdb..#ClientMediaAgentMap') IS NOT NULL
	DROP TABLE #ClientMediaAgentMap
-- Substitute the mnemonic with required clientIds : Substituting csClientId(2) FOR [My CommServe(-2), My CommServe AND Media Agents(-3)].
INSERT INTO #tempTblAfterSub
SELECT TBL.topologyId
,TBL.topologyType
,TBL.useWildcardProxy
,CASE WHEN TBL.internalClientId <0 THEN 2 ELSE TBL.internalClientId END internalClientId
,CASE WHEN TBL.externalClientId <0 THEN 2 ELSE TBL.externalClientId END externalClientId
,TBL.proxyClientGroupId
,TBL.perimeterProxyClientGroupId
,TBL.encryptTraffic
,TBL.connectionProtocol
,TBL.numberOfStreams
FROM #tempTbl TBL WHERE TBL.externalClientId IN (-1,-3) OR TBL.internalClientId IN (-1,-3)
/*
Add code here FOR any new mnemoic. Use the #tempTbl AND INSERT entries INTO #tempTblAfterSub after substituting any new mnemonic with the required clientIds.
*/
DELETE #tempTblAfterSub WHERE internalClientId = externalClientId OR (internalClientId = 0 AND externalClientId = 0)
IF OBJECT_ID('tempdb.dbo.#fwOutGoingRoutesTable') IS NOT NULL
BEGIN
	-- If our client is part of a Cascading Proxy topology, we have to expand proxy and perimeter proxy groups to client level routes
	DECLARE @hasCascadingProxyTopologies INTEGER = 0
	IF EXISTS (
				SELECT TOP 1 *
				FROM #tempTblAfterSub TEMP
				LEFT JOIN App_ClientGroupAssoc ACGAP
				ON TEMP.proxyClientGroupId = ACGAP.clientGroupId
				LEFT JOIN App_ClientGroupAssoc ACGAPP
				ON TEMP.perimeterProxyClientGroupId = ACGAPP.clientGroupId
WHERE topologyType = 4 AND (externalClientId = @clientId OR internalClientId = @clientId OR ACGAP.clientId = @clientId OR ACGAPP.clientId = @clientId)
				)
		SET @hasCascadingProxyTopologies = 1
	-- When encryptTraffic is set on a topology, forceAlBackupRestoreDataTraffic for direct routes should be set to 1 to block extraports.
	INSERT INTO #fwOutGoingRoutesTable
	SELECT forClientId,CONVERT(XML,fwOutGoingRouteOptions) fwOutGoingRouteOptions FROM
	(
		-- Via-Proxy
		SELECT internalClientId clientId,externalClientId forClientId,(SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
		(SELECT proxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
		FROM #tempTblAfterSub TEMP
		INNER JOIN APP_ClientGroup ACG ON TEMP.proxyClientGroupId = ACG.id AND topologyType = 1
		UNION
		SELECT externalClientId,internalClientId,(SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
		(SELECT proxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
		FROM #tempTblAfterSub TEMP
		INNER JOIN APP_ClientGroup ACG ON TEMP.proxyClientGroupId = ACG.id AND topologyType = 1
		UNION
		SELECT internalClientId, ACGA.clientId, (SELECT TEMP.connectionProtocol AS '@connectionProtocol', TEMP.encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', TEMP.numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		FROM (SELECT distinct internalClientId,proxyClientGroupId,topologyType,topologyId, encryptTraffic, connectionProtocol, numberOfStreams FROM #tempTblAfterSub) TEMP
		INNER JOIN APP_ClientGroupAssoc ACGA ON ACGA.clientGroupId = TEMP.proxyClientGroupId AND topologyType = 1
		UNION
		SELECT externalClientId, ACGA.clientId, (SELECT TEMP.connectionProtocol AS '@connectionProtocol', TEMP.encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', TEMP.numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		FROM (SELECT distinct externalClientId,proxyClientGroupId,topologyType,topologyId, encryptTraffic, connectionProtocol, numberOfStreams FROM #tempTblAfterSub) TEMP
		INNER JOIN APP_ClientGroupAssoc ACGA ON ACGA.clientGroupId = TEMP.proxyClientGroupId AND topologyType = 1
		UNION
		-- One-way & Two-way
		SELECT externalClientId, internalClientId, (SELECT connectionProtocol AS '@connectionProtocol', encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		FROM #tempTblAfterSub
		WHERE (topologyType = 2 OR topologyType = 3)
		UNION
		SELECT internalClientId, externalClientId, (SELECT connectionProtocol AS '@connectionProtocol', encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		FROM #tempTblAfterSub
		WHERE topologyType = 3
		UNION
		-- Cascading Proxies Topology
		SELECT externalClientId,internalClientId,(SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
		(SELECT proxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
		FROM #tempTblAfterSub TEMP
INNER JOIN APP_ClientGroup ACG ON TEMP.proxyClientGroupId = ACG.id AND topologyType = 4
		UNION
		SELECT internalClientId ,externalClientId , (SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
		(SELECT perimeterProxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
		FROM #tempTblAfterSub TEMP
INNER JOIN APP_ClientGroup ACG ON TEMP.perimeterProxyClientGroupId = ACG.id AND topologyType = 4
	)K WHERE clientId = @clientId AND forClientId<>0
	IF @hasCascadingProxyTopologies=1
	BEGIN
		-- We need to populate routes between intermediate proxies in a cascading topology
		-- For that we need to expand Proxy and Perimeter Proxy groups
		IF OBJECT_ID('tempdb..#tempTblAfterProxySub') IS NOT NULL
			DROP TABLE #tempTblAfterProxySub
		CREATE TABLE #tempTblAfterProxySub
		(
			topologyId INT,
			topologyType INT,
			useWildcardProxy INT,
			internalClientId INT,
			externalClientId INT,
			proxyClientId INT,
			perimeterProxyClientId INT,
			proxyClientGroupId INT,
			perimeterProxyClientGroupId INT,
			encryptTraffic INT,
			connectionProtocol INT,
			numberOfStreams INT
		)
		INSERT INTO #tempTblAfterProxySub
		SELECT topologyId, topologyType, useWildcardProxy, internalClientId, externalClientId, ACGA.clientId, ACGAP.clientId, Sub.proxyClientGroupId, Sub.perimeterProxyClientGroupId, encryptTraffic, connectionProtocol, numberOfStreams
		FROM #tempTblAfterSub Sub
		LEFT JOIN APP_ClientGroupAssoc ACGA
		on Sub.proxyClientGroupId=ACGA.clientGroupId
		LEFT JOIN APP_ClientGroupAssoc ACGAP
		ON Sub.perimeterProxyClientGroupId=ACGAP.clientGroupId
		INSERT INTO #fwOutGoingRoutesTable
		SELECT forClientId,CONVERT(XML,fwOutGoingRouteOptions) fwOutGoingRouteOptions FROM
		(
			SELECT externalClientId clientId, perimeterProxyClientId forClientId,(SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
				(SELECT proxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
			FROM #tempTblAfterProxySub TEMP
INNER JOIN APP_ClientGroup ACG ON TEMP.proxyClientGroupId = ACG.id AND topologyType = 4
			UNION
			SELECT perimeterProxyClientId, externalClientId, (SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
				(SELECT proxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
			FROM #tempTblAfterProxySub TEMP
INNER JOIN APP_ClientGroup ACG ON TEMP.proxyClientGroupId = ACG.id AND topologyType = 4
			UNION
			SELECT proxyClientId, internalClientId, (SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
				(SELECT perimeterProxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
			FROM #tempTblAfterProxySub TEMP
INNER JOIN APP_ClientGroup ACG ON TEMP.perimeterProxyClientGroupId = ACG.id AND topologyType = 4
			UNION
			SELECT internalClientId, proxyClientId, (SELECT TEMP.connectionProtocol AS '@connectionProtocol',1 AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',2 AS '@routeType',
				(SELECT perimeterProxyClientGroupId AS '@clientGroupId',ACG.name AS '@clientGroupName' FOR XML PATH('remoteProxy'), TYPE) FOR XML PATH('App_FireWallOutGoingRouteOptions')) fwOutGoingRouteOptions
			FROM #tempTblAfterProxySub TEMP
INNER JOIN APP_ClientGroup ACG ON TEMP.perimeterProxyClientGroupId = ACG.id AND topologyType = 4
			UNION
			SELECT externalClientId, proxyClientId, (SELECT connectionProtocol AS '@connectionProtocol', encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
FROM #tempTblAfterProxySub WHERE topologyType = 4
			UNION
			SELECT proxyClientId, perimeterProxyClientId,  (SELECT connectionProtocol AS '@connectionProtocol', encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
FROM #tempTblAfterProxySub WHERE topologyType = 4
			UNION
			SELECT internalClientId, perimeterProxyClientId, (SELECT connectionProtocol AS '@connectionProtocol', encryptTraffic AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
FROM #tempTblAfterProxySub WHERE topologyType = 4
		)K WHERE clientId = @clientId AND forClientId<>0
		IF OBJECT_ID('tempdb..#tempTblAfterProxySub') IS NOT NULL
			DROP TABLE #tempTblAfterProxySub
	END
END
ELSE
BEGIN
	PRINT('ERROR : #fwOutGoingRoutesTable not passed as input temp table')
	RAISERROR('ERROR : #fwOutGoingRoutesTable not passed as input temp table',16,1)
END
IF OBJECT_ID('tempdb..#tempTblAfterSub') IS NOT NULL
	DROP TABLE #tempTblAfterSub
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'AppGetSmartNWTopologyOutGoingRoutes')
	delete from GxQscripts where name = 'AppGetSmartNWTopologyOutGoingRoutes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSmartNWTopologyOutGoingRoutes')
	delete from GXDBVersions where aliasname = 'AppGetSmartNWTopologyOutGoingRoutes'
GO

insert into GXDBVersions values(2, 'AppGetSmartNWTopologyOutGoingRoutes',  '00000000000000000000', 'AppGetSmartNWTopologyOutGoingRoutes', '00000000000000000000')
GO

