

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSmartFoldersForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ------------------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------------------*/
--	Description: sp to get the folders that a user can see
--  param: onlyFirstLevelFolders 1 to get folders in firstlevel (to populate below client group computers)based
--  param: folderType -to determine the type of folder(supported -  clientgroup,workflow)
/* ----------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSmartFoldersForUser')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSmartFoldersForUser <<<'
	drop procedure AppGetSmartFoldersForUser
END
IF EXISTS (select * from GxQscripts where name='AppGetSmartFoldersForUser')
	delete from GxQscripts where name = 'AppGetSmartFoldersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSmartFoldersForUser')
	delete from GXDBVersions where aliasname = 'AppGetSmartFoldersForUser'
GO
print '... Creating Procedure: AppGetSmartFoldersForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetSmartFoldersForUser
  @userId INT,
  @folderType INT,
  @onlyFirstLevelFolders INT,
  @o_responseXML XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#canSeefolderList') is not null
    DROP TABLE #canSeefolderList
CREATE TABLE #canSeefolderList (folderId INT NOT NULL)
IF object_id('tempdb.dbo.#cfolderList') is not null
    DROP TABLE #folderList
CREATE TABLE #folderList (folderId INT NOT NULL,ownerID INT,ownerName nvarchar(512))
	BEGIN
EXEC sec_getNonIdaObjectsForThisUser @userId, 127, 0, '#canSeefolderList'
		INSERT INTO #folderList(folderId)
		SELECT distinct folderId from #canSeeFolderList
		-- now filter the folders based on folder type
		DELETE folder
		FROM #folderList folder
		JOIN App_SmartFolder SF ON folder.folderId = SF.id
		WHERE SF.folderType <> @folderType
		-- get the corresponding higher level folders
		--if the folders are child folders
		;WITH Parent AS
		(
		  (SELECT folderId  FROM #folderList)
		  UNION ALL
		  (SELECT Assoc.folderId FROM APP_SmartFolderAssoc Assoc
INNER JOIN Parent ON Assoc.componentId = Parent.folderId AND Assoc.componenttype = 127)
		)
		INSERT INTO #folderList(folderId)
		SELECT distinct folderId FROM Parent
		--get the children recursively
		IF @onlyFirstLevelFolders=0
		BEGIN
    		;WITH CHILDREN AS
			 (
				(SELECT folderId  FROM #folderList)
				UNION ALL
(SELECT Assoc.componentId FROM App_SmartFolderAssoc Assoc INNER JOIN CHILDREN ON Assoc.folderId = CHILDREN.folderId AND Assoc.componenttype = 127)
			 )
			INSERT INTO #folderList(folderId)
			SELECT folderId FROM CHILDREN
		END
		;WITH temp AS
		(SELECT folderId, RN = ROW_NUMBER()
			OVER(PARTITION by folderId ORDER BY folderId)
			FROM #folderList
		)
		DELETE FROM temp WHERE RN>1
		UPDATE #folderList
set ownerId = (select creatorUserId from sec_getCreatorIdForEntity(127,folderId,0,0,0,0,0,0,0,0))
		UPDATE folder SET ownerName = login
		FROM #folderList folder
		INNER JOIN UMUsers on id = ownerId
	END
SET @o_responseXML = ISNULL((
    SELECT
    (   SELECT
                description as '@description' ,
                folderType as '@folderType',
                flag as '@flag',
                status as '@status',
				ownerName as '@ownerName',
                (SELECT id as '@smartFolderId',
                 name as '@smartFolderName',
127 as '@_type_'
                 FOR XML PATH('folderEntity'),type)
        FROM App_SmartFolder
		INNER JOIN #folderList
ON folderId=id  AND @folderType = folderType AND ((flag & 2)<>2 OR @onlyFirstLevelFolders=0)
		ORDER By name
        FOR XML PATH('folder'),TYPE
    )
    FOR XML PATH('App_SmartFoldersResp')
    ),'<App_SmartFoldersResp/>')
DROP TABLE #folderList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSmartFoldersForUser')
	delete from GxQscripts where name = 'AppGetSmartFoldersForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSmartFoldersForUser')
	delete from GXDBVersions where aliasname = 'AppGetSmartFoldersForUser'
GO

insert into GXDBVersions values(2, 'AppGetSmartFoldersForUser',  '00000000000000000000', 'AppGetSmartFoldersForUser', '00000000000000000000')
GO

