

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSharepointAzureProperties.sp] ---------- 

--ALLOW COMMENTS BELOW HERE!
----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Saiyam Goel
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSharepointAzureProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSharepointAzureProperties <<<'
	drop procedure AppGetSharepointAzureProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetSharepointAzureProperties')
	delete from GxQscripts where name = 'AppGetSharepointAzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSharepointAzureProperties')
	delete from GXDBVersions where aliasname = 'AppGetSharepointAzureProperties'
GO
print '... Creating Procedure: AppGetSharepointAzureProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSharepointAzureProperties
  @i_clientId INT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @backupsetId INT = 0
	DECLARE @sharepointAzureApps NVARCHAR(MAX) = NULL
	DECLARE @sharpointServiceAccounts NVARCHAR(MAX) = NULL
	DECLARE @sharepointMSCloudRegion INT
	DECLARE @sharepointTenantUrl NVARCHAR(MAX) = ''
SET @backupsetId = (SELECT TOP 1 backupSet from APP_Application (NOLOCK) where clientId = @i_clientId AND appTypeId = 78)
	IF @backupsetId <=0 OR @backupsetId = NULL
	BEGIN
		SET @errorString = 'ERROR : Invalid backupset Id'
		GOTO ERROR_EXIT
	END
	SET @sharpointServiceAccounts = (SELECT attrVal FROM APP_BackupSetProp (NOLOCK) WHERE componentNameId = @backupsetId AND attrName = 'Sharepoint Service Accounts' AND modified = 0 AND attrType = 1)
SET @sharepointMSCloudRegion = (SELECT attrVal FROM APP_BackupSetProp (NOLOCK) WHERE componentNameId = @backupsetId AND attrName = 'MSCloud Region Type' AND modified = 0 AND attrType = 7)
	SET @sharepointTenantUrl = (SELECT attrVal FROM APP_BackupSetProp (NOLOCK) WHERE componentNameId = @backupsetId AND attrName = 'SP Office365 Tenant Url' AND modified = 0 AND attrType = 1)
	IF @sharpointServiceAccounts IS NOT NULL
	SET @sharpointServiceAccounts =  REPLACE(@sharpointServiceAccounts,'App_SharepointServiceAccounts','serviceAccounts')
	SET @sharepointAzureApps = (SELECT attrVal FROM APP_BackupSetProp (NOLOCK) WHERE componentNameId = @backupsetId AND attrName = 'Sharepoint Azure Connections' AND modified = 0 AND attrType = 1)
	IF @sharepointAzureApps IS NOT NULL
	SET @sharepointAzureApps =  REPLACE(@sharepointAzureApps,'App_Office365AzureConnections','azureAppList')
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	SET @o_xmlString =
	(
		SELECT @sharepointMSCloudRegion '@cloudRegion',@sharepointTenantUrl '@tenantUrlItem',
		(
			SELECT CAST( REPLACE(@sharepointAzureApps,'encoding="utf-8"', 'encoding="utf-16"') AS XML)
		),
		(
			SELECT  CAST( REPLACE(@sharpointServiceAccounts,'encoding="utf-8"', 'encoding="utf-16"') AS XML)
		)
		FOR XML PATH('App_SpOffice365BackupSetProp')
	)
ERROR_EXIT:
	IF @o_xmlString IS NULL
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('App_SpOffice365BackupSetProp')
	)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSharepointAzureProperties')
	delete from GxQscripts where name = 'AppGetSharepointAzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSharepointAzureProperties')
	delete from GXDBVersions where aliasname = 'AppGetSharepointAzureProperties'
GO

insert into GXDBVersions values(2, 'AppGetSharepointAzureProperties',  '00000000000000000000', 'AppGetSharepointAzureProperties', '00000000000000000000')
GO

