

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSharePointOnPremClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--  +===================================================================================+
--  |   AppGetSharePointOnPremClients										            |
--  |   Procedure to get SharePoint OnPrem clients for SharePoint solution landing page |
--  +===================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSharePointOnPremClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSharePointOnPremClients <<<'
	drop procedure AppGetSharePointOnPremClients
END
IF EXISTS (select * from GxQscripts where name='AppGetSharePointOnPremClients')
	delete from GxQscripts where name = 'AppGetSharePointOnPremClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSharePointOnPremClients')
	delete from GXDBVersions where aliasname = 'AppGetSharePointOnPremClients'
GO
print '... Creating Procedure: AppGetSharePointOnPremClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSharePointOnPremClients
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @inOutXml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @i_userId INT = ISNULL((SELECT @inOutXml.value('(App_GetOffice365PseudoClientsReq/processinginstructioninfo/user/@userId)[1]', 'int')), 0)
	IF @i_userId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Invalid userId [0]'
			GOTO ERROR_EXIT
		END
	/*Security*/
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @i_userId, 6, 0 , 0,'#getIdaObjects', 0, '2, 20, 22, 13, 141, 25, 12, 253, 1, 16, 107'
	IF OBJECT_ID('tempdb.dbo.#tempSharePointOnPremClients') IS NOT NULL
		DROP TABLE #tempSharePointOnPremClients
	CREATE TABLE #tempSharePointOnPremClients
	(
		clientId INT,
		clientName NVARCHAR(255),
		displayName NVARCHAR(255),
		clientGUID NVARCHAR(255),
		backupsetId INT,
		backupsetName NVARCHAR(255),
		subclientId INT,
		subclientName NVARCHAR(255),
		planId INT,
		planName NVARCHAR(255),
		orgName NVARCHAR(255),
		backupsetType INT DEFAULT 0,
		isFarmClient INT DEFAULT 0,
		isDeletedClient INT DEFAULT 0,
		lastArchiveJobRanTime INT DEFAULT 0,
		numberOfItems BIGINT DEFAULT 0,
		applicationSize BIGINT DEFAULT 0,
		lastBkpJobInfo XML
	)
	CREATE CLUSTERED INDEX #Idx_tempSharePointOnPremClients_client_backupset_subclient_ids ON #tempSharePointOnPremClients(clientId, backupsetId, subclientId)
	BEGIN TRY
		/*Insert basic info*/
		INSERT INTO #tempSharePointOnPremClients (clientId, clientName, displayName, clientGUID, backupsetId, backupsetName, subclientId, subclientName, backupsetType)
		SELECT C.id, C.name, C.displayName, C.GUID, BK.id, BK.name, SC.id, SC.subclientName,
		(CASE
WHEN Bk.status & 0x0800 = 0x0800 THEN 1 /*Databases*/
WHEN Bk.status & 0x8000 = 0x8000 THEN 3 /*Site Collection*/
			ELSE 2 /*Documents (by default)*/
		END)
		FROM APP_Application(NOLOCK) SC
		INNER JOIN APP_Client(NOLOCK) C ON C.id = SC.clientId
		INNER JOIN APP_BackupSetName(NOLOCK) BK ON SC.backupSet = BK.id
		INNER JOIN #getIdaObjects SO ON SO.backupsetId = BK.id
WHERE (SC.subclientStatus & 0x00004 != 0x00004) AND	SC.appTypeId = 78 AND (BK.status & 0x80000 <> 0x80000) AND (SC.subclientStatus & 0x00008  = 0x00008)
		AND BK.name <> 'Indexing BackupSet'
		/*Insert plan info*/
		UPDATE #tempSharePointOnPremClients
		SET planId = P.planId, planName = P.planName
		FROM (
			SELECT Sp.attrVal AS planId, Ap.name AS planName, T.backupsetId
			FROM #tempSharePointOnPremClients T
			INNER JOIN APP_Application (NOLOCK) SC ON T.backupsetId = SC.backupSet
			LEFT JOIN APP_SubClientProp (NOLOCK) SP ON SC.Id = SP.componentNameId
			LEFT JOIN APP_Plan (NOLOCK) AP  ON AP.id = SP.attrVal
			WHERE SP.attrName = 'Associated Plan' AND SP.modified = 0
		) P WHERE P.backupsetId = #tempSharePointOnPremClients.backupsetId
		/*Update farm clients status*/
		UPDATE #tempSharePointOnPremClients
		SET isFarmClient = ISNULL(attrVal, 0)
		FROM APP_ClientProp(NOLOCK)
		WHERE componentNameId = clientId AND attrName = 'SharePoint Farm Client' AND modified = 0
		/*Update deleted clients status*/
		UPDATE #tempSharePointOnPremClients
		SET isDeletedClient = ISNULL(attrVal, 0)
		FROM APP_ClientProp(NOLOCK)
		WHERE componentNameId = clientId AND attrName = 'PlatformDeleted 4' AND modified = 0
		/*Update last successful archive job ran time*/
		UPDATE #tempSharePointOnPremClients
		SET lastArchiveJobRanTime =  ISNULL(JT.jobRanTime, 0)
		FROM (
			SELECT MAX(servEndDate) AS jobRanTime, backupsetId
			FROM #tempSharePointOnPremClients T
			INNER JOIN APP_Application(NOLOCK) AA ON T.backupsetId = AA.backupSet
			INNER JOIN JMBkpStats J ON AA.id = J.appId
WHERE J.appType = 78 AND J.status IN (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/) AND J.opType = 4 /*Backup*/
			GROUP BY backupsetId
		) JT WHERE #tempSharePointOnPremClients.backupsetId = JT.backupsetId
		/*Update organization name based on backupsets*/
		UPDATE #tempSharePointOnPremClients
		SET orgName =  D.hostName
		FROM App_Application(NOLOCK) E
		JOIN UMSecurityAssociations(NOLOCK) S ON S.entityId4 = E.backupSet
		JOIN UMDSProviders(NOLOCK) D ON D.id = S.companyId
		WHERE E.backupSet = backupsetId AND S.companyId <> 0
		/*Update last backup job info*/
		Update #tempSharePointOnPremClients
		SET lastBkpJobInfo = IP.attrVal
		FROM App_Idaprop IP (NOLOCK)
		JOIN APP_IdaName I (NOLOCK) ON I.id = IP.componentNameId
		JOIN #tempSharePointOnPremClients T ON T.clientId = I.clientId
WHERE backupsetId = T.backupsetId AND I.appTypeId = 78 AND IP.attrname = 'Last Backup Job Info' AND IP.modified = 0
		/*Update application size*/
		UPDATE #tempSharePointOnPremClients
		SET applicationSize = S.appSize
		FROM
		(SELECT SUM(J.totalUncompBytes) AS appSize, T.backupsetId
		FROM #tempSharePointOnPremClients T
		INNER JOIN App_Application(NOLOCK) A ON T.backupsetId = A.backupSet
		INNER JOIN JMBkpStats(NOLOCK) J ON A.id = J.appId
WHERE A.appTypeId = 78 AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
		AND J.status IN (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
		GROUP BY T.backupsetId) S
		WHERE #tempSharePointOnPremClients.backupsetId = S.backupsetId
		/*Update number of items*/
		UPDATE #tempSharePointOnPremClients
		SET numberOfItems = I.numberOfItems
		FROM
		(SELECT COUNT(F.fileName) AS numberOfItems, T.backupsetId
		FROM #tempSharePointOnPremClients T
		INNER JOIN APP_Application(NOLOCK) A ON T.backupsetId = A.backupSet
		INNER JOIN App_scFilterFile(NOLOCK) F ON A.id = F.componentNameId
WHERE A.appTypeId = 78 AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
		AND F.type IN (21, 22, 23) AND (CAST(F.fileName AS XML)).value('EVGui_SharePointItem[1]/@objectType', 'INT') <> 1 /*Do not count default content*/
		GROUP BY T.backupsetId) I
		WHERE #tempSharePointOnPremClients.backupsetId = I.backupsetId
		DECLARE @clientList table(clientId int, clientName nvarchar(256), displayName nvarchar(256), clientGuid UNIQUEIDENTIFIER, clientType INT, isDeleted INT)
		INSERT INTO @clientList
		SELECT DISTINCT clientId, clientName, displayName, clientGUID, isFarmClient, isDeletedClient FROM #tempSharePointOnPremClients
DECLARE @commCellName NVARCHAR(256)
DECLARE @csGuid NVARCHAR(40)
			SELECT 	@commCellName = aliasName,
					@csGuid = csGUID
			FROM APP_CommCell(NOLOCK)
			WHERE id = 2
		SET @inOutXml = (SELECT
			(SELECT clientId AS '@clientId', clientName AS '@clientName', displayName AS '@displayName', clientGuid AS '@clientGUID', clientType AS '@o365PseudoClient', isDeleted AS '@isDeletedClient',
(SELECT @commCellName AS '@commCellName', @csGuid AS '@csGUID', 1 '@_type_' FOR XML PATH('commCell'),TYPE),
				(SELECT clientId as '@clientId', clientName as '@clientName', displayName as '@displayName' FOR XML PATH('client'), TYPE),
				(SELECT backupsetId as '@backupsetId', backupsetName as '@backupsetName', backupsetType AS '@sharepointBackupSetType', orgName as '@orgName', subclientId as '@subclientId',
				lastArchiveJobRanTime AS '@lastJobRanTime', applicationSize AS '@applicationSize', numberOfItems AS '@totalNumberOfItems',
					(SELECT s.n.query('.') FROM lastBkpJobInfo.nodes('lastBackupJobInfo') s(n)),
					(SELECT (SELECT
						planId as '@planId', planName as '@planName' FOR XML PATH('plan'), TYPE)
						FROM #tempSharePointOnPremClients
						WHERE clientId = C.clientId AND backupsetId = T.backupsetId
					FOR XML PATH ('o365Subclient'), TYPE)
				FROM #tempSharePointOnPremClients T WHERE T.clientId = C.clientId
				FOR XML PATH ('O365BackupSet'), TYPE)
			FROM @clientList C
			FOR XML PATH ('o365Client'), TYPE)
		FOR XML PATH ('App_Office365PseudoClientsResp'))
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
	ERROR_EXIT:
		IF @errorCode <> 0
			SET @inOutXml = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
									AS '@errorMessage' FOR XML PATH('App_Office365PseudoClientsResp'))
		IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
			DROP TABLE #getIdaObjects
		IF OBJECT_ID('tempdb.dbo.#tempSharePointOnPremClients') IS NOT NULL
			DROP TABLE #tempSharePointOnPremClients
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSharePointOnPremClients')
	delete from GxQscripts where name = 'AppGetSharePointOnPremClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSharePointOnPremClients')
	delete from GXDBVersions where aliasname = 'AppGetSharePointOnPremClients'
GO

insert into GXDBVersions values(2, 'AppGetSharePointOnPremClients',  '00000000000000000000', 'AppGetSharePointOnPremClients', '00000000000000000000')
GO

