

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSharePointMemberServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSharePointMemberServers <<<'

IF EXISTS (select * from sysobjects where name='AppGetSharePointMemberServers')
	drop procedure AppGetSharePointMemberServers
IF EXISTS (select * from GxQscripts where name='AppGetSharePointMemberServers')
	delete from GxQscripts where name = 'AppGetSharePointMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSharePointMemberServers')
	delete from GXDBVersions where aliasname = 'AppGetSharePointMemberServers'
GO
print '... Creating Procedure: AppGetSharePointMemberServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSharePointMemberServers
  @xmlText XML
AS
--INPUTS
DECLARE  @psuedoEntityId INTEGER
DECLARE  @psuedoEntityType INTEGER
DECLARE  @spVersion	INTEGER = 0
DECLARE  @spMemberServers XML
DECLARE	 @userId INTEGER =0
DECLARE	 @getOnlyMemberServers INTEGER = 0
SET @spMemberServers = @xmlText
SET @getOnlyMemberServers =  @xmlText.exist('/App_GetSPMemberServersRequest')
IF @getOnlyMemberServers = 1
BEGIN
	SET  @psuedoEntityType =(SELECT ISNULL(ref.value('entity[1]/@_type_', 'INTEGER'),0) FROM @spMemberServers.nodes('App_GetSPMemberServersRequest') R ( ref ))
	SET  @spVersion =(SELECT ISNULL(ref.value('@spVersion', 'INTEGER'),0) FROM @spMemberServers.nodes('App_GetSPMemberServersRequest') R ( ref ))
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
								  FROM    @xmlText.nodes('App_GetSPMemberServersRequest/processinginstructioninfo/user') R ( ref )),0)
END
ELSE
BEGIN
	SET  @psuedoEntityType = 0
END
--select @spMemberServers
DECLARE @EntityList TABLE ( priority INT IDENTITY, clientId INT, spVersion INT)
IF @psuedoEntityType = 0 AND  @getOnlyMemberServers = 0 -- EntityType_CLIENT_ENTITY
BEGIN
	SET @psuedoEntityId = ISNULL((SELECT  ref.value('@clientId', 'INTEGER')
      FROM    @xmlText.nodes('entity') R ( ref )),0)
	set @spMemberServers = (
		select
			cp.stringVal
		from App_ComponentProp cp WITH(NOLOCK)
		where
			cp.componentId = @psuedoEntityId
			and cp.componentType = 3			-- CV_COMPONENT_TYPE_CLIENT
			and cp.propertyTypeId = 1046		-- CV_COMPONENT_SHAREPOINT_SECONDARY_MEMBER_SERVERS		-- Old APP_ClientProp 'SharePoint Member Servers'
			and cp.modified = 0
	)
	INSERT INTO @EntityList
	SELECT
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		''
	FROM    @spMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
END
ELSE IF @psuedoEntityType = 4 -- EntityType_APPTYPE_ENTITY
BEGIN
	DECLARE @apptypeParam INT
	SELECT @apptypeParam = ISNULL(ref.value('entity[1]/@applicationId', 'INTEGER'),0)
			FROM    @spMemberServers.nodes('App_GetSPMemberServersRequest') R ( ref )
	IF @userId > 0
	BEGIN
		DECLARE @EntityIdList table (t_Id integer,t_Version integer)
		INSERT INTO @EntityIdList
		SELECT
		Ida.clientId,IdaProp.attrVal
		FROM	APP_iDAName Ida JOIN APP_IdaProp IdaProp
		on IdaProp.componentNameId = Ida.id
		WHERE	Ida.appTypeId = 78 AND (Ida.Status & 2) = 0 AND (Ida.Status & 4) = 0 and
		(IdaProp.modified = 0) and IdaProp.attrName = 'IDA Version'
		IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
create table  #tempUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 0, 0, '#tempUserObjects'
		delete #tempUserObjects
		WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
		  OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0  OR taskId <> 0
		  OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
		  OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
		  OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
		  OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
		INSERT INTO @EntityList
		SELECT distinct E.t_Id,E.t_Version
		FROM @EntityIdList E, #tempUserObjects T
		WHERE T.clientId in (0,E.t_Id)
		DROP TABLE #tempUserObjects
	END
END
ELSE IF @psuedoEntityType = 3 -- EntityType_CLIENT_ENTITY
BEGIN
	SELECT @psuedoEntityId = ISNULL(ref.value('entity[1]/@clientId', 'INTEGER'),0)
			FROM    @spMemberServers.nodes('App_GetSPMemberServersRequest') R ( ref )
	set @spMemberServers = (
		select
			cp.stringVal
		from App_ComponentProp cp WITH(NOLOCK)
		where
			cp.componentId = @psuedoEntityId
			and cp.componentType = 3			-- CV_COMPONENT_TYPE_CLIENT
			and cp.propertyTypeId = 1046		-- CV_COMPONENT_SHAREPOINT_SECONDARY_MEMBER_SERVERS		-- Old APP_ClientProp 'SharePoint Member Servers'
			and cp.modified = 0
	)
	INSERT INTO @EntityList
	SELECT
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		''
	FROM    @spMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
	UPDATE @EntityList
	SET spVersion = attrval from App_clientProp where componentNameId = @psuedoEntityId
	and attrName = 'SharePoint Client Version' and modified =0
END
IF @getOnlyMemberServers = 1
BEGIN
	delete @EntityList where clientId =0
	-- Backup Proxy List : So delete clients with no SP packages. SP DOC package id = 101.
	delete @EntityList where clientId not in (select E.clientId from  @EntityList E,simInstalledPackages SIP where
	E.clientId = SIP.ClientId and SIP.simPackageID = 101)
	-- Backup Proxy List : So delete clients with deconfigured/deleted VSA agents
	delete @EntityList where clientId in (select E.clientId from  @EntityList E,App_IdaName Ida where
	E.clientId = Ida.ClientId and Ida.appTypeId = 78 and ((status & 2) = 2 or (status & 4) = 4))
	set @spMemberServers = (select spVersion as '@sharePointVersion',
									(SELECT
									C.id as '@clientId',
									C.name as '@clientName',
										C.net_hostname as '@hostName'
								FROM APP_Client C
								where C.id = clientId
								FOR XML PATH('client'),TYPE)
					FROM @EntityList order by priority
					FOR XML PATH('memberServers'),TYPE)
	SET @xmlText = (select
							(select @spMemberServers
							 FOR XML PATH ('spMemberServers'),TYPE)
					FOR XML PATH(''),ROOT('App_GetSPMemberServersResponse'))
END
ELSE
BEGIN
	DECLARE @primaryMemberServer INT = 0
	DECLARE @spClientVersion varchar(10)
	SET @primaryMemberServer = (SELECT attrval from App_clientProp where componentNameId = @psuedoEntityId
	and attrName = 'SharePoint Primary Member Server' and modified =0)
	SET @spClientVersion =
	(SELECT attrval from App_clientProp where componentNameId = @psuedoEntityId
	and attrName = 'SharePoint Client Version' and modified =0)
	set @spMemberServers = (SELECT @spClientVersion as '@sharePointVersion',
							(SELECT (SELECT C.id as '@clientId',
									C.name as '@clientName',
									C.net_hostname as '@hostName'
									FROM APP_Client C
									where C.id = @primaryMemberServer
									FOR XML PATH('client'),TYPE)
									FOR XML PATH('primaryMemberServer'),TYPE),
							(select		(SELECT
												(SELECT
												C.id as '@clientId',
												C.name as '@clientName',
												C.net_hostname as '@hostName'
												FROM APP_Client C
												where C.id = clientId
												FOR XML PATH('client'),TYPE)
												FROM @EntityList order by priority
										FOR XML PATH('memberServers'),TYPE)
							 FOR XML PATH('spMemberServers'),TYPE
							)
							FOR XML PATH ('sharepointPseudoClientProperties'),TYPE)
	SET @xmlText = @spMemberServers
END
select @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSharePointMemberServers')
	delete from GxQscripts where name = 'AppGetSharePointMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSharePointMemberServers')
	delete from GXDBVersions where aliasname = 'AppGetSharePointMemberServers'
GO

insert into GXDBVersions values(2, 'AppGetSharePointMemberServers',  '00000000000000000000', 'AppGetSharePointMemberServers', '00000000000000000000')
GO

