

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSessionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSessionInfo.sp,v $ $Id: AppGetSessionInfo.sp,v 1.1.4.3 2018/03/27 08:18:32 jiechen Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetSessionInfo()
--  |
--  | Description:  SP for retrieving session information
--  |
--  |       Input:  GetSessionInfoRequest XML containing session guid--  |
--  |      Output:  GetSessionInfoRespone containing hostname, deviceId, consoleType, userInfo and error to determine status of the operation--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	To get session information
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSessionInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetSessionInfo')
	drop procedure AppGetSessionInfo
IF EXISTS (select * from GxQscripts where name='AppGetSessionInfo')
	delete from GxQscripts where name = 'AppGetSessionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSessionInfo')
	delete from GXDBVersions where aliasname = 'AppGetSessionInfo'
GO
print '... Creating Procedure: AppGetSessionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSessionInfo
  @i_xml XML	
AS
DECLARE @sessionGuid as nvarchar(510)
DECLARE @sessionInfo XML
DECLARE @error XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET  @sessionGuid   = ISNULL((SELECT ref.value('@sessionGuid','nvarchar(510)') FROM @i_xml.nodes('Api_GetSessionInfoRequest') R ( ref )), '')
	IF (@sessionGuid = '' )
    BEGIN
		RAISERROR ('SessionId is mandatory to get session information.', 16, 1 )
    END
	IF NOT EXISTS (SELECT 1 FROM UMQSDKSessions (NOLOCK) WHERE guid = @sessionGuid)
    BEGIN
		RAISERROR ('No Session information found.', 16, 1 )
    END
	 SET @sessionInfo = (	SELECT	Top 1 @sessionGuid '@sessionGuid',
									QS.hostName as '@hostName',
									QS.consoleType as '@consoleType',
									USR.login as '@loginId',
									SA.deviceId as '@deviceId',
									(
										SELECT	QS.userId as '@userId',
												USR.userGuid as '@userGUID',
												USR.Name as '@userName'
										FOR XML PATH('userInfo'),TYPE
									)
							FROM UMQSDKSessions QS (NOLOCK)
                            LEFT OUTER JOIN UMUSERS USR (NOLOCK) ON QS.userId = USR.id
                            LEFT OUTER JOIN UMSessionAudit SA WITH (NOLOCK) ON CAST(QS.GUID as varchar(510)) = SA.SessionId
							WHERE QS.guid = @sessionGuid
							FOR XML PATH('session'), TYPE
                         )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @error = ( SELECT
                            ERROR_NUMBER() '@errorCode',
                            'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
                           FOR XML PATH('error'), TYPE
                         )
END  CATCH
	SELECT @sessionInfo, @error FOR XML PATH('Api_GetSessionInformationResponse'),TYPE
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSessionInfo')
	delete from GxQscripts where name = 'AppGetSessionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSessionInfo')
	delete from GXDBVersions where aliasname = 'AppGetSessionInfo'
GO

insert into GXDBVersions values(2, 'AppGetSessionInfo',  '00010001000400030000', 'AppGetSessionInfo', '00010001000400030000')
GO

